/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BooleanArray;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ShortArray;

class Triangulator {
    private final Array<FloatArray> convexPolygons = new Array(false, 8, FloatArray[]::new);
    private final Array<ShortArray> convexPolygonsIndices = new Array(false, 8, ShortArray[]::new);
    private final ShortArray indicesArray = new ShortArray();
    private final BooleanArray isConcaveArray = new BooleanArray();
    private final ShortArray triangles = new ShortArray();
    private final Pool<FloatArray> polygonPool = new Pool(){

        protected FloatArray newObject() {
            return new FloatArray(16);
        }
    };
    private final Pool<ShortArray> polygonIndicesPool = new Pool(){

        protected ShortArray newObject() {
            return new ShortArray(16);
        }
    };

    Triangulator() {
    }

    /*
     * Unable to fully structure code
     */
    public ShortArray triangulate(FloatArray var1_1) {
        var2_2 = var1_1.items;
        var3_3 = var1_1.size >> 1;
        var4_4 = this.indicesArray;
        var4_4.clear();
        var5_5 = var4_4.setSize(var3_3);
        for (var6_6 = 0; var6_6 < var3_3; var6_6 = (int)((short)(var6_6 + 1))) {
            var5_5[var6_6] = var6_6;
        }
        var6_7 = this.isConcaveArray;
        var7_8 = var6_7.setSize(var3_3);
        var9_11 = var3_3;
        for (var8_9 = 0; var8_9 < var9_11; ++var8_9) {
            var7_8[var8_9] = Triangulator.isConcave(var8_9, var3_3, var2_2, var5_5);
        }
        var8_10 = this.triangles;
        var8_10.clear();
        var8_10.ensureCapacity(Math.max(0, var3_3 - 2) << 2);
        while (var3_3 > 3) {
            var9_11 = var3_3 - 1;
            var10_12 = 0;
            var11_13 = 1;
            block3: while (true) {
                if (var7_8[var10_12]) ** GOTO lbl39
                var12_14 = var5_5[var9_11] << 1;
                var13_15 = var5_5[var10_12] << 1;
                var14_16 = var5_5[var11_13] << 1;
                var15_17 = var2_2[var12_14];
                var16_18 = var2_2[var12_14 + 1];
                var17_19 = var2_2[var13_15];
                var18_20 = var2_2[var13_15 + 1];
                var19_21 = var2_2[var14_16];
                var20_22 = var2_2[var14_16 + 1];
                var21_23 = (var11_13 + 1) % var3_3;
                while (var21_23 != var9_11) {
                    if (!(var7_8[var21_23] && Triangulator.positiveArea(var19_21, var20_22, var15_17, var16_18, var23_25 = var2_2[var22_24 = var5_5[var21_23] << 1], var24_26 = var2_2[var22_24 + 1]) && Triangulator.positiveArea(var15_17, var16_18, var17_19, var18_20, var23_25, var24_26) && Triangulator.positiveArea(var17_19, var18_20, var19_21, var20_22, var23_25, var24_26))) {
                        var21_23 = (var21_23 + 1) % var3_3;
                        continue;
                    }
lbl39:
                    // 3 sources

                    if (var11_13 == 0) {
                        while (var7_8[var10_12] && --var10_12 > 0) {
                        }
                        break block3;
                    }
                    var9_11 = var10_12;
                    var10_12 = var11_13;
                    var11_13 = (var11_13 + 1) % var3_3;
                    continue block3;
                }
                break;
            }
            var8_10.add(var5_5[(var3_3 + var10_12 - 1) % var3_3]);
            var8_10.add(var5_5[var10_12]);
            var8_10.add(var5_5[(var10_12 + 1) % var3_3]);
            var4_4.removeIndex(var10_12);
            var6_7.removeIndex(var10_12);
            var12_14 = (--var3_3 + var10_12 - 1) % var3_3;
            var13_15 = var10_12 == var3_3 ? 0 : var10_12;
            var7_8[var12_14] = Triangulator.isConcave(var12_14, var3_3, var2_2, var5_5);
            var7_8[var13_15] = Triangulator.isConcave(var13_15, var3_3, var2_2, var5_5);
        }
        if (var3_3 == 3) {
            var8_10.add(var5_5[2]);
            var8_10.add(var5_5[0]);
            var8_10.add(var5_5[1]);
        }
        return var8_10;
    }

    public Array<FloatArray> decompose(FloatArray floatArray, ShortArray shortArray) {
        float f;
        float f2;
        float f3;
        int n;
        int n2;
        int n3;
        float[] fArray = floatArray.items;
        Array<FloatArray> array = this.convexPolygons;
        this.polygonPool.freeAll(array);
        array.clear();
        Array<ShortArray> array2 = this.convexPolygonsIndices;
        this.polygonIndicesPool.freeAll(array2);
        array2.clear();
        ShortArray shortArray2 = this.polygonIndicesPool.obtain();
        shortArray2.clear();
        FloatArray floatArray2 = this.polygonPool.obtain();
        floatArray2.clear();
        int n4 = -1;
        int n5 = 0;
        short[] sArray = shortArray.items;
        int n6 = shortArray.size;
        for (int i = 0; i < n6; i += 3) {
            n3 = sArray[i] << 1;
            n2 = sArray[i + 1] << 1;
            n = sArray[i + 2] << 1;
            float f4 = fArray[n3];
            float f5 = fArray[n3 + 1];
            float f6 = fArray[n2];
            f3 = fArray[n2 + 1];
            f2 = fArray[n];
            f = fArray[n + 1];
            boolean bl = false;
            if (n4 == n3) {
                int n7 = floatArray2.size - 4;
                float[] fArray2 = floatArray2.items;
                int n8 = Triangulator.winding(fArray2[n7], fArray2[n7 + 1], fArray2[n7 + 2], fArray2[n7 + 3], f2, f);
                int n9 = Triangulator.winding(f2, f, fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                if (n8 == n5 && n9 == n5) {
                    floatArray2.add(f2);
                    floatArray2.add(f);
                    shortArray2.add(n);
                    bl = true;
                }
            }
            if (bl) continue;
            if (floatArray2.size > 0) {
                array.add(floatArray2);
                array2.add(shortArray2);
                floatArray2 = this.polygonPool.obtain();
                shortArray2 = this.polygonIndicesPool.obtain();
            }
            floatArray2.clear();
            floatArray2.add(f4);
            floatArray2.add(f5);
            floatArray2.add(f6);
            floatArray2.add(f3);
            floatArray2.add(f2);
            floatArray2.add(f);
            shortArray2.clear();
            shortArray2.add(n3);
            shortArray2.add(n2);
            shortArray2.add(n);
            n5 = Triangulator.winding(f4, f5, f6, f3, f2, f);
            n4 = n3;
        }
        if (floatArray2.size > 0) {
            array.add(floatArray2);
            array2.add(shortArray2);
        }
        ShortArray[] shortArrayArray = (ShortArray[])array2.items;
        FloatArray[] floatArrayArray = (FloatArray[])array.items;
        n2 = array.size;
        for (n3 = 0; n3 < n2; ++n3) {
            shortArray2 = shortArrayArray[n3];
            if (shortArray2.size == 0) continue;
            n = shortArray2.first();
            short s = shortArray2.items[shortArray2.size - 1];
            floatArray2 = floatArrayArray[n3];
            int n10 = floatArray2.size - 4;
            float[] fArray3 = floatArray2.items;
            f3 = fArray3[n10];
            f2 = fArray3[n10 + 1];
            f = fArray3[n10 + 2];
            float f7 = fArray3[n10 + 3];
            float f8 = fArray3[0];
            float f9 = fArray3[1];
            float f10 = fArray3[2];
            float f11 = fArray3[3];
            int n11 = Triangulator.winding(f3, f2, f, f7, f8, f9);
            for (int i = 0; i < n2; ++i) {
                if (i == n3) continue;
                ShortArray shortArray3 = shortArrayArray[i];
                if (shortArray3.size != 3) continue;
                short s2 = shortArray3.first();
                short s3 = shortArray3.items[1];
                short s4 = shortArray3.items[2];
                FloatArray floatArray3 = floatArrayArray[i];
                float f12 = floatArray3.items[floatArray3.size - 2];
                float f13 = floatArray3.items[floatArray3.size - 1];
                if (s2 != n || s3 != s) continue;
                int n12 = Triangulator.winding(f3, f2, f, f7, f12, f13);
                int n13 = Triangulator.winding(f12, f13, f8, f9, f10, f11);
                if (n12 != n11 || n13 != n11) continue;
                floatArray3.clear();
                shortArray3.clear();
                floatArray2.add(f12);
                floatArray2.add(f13);
                shortArray2.add((int)s4);
                f3 = f;
                f2 = f7;
                f = f12;
                f7 = f13;
                i = 0;
            }
        }
        for (n3 = array.size - 1; n3 >= 0; --n3) {
            floatArray2 = floatArrayArray[n3];
            if (floatArray2.size != 0) continue;
            array.removeIndex(n3);
            this.polygonPool.free(floatArray2);
            shortArray2 = array2.removeIndex(n3);
            this.polygonIndicesPool.free(shortArray2);
        }
        return array;
    }

    private static boolean isConcave(int n, int n2, float[] fArray, short[] sArray) {
        int n3 = sArray[(n2 + n - 1) % n2] << 1;
        int n4 = sArray[n] << 1;
        int n5 = sArray[(n + 1) % n2] << 1;
        return !Triangulator.positiveArea(fArray[n3], fArray[n3 + 1], fArray[n4], fArray[n4 + 1], fArray[n5], fArray[n5 + 1]);
    }

    private static boolean positiveArea(float f, float f2, float f3, float f4, float f5, float f6) {
        return f * (f6 - f4) + f3 * (f2 - f6) + f5 * (f4 - f2) >= 0.0f;
    }

    private static int winding(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f4 - f2;
        float f8 = f3 - f;
        return f5 * f7 - f6 * f8 + f8 * f2 - f * f7 >= 0.0f ? 1 : -1;
    }
}

