/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ObjectSet;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.PhysicsConstraint;
import com.esotericsoftware.spine.PhysicsConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.HasTextureRegion;
import com.esotericsoftware.spine.attachments.Sequence;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Animation {
    final String name;
    Array<Timeline> timelines;
    final ObjectSet<String> timelineIds;
    float duration;

    public Animation(String string, Array<Timeline> array, float f) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = string;
        this.duration = f;
        this.timelineIds = new ObjectSet(array.size);
        this.setTimelines(array);
    }

    public void setTimelines(Array<Timeline> array) {
        if (array == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.timelines = array;
        int n = array.size;
        this.timelineIds.clear(n);
        T[] TArray = array.items;
        for (int i = 0; i < n; ++i) {
            this.timelineIds.addAll((String[])((Timeline)TArray[i]).getPropertyIds());
        }
    }

    public boolean hasTimeline(String[] stringArray) {
        for (String string : stringArray) {
            if (!this.timelineIds.contains(string)) continue;
            return true;
        }
        return false;
    }

    public float getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static abstract class Timeline {
        private final String[] propertyIds;
        final float[] frames;

        public Timeline(int n, String ... stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("propertyIds cannot be null.");
            }
            this.propertyIds = stringArray;
            this.frames = new float[n * this.getFrameEntries()];
        }

        public String[] getPropertyIds() {
            return this.propertyIds;
        }

        public int getFrameEntries() {
            return 1;
        }

        public int getFrameCount() {
            return this.frames.length / this.getFrameEntries();
        }

        public float getDuration() {
            return this.frames[this.frames.length - this.getFrameEntries()];
        }

        public abstract void apply(Skeleton var1, float var2, float var3, Array<Event> var4, float var5, MixBlend var6, MixDirection var7);

        static int search(float[] fArray, float f) {
            int n = fArray.length;
            for (int i = 1; i < n; ++i) {
                if (!(fArray[i] > f)) continue;
                return i - 1;
            }
            return n - 1;
        }

        static int search(float[] fArray, float f, int n) {
            int n2 = fArray.length;
            for (int i = n; i < n2; i += n) {
                if (!(fArray[i] > f)) continue;
                return i - n;
            }
            return n2 - n;
        }
    }

    public static enum MixBlend {
        setup,
        first,
        replace,
        add;

    }

    public static enum MixDirection {
        in,
        out;

    }

    public static class SequenceTimeline
    extends Timeline {
        final int slotIndex;
        final HasTextureRegion attachment;

        public SequenceTimeline(int n, int n2, Attachment attachment) {
            super(n, Property.sequence.ordinal() + "|" + n2 + "|" + ((HasTextureRegion)((Object)attachment)).getSequence().getId());
            this.slotIndex = n2;
            this.attachment = (HasTextureRegion)((Object)attachment);
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        public void setFrame(int n, float f, Sequence.SequenceMode sequenceMode, int n2, float f2) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = sequenceMode.ordinal() | n2 << 4;
            this.frames[n + 2] = f2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            Attachment attachment = slot.attachment;
            if (!(attachment == this.attachment || attachment instanceof VertexAttachment && ((VertexAttachment)attachment).getTimelineAttachment() == this.attachment)) {
                return;
            }
            Sequence sequence = ((HasTextureRegion)((Object)attachment)).getSequence();
            if (sequence == null) {
                return;
            }
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    slot.setSequenceIndex(-1);
                }
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    slot.setSequenceIndex(-1);
                }
                return;
            }
            int n = SequenceTimeline.search(fArray, f2, 3);
            float f4 = fArray[n];
            int n2 = (int)fArray[n + 1];
            float f5 = fArray[n + 2];
            int n3 = n2 >> 4;
            int n4 = sequence.getRegions().length;
            Sequence.SequenceMode sequenceMode = Sequence.SequenceMode.values[n2 & 0xF];
            if (sequenceMode != Sequence.SequenceMode.hold) {
                n3 = (int)((float)n3 + ((f2 - f4) / f5 + 1.0E-4f));
                switch (sequenceMode) {
                    case once: {
                        n3 = Math.min(n4 - 1, n3);
                        break;
                    }
                    case loop: {
                        n3 %= n4;
                        break;
                    }
                    case pingpong: {
                        int n5 = (n4 << 1) - 2;
                        int n6 = n3 = n5 == 0 ? 0 : n3 % n5;
                        if (n3 < n4) break;
                        n3 = n5 - n3;
                        break;
                    }
                    case onceReverse: {
                        n3 = Math.max(n4 - 1 - n3, 0);
                        break;
                    }
                    case loopReverse: {
                        n3 = n4 - 1 - n3 % n4;
                        break;
                    }
                    case pingpongReverse: {
                        int n7 = (n4 << 1) - 2;
                        int n8 = n3 = n7 == 0 ? 0 : (n3 + n4 - 1) % n7;
                        if (n3 < n4) break;
                        n3 = n7 - n3;
                    }
                }
            }
            slot.setSequenceIndex(n3);
        }
    }

    public static class PhysicsConstraintResetTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.physicsConstraintReset.ordinal())};
        final int constraintIndex;

        public PhysicsConstraintResetTimeline(int n, int n2) {
            super(n, propertyIds);
            this.constraintIndex = n2;
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f) {
            this.frames[n] = f;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            PhysicsConstraint physicsConstraint = null;
            if (this.constraintIndex != -1) {
                physicsConstraint = skeleton.physicsConstraints.get(this.constraintIndex);
                if (!physicsConstraint.active) {
                    return;
                }
            }
            float[] fArray = this.frames;
            if (f > f2) {
                this.apply(skeleton, f, 2.1474836E9f, null, f3, mixBlend, mixDirection);
                f = -1.0f;
            } else if (f >= fArray[fArray.length - 1]) {
                return;
            }
            if (f2 < fArray[0]) {
                return;
            }
            if (f < fArray[0] || f2 >= fArray[PhysicsConstraintResetTimeline.search(fArray, f) + 1]) {
                if (physicsConstraint != null) {
                    physicsConstraint.reset();
                } else {
                    T[] TArray = skeleton.physicsConstraints.items;
                    int n = skeleton.physicsConstraints.size;
                    for (int i = 0; i < n; ++i) {
                        physicsConstraint = (PhysicsConstraint)TArray[i];
                        if (!physicsConstraint.active) continue;
                        physicsConstraint.reset();
                    }
                }
            }
        }
    }

    public static class PhysicsConstraintMixTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintMixTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintMix);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.data.mix;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.mix;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.mix = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.mixGlobal;
        }
    }

    public static class PhysicsConstraintGravityTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintGravityTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintGravity);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.data.gravity;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.gravity;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.gravity = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.gravityGlobal;
        }
    }

    public static class PhysicsConstraintWindTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintWindTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintWind);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.data.wind;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.wind;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.wind = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.windGlobal;
        }
    }

    public static class PhysicsConstraintMassTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintMassTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintMass);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return 1.0f / physicsConstraint.data.massInverse;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return 1.0f / physicsConstraint.massInverse;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.massInverse = 1.0f / f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.massGlobal;
        }
    }

    public static class PhysicsConstraintDampingTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintDampingTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintDamping);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.data.damping;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.damping;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.damping = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.dampingGlobal;
        }
    }

    public static class PhysicsConstraintStrengthTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintStrengthTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintStrength);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.data.strength;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.strength;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.strength = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.strengthGlobal;
        }
    }

    public static class PhysicsConstraintInertiaTimeline
    extends PhysicsConstraintTimeline {
        public PhysicsConstraintInertiaTimeline(int n, int n2, int n3) {
            super(n, n2, n3, Property.physicsConstraintInertia);
        }

        @Override
        protected float setup(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.data.inertia;
        }

        @Override
        protected float get(PhysicsConstraint physicsConstraint) {
            return physicsConstraint.inertia;
        }

        @Override
        protected void set(PhysicsConstraint physicsConstraint, float f) {
            physicsConstraint.inertia = f;
        }

        @Override
        protected boolean global(PhysicsConstraintData physicsConstraintData) {
            return physicsConstraintData.inertiaGlobal;
        }
    }

    public static abstract class PhysicsConstraintTimeline
    extends CurveTimeline1 {
        final int constraintIndex;

        public PhysicsConstraintTimeline(int n, int n2, int n3, Property property) {
            super(n, n2, property.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            if (this.constraintIndex == -1) {
                float f4 = f2 >= this.frames[0] ? this.getCurveValue(f2) : 0.0f;
                T[] TArray = skeleton.physicsConstraints.items;
                int n = skeleton.physicsConstraints.size;
                for (int i = 0; i < n; ++i) {
                    PhysicsConstraint physicsConstraint = (PhysicsConstraint)TArray[i];
                    if (!physicsConstraint.active || !this.global(physicsConstraint.data)) continue;
                    this.set(physicsConstraint, this.getAbsoluteValue(f2, f3, mixBlend, this.get(physicsConstraint), this.setup(physicsConstraint), f4));
                }
            } else {
                PhysicsConstraint physicsConstraint = skeleton.physicsConstraints.get(this.constraintIndex);
                if (physicsConstraint.active) {
                    this.set(physicsConstraint, this.getAbsoluteValue(f2, f3, mixBlend, this.get(physicsConstraint), this.setup(physicsConstraint)));
                }
            }
        }

        protected abstract float setup(PhysicsConstraint var1);

        protected abstract float get(PhysicsConstraint var1);

        protected abstract void set(PhysicsConstraint var1, float var2);

        protected abstract boolean global(PhysicsConstraintData var1);
    }

    public static class PathConstraintMixTimeline
    extends CurveTimeline {
        final int constraintIndex;

        public PathConstraintMixTimeline(int n, int n2, int n3) {
            super(n, n2, Property.pathConstraintMix.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 4;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4) {
            this.frames[n <<= 2] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.constraintIndex);
            if (!pathConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                PathConstraintData pathConstraintData = pathConstraint.data;
                switch (mixBlend) {
                    case setup: {
                        pathConstraint.mixRotate = pathConstraintData.mixRotate;
                        pathConstraint.mixX = pathConstraintData.mixX;
                        pathConstraint.mixY = pathConstraintData.mixY;
                        return;
                    }
                    case first: {
                        pathConstraint.mixRotate += (pathConstraintData.mixRotate - pathConstraint.mixRotate) * f3;
                        pathConstraint.mixX += (pathConstraintData.mixX - pathConstraint.mixX) * f3;
                        pathConstraint.mixY += (pathConstraintData.mixY - pathConstraint.mixY) * f3;
                    }
                }
                return;
            }
            int n = PathConstraintMixTimeline.search(fArray, f2, 4);
            int n2 = (int)this.curves[n >> 2];
            switch (n2) {
                case 0: {
                    float f7 = fArray[n];
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    float f8 = (f2 - f7) / (fArray[n + 4] - f7);
                    f6 += (fArray[n + 4 + 1] - f6) * f8;
                    f5 += (fArray[n + 4 + 2] - f5) * f8;
                    f4 += (fArray[n + 4 + 3] - f4) * f8;
                    break;
                }
                case 1: {
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    break;
                }
                default: {
                    f6 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f5 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f4 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                }
            }
            if (mixBlend == MixBlend.setup) {
                PathConstraintData pathConstraintData = pathConstraint.data;
                pathConstraint.mixRotate = pathConstraintData.mixRotate + (f6 - pathConstraintData.mixRotate) * f3;
                pathConstraint.mixX = pathConstraintData.mixX + (f5 - pathConstraintData.mixX) * f3;
                pathConstraint.mixY = pathConstraintData.mixY + (f4 - pathConstraintData.mixY) * f3;
            } else {
                pathConstraint.mixRotate += (f6 - pathConstraint.mixRotate) * f3;
                pathConstraint.mixX += (f5 - pathConstraint.mixX) * f3;
                pathConstraint.mixY += (f4 - pathConstraint.mixY) * f3;
            }
        }
    }

    public static class PathConstraintSpacingTimeline
    extends CurveTimeline1 {
        final int constraintIndex;

        public PathConstraintSpacingTimeline(int n, int n2, int n3) {
            super(n, n2, Property.pathConstraintSpacing.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.constraintIndex);
            if (pathConstraint.active) {
                pathConstraint.spacing = this.getAbsoluteValue(f2, f3, mixBlend, pathConstraint.spacing, pathConstraint.data.spacing);
            }
        }
    }

    public static class PathConstraintPositionTimeline
    extends CurveTimeline1 {
        final int constraintIndex;

        public PathConstraintPositionTimeline(int n, int n2, int n3) {
            super(n, n2, Property.pathConstraintPosition.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.constraintIndex);
            if (pathConstraint.active) {
                pathConstraint.position = this.getAbsoluteValue(f2, f3, mixBlend, pathConstraint.position, pathConstraint.data.position);
            }
        }
    }

    public static class TransformConstraintTimeline
    extends CurveTimeline {
        final int constraintIndex;

        public TransformConstraintTimeline(int n, int n2, int n3) {
            super(n, n2, Property.transformConstraint.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 7;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
            this.frames[n *= 7] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            TransformConstraint transformConstraint = skeleton.transformConstraints.get(this.constraintIndex);
            if (!transformConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                TransformConstraintData transformConstraintData = transformConstraint.data;
                switch (mixBlend) {
                    case setup: {
                        transformConstraint.mixRotate = transformConstraintData.mixRotate;
                        transformConstraint.mixX = transformConstraintData.mixX;
                        transformConstraint.mixY = transformConstraintData.mixY;
                        transformConstraint.mixScaleX = transformConstraintData.mixScaleX;
                        transformConstraint.mixScaleY = transformConstraintData.mixScaleY;
                        transformConstraint.mixShearY = transformConstraintData.mixShearY;
                        return;
                    }
                    case first: {
                        transformConstraint.mixRotate += (transformConstraintData.mixRotate - transformConstraint.mixRotate) * f3;
                        transformConstraint.mixX += (transformConstraintData.mixX - transformConstraint.mixX) * f3;
                        transformConstraint.mixY += (transformConstraintData.mixY - transformConstraint.mixY) * f3;
                        transformConstraint.mixScaleX += (transformConstraintData.mixScaleX - transformConstraint.mixScaleX) * f3;
                        transformConstraint.mixScaleY += (transformConstraintData.mixScaleY - transformConstraint.mixScaleY) * f3;
                        transformConstraint.mixShearY += (transformConstraintData.mixShearY - transformConstraint.mixShearY) * f3;
                    }
                }
                return;
            }
            int n = TransformConstraintTimeline.search(fArray, f2, 7);
            int n2 = (int)this.curves[n / 7];
            switch (n2) {
                case 0: {
                    float f10 = fArray[n];
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    float f11 = (f2 - f10) / (fArray[n + 7] - f10);
                    f9 += (fArray[n + 7 + 1] - f9) * f11;
                    f8 += (fArray[n + 7 + 2] - f8) * f11;
                    f7 += (fArray[n + 7 + 3] - f7) * f11;
                    f6 += (fArray[n + 7 + 4] - f6) * f11;
                    f5 += (fArray[n + 7 + 5] - f5) * f11;
                    f4 += (fArray[n + 7 + 6] - f4) * f11;
                    break;
                }
                case 1: {
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    break;
                }
                default: {
                    f9 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f8 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f7 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                    f6 = this.getBezierValue(f2, n, 4, n2 + 54 - 2);
                    f5 = this.getBezierValue(f2, n, 5, n2 + 72 - 2);
                    f4 = this.getBezierValue(f2, n, 6, n2 + 90 - 2);
                }
            }
            if (mixBlend == MixBlend.setup) {
                TransformConstraintData transformConstraintData = transformConstraint.data;
                transformConstraint.mixRotate = transformConstraintData.mixRotate + (f9 - transformConstraintData.mixRotate) * f3;
                transformConstraint.mixX = transformConstraintData.mixX + (f8 - transformConstraintData.mixX) * f3;
                transformConstraint.mixY = transformConstraintData.mixY + (f7 - transformConstraintData.mixY) * f3;
                transformConstraint.mixScaleX = transformConstraintData.mixScaleX + (f6 - transformConstraintData.mixScaleX) * f3;
                transformConstraint.mixScaleY = transformConstraintData.mixScaleY + (f5 - transformConstraintData.mixScaleY) * f3;
                transformConstraint.mixShearY = transformConstraintData.mixShearY + (f4 - transformConstraintData.mixShearY) * f3;
            } else {
                transformConstraint.mixRotate += (f9 - transformConstraint.mixRotate) * f3;
                transformConstraint.mixX += (f8 - transformConstraint.mixX) * f3;
                transformConstraint.mixY += (f7 - transformConstraint.mixY) * f3;
                transformConstraint.mixScaleX += (f6 - transformConstraint.mixScaleX) * f3;
                transformConstraint.mixScaleY += (f5 - transformConstraint.mixScaleY) * f3;
                transformConstraint.mixShearY += (f4 - transformConstraint.mixShearY) * f3;
            }
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline {
        final int constraintIndex;

        public IkConstraintTimeline(int n, int n2, int n3) {
            super(n, n2, Property.ikConstraint.ordinal() + "|" + n3);
            this.constraintIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 6;
        }

        public void setFrame(int n, float f, float f2, float f3, int n2, boolean bl, boolean bl2) {
            this.frames[n *= 6] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = n2;
            this.frames[n + 4] = bl ? 1.0f : 0.0f;
            this.frames[n + 5] = bl2 ? 1.0f : 0.0f;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            IkConstraint ikConstraint = skeleton.ikConstraints.get(this.constraintIndex);
            if (!ikConstraint.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        ikConstraint.mix = ikConstraint.data.mix;
                        ikConstraint.softness = ikConstraint.data.softness;
                        ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                        ikConstraint.compress = ikConstraint.data.compress;
                        ikConstraint.stretch = ikConstraint.data.stretch;
                        return;
                    }
                    case first: {
                        ikConstraint.mix += (ikConstraint.data.mix - ikConstraint.mix) * f3;
                        ikConstraint.softness += (ikConstraint.data.softness - ikConstraint.softness) * f3;
                        ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                        ikConstraint.compress = ikConstraint.data.compress;
                        ikConstraint.stretch = ikConstraint.data.stretch;
                    }
                }
                return;
            }
            int n = IkConstraintTimeline.search(fArray, f2, 6);
            int n2 = (int)this.curves[n / 6];
            switch (n2) {
                case 0: {
                    float f6 = fArray[n];
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    float f7 = (f2 - f6) / (fArray[n + 6] - f6);
                    f5 += (fArray[n + 6 + 1] - f5) * f7;
                    f4 += (fArray[n + 6 + 2] - f4) * f7;
                    break;
                }
                case 1: {
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    break;
                }
                default: {
                    f5 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f4 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                }
            }
            if (mixBlend == MixBlend.setup) {
                ikConstraint.mix = ikConstraint.data.mix + (f5 - ikConstraint.data.mix) * f3;
                ikConstraint.softness = ikConstraint.data.softness + (f4 - ikConstraint.data.softness) * f3;
                if (mixDirection == MixDirection.out) {
                    ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                    ikConstraint.compress = ikConstraint.data.compress;
                    ikConstraint.stretch = ikConstraint.data.stretch;
                } else {
                    ikConstraint.bendDirection = (int)fArray[n + 3];
                    ikConstraint.compress = fArray[n + 4] != 0.0f;
                    ikConstraint.stretch = fArray[n + 5] != 0.0f;
                }
            } else {
                ikConstraint.mix += (f5 - ikConstraint.mix) * f3;
                ikConstraint.softness += (f4 - ikConstraint.softness) * f3;
                if (mixDirection == MixDirection.in) {
                    ikConstraint.bendDirection = (int)fArray[n + 3];
                    ikConstraint.compress = fArray[n + 4] != 0.0f;
                    ikConstraint.stretch = fArray[n + 5] != 0.0f;
                }
            }
        }
    }

    public static class DrawOrderTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.drawOrder.ordinal())};
        private final int[][] drawOrders;

        public DrawOrderTimeline(int n) {
            super(n, propertyIds);
            this.drawOrders = new int[n][];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f, int[] nArray) {
            this.frames[n] = f;
            this.drawOrders[n] = nArray;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
                }
                return;
            }
            if (f2 < this.frames[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
                }
                return;
            }
            int[] nArray = this.drawOrders[DrawOrderTimeline.search(this.frames, f2)];
            if (nArray == null) {
                SpineUtils.arraycopy(skeleton.slots.items, 0, skeleton.drawOrder.items, 0, skeleton.slots.size);
            } else {
                T[] TArray = skeleton.slots.items;
                T[] TArray2 = skeleton.drawOrder.items;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    TArray2[i] = TArray[nArray[i]];
                }
            }
        }
    }

    public static class EventTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.event.ordinal())};
        private final Event[] events;

        public EventTimeline(int n) {
            super(n, propertyIds);
            this.events = new Event[n];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, Event event) {
            this.frames[n] = event.time;
            this.events[n] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            int n;
            if (array == null) {
                return;
            }
            float[] fArray = this.frames;
            int n2 = fArray.length;
            if (f > f2) {
                this.apply(skeleton, f, 2.1474836E9f, array, f3, mixBlend, mixDirection);
                f = -1.0f;
            } else if (f >= fArray[n2 - 1]) {
                return;
            }
            if (f2 < fArray[0]) {
                return;
            }
            if (f < fArray[0]) {
                n = 0;
            } else {
                float f4 = fArray[n];
                for (n = EventTimeline.search(fArray, f) + 1; n > 0 && fArray[n - 1] == f4; --n) {
                }
            }
            while (n < n2 && f2 >= fArray[n]) {
                array.add(this.events[n]);
                ++n;
            }
        }
    }

    public static class DeformTimeline
    extends CurveTimeline {
        final int slotIndex;
        final VertexAttachment attachment;
        private final float[][] vertices;

        public DeformTimeline(int n, int n2, int n3, VertexAttachment vertexAttachment) {
            super(n, n2, Property.deform.ordinal() + "|" + n3 + "|" + vertexAttachment.getId());
            this.slotIndex = n3;
            this.attachment = vertexAttachment;
            this.vertices = new float[n][];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f, float[] fArray) {
            this.frames[n] = f;
            this.vertices[n] = fArray;
        }

        @Override
        public void setBezier(int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = this.curves;
            int n4 = this.getFrameCount() + n * 18;
            if (n3 == 0) {
                fArray[n2] = 2 + n4;
            }
            float f9 = (f - f3 * 2.0f + f5) * 0.03f;
            float f10 = f6 * 0.03f - f4 * 0.06f;
            float f11 = ((f3 - f5) * 3.0f - f + f7) * 0.006f;
            float f12 = (f4 - f6 + 0.33333334f) * 0.018f;
            float f13 = f9 * 2.0f + f11;
            float f14 = f10 * 2.0f + f12;
            float f15 = (f3 - f) * 0.3f + f9 + f11 * 0.16666667f;
            float f16 = f4 * 0.3f + f10 + f12 * 0.16666667f;
            float f17 = f + f15;
            float f18 = f16;
            int n5 = n4 + 18;
            while (n4 < n5) {
                fArray[n4] = f17;
                fArray[n4 + 1] = f18;
                f17 += (f15 += (f13 += f11));
                f18 += (f16 += (f14 += f12));
                n4 += 2;
            }
        }

        private float getCurvePercent(float f, int n) {
            float[] fArray = this.curves;
            int n2 = (int)fArray[n];
            switch (n2) {
                case 0: {
                    float f2 = this.frames[n];
                    return (f - f2) / (this.frames[n + this.getFrameEntries()] - f2);
                }
                case 1: {
                    return 0.0f;
                }
            }
            n2 -= 2;
            if (fArray[n2] > f) {
                float f3 = this.frames[n];
                return fArray[n2 + 1] * (f - f3) / (fArray[n2] - f3);
            }
            int n3 = n2 + 18;
            n2 += 2;
            while (n2 < n3) {
                if (fArray[n2] >= f) {
                    float f4 = fArray[n2 - 2];
                    float f5 = fArray[n2 - 1];
                    return f5 + (f - f4) / (fArray[n2] - f4) * (fArray[n2 + 1] - f5);
                }
                n2 += 2;
            }
            float f6 = fArray[n3 - 2];
            float f7 = fArray[n3 - 1];
            return f7 + (1.0f - f7) * (f - f6) / (this.frames[n + this.getFrameEntries()] - f6);
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            Attachment attachment = slot.attachment;
            if (!(attachment instanceof VertexAttachment) || ((VertexAttachment)attachment).getTimelineAttachment() != this.attachment) {
                return;
            }
            FloatArray floatArray = slot.deform;
            if (floatArray.size == 0) {
                mixBlend = MixBlend.setup;
            }
            float[][] fArray = this.vertices;
            int n = fArray[0].length;
            float[] fArray2 = this.frames;
            if (f2 < fArray2[0]) {
                switch (mixBlend) {
                    case setup: {
                        floatArray.clear();
                        return;
                    }
                    case first: {
                        if (f3 == 1.0f) {
                            floatArray.clear();
                            return;
                        }
                        float[] fArray3 = floatArray.setSize(n);
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray4 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                int n2 = i;
                                fArray3[n2] = fArray3[n2] + (fArray4[i] - fArray3[i]) * f3;
                            }
                        } else {
                            f3 = 1.0f - f3;
                            int n3 = 0;
                            while (n3 < n) {
                                int n4 = n3++;
                                fArray3[n4] = fArray3[n4] * f3;
                            }
                        }
                        break;
                    }
                }
                return;
            }
            float[] fArray5 = floatArray.setSize(n);
            if (f2 >= fArray2[fArray2.length - 1]) {
                float[] fArray6 = fArray[fArray2.length - 1];
                if (f3 == 1.0f) {
                    if (mixBlend == MixBlend.add) {
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray7 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                int n5 = i;
                                fArray5[n5] = fArray5[n5] + (fArray6[i] - fArray7[i]);
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                int n6 = i;
                                fArray5[n6] = fArray5[n6] + fArray6[i];
                            }
                        }
                    } else {
                        SpineUtils.arraycopy(fArray6, 0, fArray5, 0, n);
                    }
                } else {
                    switch (mixBlend) {
                        case setup: {
                            VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] fArray8 = vertexAttachment.getVertices();
                                for (int i = 0; i < n; ++i) {
                                    float f4 = fArray8[i];
                                    fArray5[i] = f4 + (fArray6[i] - f4) * f3;
                                }
                            } else {
                                for (int i = 0; i < n; ++i) {
                                    fArray5[i] = fArray6[i] * f3;
                                }
                            }
                            break;
                        }
                        case first: 
                        case replace: {
                            for (int i = 0; i < n; ++i) {
                                int n7 = i;
                                fArray5[n7] = fArray5[n7] + (fArray6[i] - fArray5[i]) * f3;
                            }
                            break;
                        }
                        case add: {
                            VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] fArray9 = vertexAttachment.getVertices();
                                for (int i = 0; i < n; ++i) {
                                    int n8 = i;
                                    fArray5[n8] = fArray5[n8] + (fArray6[i] - fArray9[i]) * f3;
                                }
                            } else {
                                for (int i = 0; i < n; ++i) {
                                    int n9 = i;
                                    fArray5[n9] = fArray5[n9] + fArray6[i] * f3;
                                }
                            }
                            break;
                        }
                    }
                }
                return;
            }
            int n10 = DeformTimeline.search(fArray2, f2);
            float f5 = this.getCurvePercent(f2, n10);
            float[] fArray10 = fArray[n10];
            float[] fArray11 = fArray[n10 + 1];
            if (f3 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                    if (vertexAttachment.getBones() == null) {
                        float[] fArray12 = vertexAttachment.getVertices();
                        for (int i = 0; i < n; ++i) {
                            float f6 = fArray10[i];
                            int n11 = i;
                            fArray5[n11] = fArray5[n11] + (f6 + (fArray11[i] - f6) * f5 - fArray12[i]);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            float f7 = fArray10[i];
                            int n12 = i;
                            fArray5[n12] = fArray5[n12] + (f7 + (fArray11[i] - f7) * f5);
                        }
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float f8 = fArray10[i];
                        fArray5[i] = f8 + (fArray11[i] - f8) * f5;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray13 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                float f9 = fArray10[i];
                                float f10 = fArray13[i];
                                fArray5[i] = f10 + (f9 + (fArray11[i] - f9) * f5 - f10) * f3;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                float f11 = fArray10[i];
                                fArray5[i] = (f11 + (fArray11[i] - f11) * f5) * f3;
                            }
                        }
                        break;
                    }
                    case first: 
                    case replace: {
                        for (int i = 0; i < n; ++i) {
                            float f12 = fArray10[i];
                            int n13 = i;
                            fArray5[n13] = fArray5[n13] + (f12 + (fArray11[i] - f12) * f5 - fArray5[i]) * f3;
                        }
                        break;
                    }
                    case add: {
                        VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] fArray14 = vertexAttachment.getVertices();
                            for (int i = 0; i < n; ++i) {
                                float f13 = fArray10[i];
                                int n14 = i;
                                fArray5[n14] = fArray5[n14] + (f13 + (fArray11[i] - f13) * f5 - fArray14[i]) * f3;
                            }
                        } else {
                            for (int i = 0; i < n; ++i) {
                                float f14 = fArray10[i];
                                int n15 = i;
                                fArray5[n15] = fArray5[n15] + (f14 + (fArray11[i] - f14) * f5) * f3;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class AttachmentTimeline
    extends Timeline {
        final int slotIndex;
        final String[] attachmentNames;

        public AttachmentTimeline(int n, int n2) {
            super(n, Property.attachment.ordinal() + "|" + n2);
            this.slotIndex = n2;
            this.attachmentNames = new String[n];
        }

        @Override
        public int getFrameCount() {
            return this.frames.length;
        }

        public void setFrame(int n, float f, String string) {
            this.frames[n] = f;
            this.attachmentNames[n] = string;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            if (f2 < this.frames[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            this.setAttachment(skeleton, slot, this.attachmentNames[AttachmentTimeline.search(this.frames, f2)]);
        }

        private void setAttachment(Skeleton skeleton, Slot slot, String string) {
            slot.setAttachment(string == null ? null : skeleton.getAttachment(this.slotIndex, string));
        }
    }

    public static class RGB2Timeline
    extends CurveTimeline {
        final int slotIndex;

        public RGB2Timeline(int n, int n2, int n3) {
            super(n, n2, Property.rgb.ordinal() + "|" + n3, Property.rgb2.ordinal() + "|" + n3);
            this.slotIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 7;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
            this.frames[n *= 7] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            Color color = slot.color;
            Color color2 = slot.darkColor;
            if (f2 < fArray[0]) {
                Color color3 = slot.data.color;
                Color color4 = slot.data.darkColor;
                switch (mixBlend) {
                    case setup: {
                        color.r = color3.r;
                        color.g = color3.g;
                        color.b = color3.b;
                        color2.r = color4.r;
                        color2.g = color4.g;
                        color2.b = color4.b;
                        return;
                    }
                    case first: {
                        color.r += (color3.r - color.r) * f3;
                        color.g += (color3.g - color.g) * f3;
                        color.b += (color3.b - color.b) * f3;
                        color2.r += (color4.r - color2.r) * f3;
                        color2.g += (color4.g - color2.g) * f3;
                        color2.b += (color4.b - color2.b) * f3;
                    }
                }
                return;
            }
            int n = RGB2Timeline.search(fArray, f2, 7);
            int n2 = (int)this.curves[n / 7];
            switch (n2) {
                case 0: {
                    float f10 = fArray[n];
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    float f11 = (f2 - f10) / (fArray[n + 7] - f10);
                    f9 += (fArray[n + 7 + 1] - f9) * f11;
                    f8 += (fArray[n + 7 + 2] - f8) * f11;
                    f7 += (fArray[n + 7 + 3] - f7) * f11;
                    f6 += (fArray[n + 7 + 4] - f6) * f11;
                    f5 += (fArray[n + 7 + 5] - f5) * f11;
                    f4 += (fArray[n + 7 + 6] - f4) * f11;
                    break;
                }
                case 1: {
                    f9 = fArray[n + 1];
                    f8 = fArray[n + 2];
                    f7 = fArray[n + 3];
                    f6 = fArray[n + 4];
                    f5 = fArray[n + 5];
                    f4 = fArray[n + 6];
                    break;
                }
                default: {
                    f9 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f8 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f7 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                    f6 = this.getBezierValue(f2, n, 4, n2 + 54 - 2);
                    f5 = this.getBezierValue(f2, n, 5, n2 + 72 - 2);
                    f4 = this.getBezierValue(f2, n, 6, n2 + 90 - 2);
                }
            }
            if (f3 == 1.0f) {
                color.r = f9;
                color.g = f8;
                color.b = f7;
                color2.r = f6;
                color2.g = f5;
                color2.b = f4;
            } else {
                if (mixBlend == MixBlend.setup) {
                    Color color5 = slot.data.color;
                    Color color6 = slot.data.darkColor;
                    color.r = color5.r;
                    color.g = color5.g;
                    color.b = color5.b;
                    color2.r = color6.r;
                    color2.g = color6.g;
                    color2.b = color6.b;
                }
                color.r += (f9 - color.r) * f3;
                color.g += (f8 - color.g) * f3;
                color.b += (f7 - color.b) * f3;
                color2.r += (f6 - color2.r) * f3;
                color2.g += (f5 - color2.g) * f3;
                color2.b += (f4 - color2.b) * f3;
            }
        }
    }

    public static class RGBA2Timeline
    extends CurveTimeline {
        final int slotIndex;

        public RGBA2Timeline(int n, int n2, int n3) {
            super(n, n2, Property.rgb.ordinal() + "|" + n3, Property.alpha.ordinal() + "|" + n3, Property.rgb2.ordinal() + "|" + n3);
            this.slotIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 8;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.frames[n <<= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
            this.frames[n + 5] = f6;
            this.frames[n + 6] = f7;
            this.frames[n + 7] = f8;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            Color color = slot.color;
            Color color2 = slot.darkColor;
            if (f2 < fArray[0]) {
                Color color3 = slot.data.color;
                Color color4 = slot.data.darkColor;
                switch (mixBlend) {
                    case setup: {
                        color.set(color3);
                        color2.r = color4.r;
                        color2.g = color4.g;
                        color2.b = color4.b;
                        return;
                    }
                    case first: {
                        color.add((color3.r - color.r) * f3, (color3.g - color.g) * f3, (color3.b - color.b) * f3, (color3.a - color.a) * f3);
                        color2.r += (color4.r - color2.r) * f3;
                        color2.g += (color4.g - color2.g) * f3;
                        color2.b += (color4.b - color2.b) * f3;
                    }
                }
                return;
            }
            int n = RGBA2Timeline.search(fArray, f2, 8);
            int n2 = (int)this.curves[n >> 3];
            switch (n2) {
                case 0: {
                    float f11 = fArray[n];
                    f10 = fArray[n + 1];
                    f9 = fArray[n + 2];
                    f8 = fArray[n + 3];
                    f7 = fArray[n + 4];
                    f6 = fArray[n + 5];
                    f5 = fArray[n + 6];
                    f4 = fArray[n + 7];
                    float f12 = (f2 - f11) / (fArray[n + 8] - f11);
                    f10 += (fArray[n + 8 + 1] - f10) * f12;
                    f9 += (fArray[n + 8 + 2] - f9) * f12;
                    f8 += (fArray[n + 8 + 3] - f8) * f12;
                    f7 += (fArray[n + 8 + 4] - f7) * f12;
                    f6 += (fArray[n + 8 + 5] - f6) * f12;
                    f5 += (fArray[n + 8 + 6] - f5) * f12;
                    f4 += (fArray[n + 8 + 7] - f4) * f12;
                    break;
                }
                case 1: {
                    f10 = fArray[n + 1];
                    f9 = fArray[n + 2];
                    f8 = fArray[n + 3];
                    f7 = fArray[n + 4];
                    f6 = fArray[n + 5];
                    f5 = fArray[n + 6];
                    f4 = fArray[n + 7];
                    break;
                }
                default: {
                    f10 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f9 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f8 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                    f7 = this.getBezierValue(f2, n, 4, n2 + 54 - 2);
                    f6 = this.getBezierValue(f2, n, 5, n2 + 72 - 2);
                    f5 = this.getBezierValue(f2, n, 6, n2 + 90 - 2);
                    f4 = this.getBezierValue(f2, n, 7, n2 + 108 - 2);
                }
            }
            if (f3 == 1.0f) {
                color.set(f10, f9, f8, f7);
                color2.r = f6;
                color2.g = f5;
                color2.b = f4;
            } else {
                if (mixBlend == MixBlend.setup) {
                    color.set(slot.data.color);
                    Color color5 = slot.data.darkColor;
                    color2.r = color5.r;
                    color2.g = color5.g;
                    color2.b = color5.b;
                }
                color.add((f10 - color.r) * f3, (f9 - color.g) * f3, (f8 - color.b) * f3, (f7 - color.a) * f3);
                color2.r += (f6 - color2.r) * f3;
                color2.g += (f5 - color2.g) * f3;
                color2.b += (f4 - color2.b) * f3;
            }
        }
    }

    public static class AlphaTimeline
    extends CurveTimeline1 {
        final int slotIndex;

        public AlphaTimeline(int n, int n2, int n3) {
            super(n, n2, Property.alpha.ordinal() + "|" + n3);
            this.slotIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            Color color = slot.color;
            if (f2 < fArray[0]) {
                Color color2 = slot.data.color;
                switch (mixBlend) {
                    case setup: {
                        color.a = color2.a;
                        return;
                    }
                    case first: {
                        color.a += (color2.a - color.a) * f3;
                    }
                }
                return;
            }
            float f4 = this.getCurveValue(f2);
            if (f3 == 1.0f) {
                color.a = f4;
            } else {
                if (mixBlend == MixBlend.setup) {
                    color.a = slot.data.color.a;
                }
                color.a += (f4 - color.a) * f3;
            }
        }
    }

    public static class RGBTimeline
    extends CurveTimeline {
        final int slotIndex;

        public RGBTimeline(int n, int n2, int n3) {
            super(n, n2, Property.rgb.ordinal() + "|" + n3);
            this.slotIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 4;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4) {
            this.frames[n <<= 2] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            Color color = slot.color;
            if (f2 < fArray[0]) {
                Color color2 = slot.data.color;
                switch (mixBlend) {
                    case setup: {
                        color.r = color2.r;
                        color.g = color2.g;
                        color.b = color2.b;
                        return;
                    }
                    case first: {
                        color.r += (color2.r - color.r) * f3;
                        color.g += (color2.g - color.g) * f3;
                        color.b += (color2.b - color.b) * f3;
                    }
                }
                return;
            }
            int n = RGBTimeline.search(fArray, f2, 4);
            int n2 = (int)this.curves[n >> 2];
            switch (n2) {
                case 0: {
                    float f7 = fArray[n];
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    float f8 = (f2 - f7) / (fArray[n + 4] - f7);
                    f6 += (fArray[n + 4 + 1] - f6) * f8;
                    f5 += (fArray[n + 4 + 2] - f5) * f8;
                    f4 += (fArray[n + 4 + 3] - f4) * f8;
                    break;
                }
                case 1: {
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = fArray[n + 3];
                    break;
                }
                default: {
                    f6 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f5 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f4 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                }
            }
            if (f3 == 1.0f) {
                color.r = f6;
                color.g = f5;
                color.b = f4;
            } else {
                if (mixBlend == MixBlend.setup) {
                    Color color3 = slot.data.color;
                    color.r = color3.r;
                    color.g = color3.g;
                    color.b = color3.b;
                }
                color.r += (f6 - color.r) * f3;
                color.g += (f5 - color.g) * f3;
                color.b += (f4 - color.b) * f3;
            }
        }
    }

    public static class RGBATimeline
    extends CurveTimeline {
        final int slotIndex;

        public RGBATimeline(int n, int n2, int n3) {
            super(n, n2, Property.rgb.ordinal() + "|" + n3, Property.alpha.ordinal() + "|" + n3);
            this.slotIndex = n3;
        }

        @Override
        public int getFrameEntries() {
            return 5;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5) {
            this.frames[n *= 5] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] fArray = this.frames;
            Color color = slot.color;
            if (f2 < fArray[0]) {
                Color color2 = slot.data.color;
                switch (mixBlend) {
                    case setup: {
                        color.set(color2);
                        return;
                    }
                    case first: {
                        color.add((color2.r - color.r) * f3, (color2.g - color.g) * f3, (color2.b - color.b) * f3, (color2.a - color.a) * f3);
                    }
                }
                return;
            }
            int n = RGBATimeline.search(fArray, f2, 5);
            int n2 = (int)this.curves[n / 5];
            switch (n2) {
                case 0: {
                    float f8 = fArray[n];
                    f7 = fArray[n + 1];
                    f6 = fArray[n + 2];
                    f5 = fArray[n + 3];
                    f4 = fArray[n + 4];
                    float f9 = (f2 - f8) / (fArray[n + 5] - f8);
                    f7 += (fArray[n + 5 + 1] - f7) * f9;
                    f6 += (fArray[n + 5 + 2] - f6) * f9;
                    f5 += (fArray[n + 5 + 3] - f5) * f9;
                    f4 += (fArray[n + 5 + 4] - f4) * f9;
                    break;
                }
                case 1: {
                    f7 = fArray[n + 1];
                    f6 = fArray[n + 2];
                    f5 = fArray[n + 3];
                    f4 = fArray[n + 4];
                    break;
                }
                default: {
                    f7 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f6 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                    f5 = this.getBezierValue(f2, n, 3, n2 + 36 - 2);
                    f4 = this.getBezierValue(f2, n, 4, n2 + 54 - 2);
                }
            }
            if (f3 == 1.0f) {
                color.set(f7, f6, f5, f4);
            } else {
                if (mixBlend == MixBlend.setup) {
                    color.set(slot.data.color);
                }
                color.add((f7 - color.r) * f3, (f6 - color.g) * f3, (f5 - color.b) * f3, (f4 - color.a) * f3);
            }
        }
    }

    public static class InheritTimeline
    extends Timeline {
        final int boneIndex;

        public InheritTimeline(int n, int n2) {
            super(n, Property.inherit.ordinal() + "|" + n2);
            this.boneIndex = n2;
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int n, float f, BoneData.Inherit inherit) {
            this.frames[n *= 2] = f;
            this.frames[n + 1] = inherit.ordinal();
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            if (mixDirection == MixDirection.out) {
                if (mixBlend == MixBlend.setup) {
                    bone.inherit = bone.data.inherit;
                }
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (mixBlend == MixBlend.setup || mixBlend == MixBlend.first) {
                    bone.inherit = bone.data.inherit;
                }
                return;
            }
            bone.inherit = BoneData.Inherit.values[(int)fArray[InheritTimeline.search(fArray, f2, 2) + 1]];
        }
    }

    public static class ShearYTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public ShearYTimeline(int n, int n2, int n3) {
            super(n, n2, Property.shearY.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.shearY = this.getRelativeValue(f2, f3, mixBlend, bone.shearY, bone.data.shearY);
            }
        }
    }

    public static class ShearXTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public ShearXTimeline(int n, int n2, int n3) {
            super(n, n2, Property.shearX.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.shearX = this.getRelativeValue(f2, f3, mixBlend, bone.shearX, bone.data.shearX);
            }
        }
    }

    public static class ShearTimeline
    extends CurveTimeline2 {
        final int boneIndex;

        public ShearTimeline(int n, int n2, int n3) {
            super(n, n2, Property.shearX.ordinal() + "|" + n3, Property.shearY.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.shearX = bone.data.shearX;
                        bone.shearY = bone.data.shearY;
                        return;
                    }
                    case first: {
                        bone.shearX += (bone.data.shearX - bone.shearX) * f3;
                        bone.shearY += (bone.data.shearY - bone.shearY) * f3;
                    }
                }
                return;
            }
            int n = ShearTimeline.search(fArray, f2, 3);
            int n2 = (int)this.curves[n / 3];
            switch (n2) {
                case 0: {
                    float f6 = fArray[n];
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    float f7 = (f2 - f6) / (fArray[n + 3] - f6);
                    f5 += (fArray[n + 3 + 1] - f5) * f7;
                    f4 += (fArray[n + 3 + 2] - f4) * f7;
                    break;
                }
                case 1: {
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    break;
                }
                default: {
                    f5 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f4 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    bone.shearX = bone.data.shearX + f5 * f3;
                    bone.shearY = bone.data.shearY + f4 * f3;
                    break;
                }
                case first: 
                case replace: {
                    bone.shearX += (bone.data.shearX + f5 - bone.shearX) * f3;
                    bone.shearY += (bone.data.shearY + f4 - bone.shearY) * f3;
                    break;
                }
                case add: {
                    bone.shearX += f5 * f3;
                    bone.shearY += f4 * f3;
                }
            }
        }
    }

    public static class ScaleYTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public ScaleYTimeline(int n, int n2, int n3) {
            super(n, n2, Property.scaleY.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.scaleY = this.getScaleValue(f2, f3, mixBlend, mixDirection, bone.scaleY, bone.data.scaleY);
            }
        }
    }

    public static class ScaleXTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public ScaleXTimeline(int n, int n2, int n3) {
            super(n, n2, Property.scaleX.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.scaleX = this.getScaleValue(f2, f3, mixBlend, mixDirection, bone.scaleX, bone.data.scaleX);
            }
        }
    }

    public static class ScaleTimeline
    extends CurveTimeline2 {
        final int boneIndex;

        public ScaleTimeline(int n, int n2, int n3) {
            super(n, n2, Property.scaleX.ordinal() + "|" + n3, Property.scaleY.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            float f6;
            float f7;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.scaleX = bone.data.scaleX;
                        bone.scaleY = bone.data.scaleY;
                        return;
                    }
                    case first: {
                        bone.scaleX += (bone.data.scaleX - bone.scaleX) * f3;
                        bone.scaleY += (bone.data.scaleY - bone.scaleY) * f3;
                    }
                }
                return;
            }
            int n = ScaleTimeline.search(fArray, f2, 3);
            int n2 = (int)this.curves[n / 3];
            switch (n2) {
                case 0: {
                    f7 = fArray[n];
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    f4 = (f2 - f7) / (fArray[n + 3] - f7);
                    f6 += (fArray[n + 3 + 1] - f6) * f4;
                    f5 += (fArray[n + 3 + 2] - f5) * f4;
                    break;
                }
                case 1: {
                    f6 = fArray[n + 1];
                    f5 = fArray[n + 2];
                    break;
                }
                default: {
                    f6 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f5 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                }
            }
            f6 *= bone.data.scaleX;
            f5 *= bone.data.scaleY;
            if (f3 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    bone.scaleX += f6 - bone.data.scaleX;
                    bone.scaleY += f5 - bone.data.scaleY;
                } else {
                    bone.scaleX = f6;
                    bone.scaleY = f5;
                }
            } else if (mixDirection == MixDirection.out) {
                switch (mixBlend) {
                    case setup: {
                        f7 = bone.data.scaleX;
                        f4 = bone.data.scaleY;
                        bone.scaleX = f7 + (Math.abs(f6) * Math.signum(f7) - f7) * f3;
                        bone.scaleY = f4 + (Math.abs(f5) * Math.signum(f4) - f4) * f3;
                        break;
                    }
                    case first: 
                    case replace: {
                        f7 = bone.scaleX;
                        f4 = bone.scaleY;
                        bone.scaleX = f7 + (Math.abs(f6) * Math.signum(f7) - f7) * f3;
                        bone.scaleY = f4 + (Math.abs(f5) * Math.signum(f4) - f4) * f3;
                        break;
                    }
                    case add: {
                        bone.scaleX += (f6 - bone.data.scaleX) * f3;
                        bone.scaleY += (f5 - bone.data.scaleY) * f3;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        f7 = Math.abs(bone.data.scaleX) * Math.signum(f6);
                        f4 = Math.abs(bone.data.scaleY) * Math.signum(f5);
                        bone.scaleX = f7 + (f6 - f7) * f3;
                        bone.scaleY = f4 + (f5 - f4) * f3;
                        break;
                    }
                    case first: 
                    case replace: {
                        f7 = Math.abs(bone.scaleX) * Math.signum(f6);
                        f4 = Math.abs(bone.scaleY) * Math.signum(f5);
                        bone.scaleX = f7 + (f6 - f7) * f3;
                        bone.scaleY = f4 + (f5 - f4) * f3;
                        break;
                    }
                    case add: {
                        bone.scaleX += (f6 - bone.data.scaleX) * f3;
                        bone.scaleY += (f5 - bone.data.scaleY) * f3;
                    }
                }
            }
        }
    }

    public static class TranslateYTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public TranslateYTimeline(int n, int n2, int n3) {
            super(n, n2, Property.y.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.y = this.getRelativeValue(f2, f3, mixBlend, bone.y, bone.data.y);
            }
        }
    }

    public static class TranslateXTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public TranslateXTimeline(int n, int n2, int n3) {
            super(n, n2, Property.x.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.x = this.getRelativeValue(f2, f3, mixBlend, bone.x, bone.data.x);
            }
        }
    }

    public static class TranslateTimeline
    extends CurveTimeline2 {
        final int boneIndex;

        public TranslateTimeline(int n, int n2, int n3) {
            super(n, n2, Property.x.ordinal() + "|" + n3, Property.y.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            float f4;
            float f5;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        bone.x = bone.data.x;
                        bone.y = bone.data.y;
                        return;
                    }
                    case first: {
                        bone.x += (bone.data.x - bone.x) * f3;
                        bone.y += (bone.data.y - bone.y) * f3;
                    }
                }
                return;
            }
            int n = TranslateTimeline.search(fArray, f2, 3);
            int n2 = (int)this.curves[n / 3];
            switch (n2) {
                case 0: {
                    float f6 = fArray[n];
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    float f7 = (f2 - f6) / (fArray[n + 3] - f6);
                    f5 += (fArray[n + 3 + 1] - f5) * f7;
                    f4 += (fArray[n + 3 + 2] - f4) * f7;
                    break;
                }
                case 1: {
                    f5 = fArray[n + 1];
                    f4 = fArray[n + 2];
                    break;
                }
                default: {
                    f5 = this.getBezierValue(f2, n, 1, n2 - 2);
                    f4 = this.getBezierValue(f2, n, 2, n2 + 18 - 2);
                }
            }
            switch (mixBlend) {
                case setup: {
                    bone.x = bone.data.x + f5 * f3;
                    bone.y = bone.data.y + f4 * f3;
                    break;
                }
                case first: 
                case replace: {
                    bone.x += (bone.data.x + f5 - bone.x) * f3;
                    bone.y += (bone.data.y + f4 - bone.y) * f3;
                    break;
                }
                case add: {
                    bone.x += f5 * f3;
                    bone.y += f4 * f3;
                }
            }
        }
    }

    public static class RotateTimeline
    extends CurveTimeline1 {
        final int boneIndex;

        public RotateTimeline(int n, int n2, int n3) {
            super(n, n2, Property.rotate.ordinal() + "|" + n3);
            this.boneIndex = n3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, MixBlend mixBlend, MixDirection mixDirection) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (bone.active) {
                bone.rotation = this.getRelativeValue(f2, f3, mixBlend, bone.rotation, bone.data.rotation);
            }
        }
    }

    public static abstract class CurveTimeline2
    extends CurveTimeline {
        public CurveTimeline2(int n, int n2, String string, String string2) {
            super(n, n2, string, string2);
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        public void setFrame(int n, float f, float f2, float f3) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
        }
    }

    public static abstract class CurveTimeline1
    extends CurveTimeline {
        public CurveTimeline1(int n, int n2, String string) {
            super(n, n2, string);
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int n, float f, float f2) {
            this.frames[n <<= 1] = f;
            this.frames[n + 1] = f2;
        }

        public float getCurveValue(float f) {
            int n;
            float[] fArray = this.frames;
            int n2 = fArray.length - 2;
            for (n = 2; n <= n2; n += 2) {
                if (!(fArray[n] > f)) continue;
                n2 = n - 2;
                break;
            }
            n = (int)this.curves[n2 >> 1];
            switch (n) {
                case 0: {
                    float f2 = fArray[n2];
                    float f3 = fArray[n2 + 1];
                    return f3 + (f - f2) / (fArray[n2 + 2] - f2) * (fArray[n2 + 2 + 1] - f3);
                }
                case 1: {
                    return fArray[n2 + 1];
                }
            }
            return this.getBezierValue(f, n2, 1, n - 2);
        }

        public float getRelativeValue(float f, float f2, MixBlend mixBlend, float f3, float f4) {
            if (f < this.frames[0]) {
                switch (mixBlend) {
                    case setup: {
                        return f4;
                    }
                    case first: {
                        return f3 + (f4 - f3) * f2;
                    }
                }
                return f3;
            }
            float f5 = this.getCurveValue(f);
            switch (mixBlend) {
                case setup: {
                    return f4 + f5 * f2;
                }
                case first: 
                case replace: {
                    f5 += f4 - f3;
                }
            }
            return f3 + f5 * f2;
        }

        public float getAbsoluteValue(float f, float f2, MixBlend mixBlend, float f3, float f4) {
            if (f < this.frames[0]) {
                switch (mixBlend) {
                    case setup: {
                        return f4;
                    }
                    case first: {
                        return f3 + (f4 - f3) * f2;
                    }
                }
                return f3;
            }
            float f5 = this.getCurveValue(f);
            if (mixBlend == MixBlend.setup) {
                return f4 + (f5 - f4) * f2;
            }
            return f3 + (f5 - f3) * f2;
        }

        public float getAbsoluteValue(float f, float f2, MixBlend mixBlend, float f3, float f4, float f5) {
            if (f < this.frames[0]) {
                switch (mixBlend) {
                    case setup: {
                        return f4;
                    }
                    case first: {
                        return f3 + (f4 - f3) * f2;
                    }
                }
                return f3;
            }
            if (mixBlend == MixBlend.setup) {
                return f4 + (f5 - f4) * f2;
            }
            return f3 + (f5 - f3) * f2;
        }

        public float getScaleValue(float f, float f2, MixBlend mixBlend, MixDirection mixDirection, float f3, float f4) {
            float[] fArray = this.frames;
            if (f < fArray[0]) {
                switch (mixBlend) {
                    case setup: {
                        return f4;
                    }
                    case first: {
                        return f3 + (f4 - f3) * f2;
                    }
                }
                return f3;
            }
            float f5 = this.getCurveValue(f) * f4;
            if (f2 == 1.0f) {
                if (mixBlend == MixBlend.add) {
                    return f3 + f5 - f4;
                }
                return f5;
            }
            if (mixDirection == MixDirection.out) {
                switch (mixBlend) {
                    case setup: {
                        return f4 + (Math.abs(f5) * Math.signum(f4) - f4) * f2;
                    }
                    case first: 
                    case replace: {
                        return f3 + (Math.abs(f5) * Math.signum(f3) - f3) * f2;
                    }
                }
            } else {
                switch (mixBlend) {
                    case setup: {
                        float f6 = Math.abs(f4) * Math.signum(f5);
                        return f6 + (f5 - f6) * f2;
                    }
                    case first: 
                    case replace: {
                        float f7 = Math.abs(f3) * Math.signum(f5);
                        return f7 + (f5 - f7) * f2;
                    }
                }
            }
            return f3 + (f5 - f4) * f2;
        }
    }

    public static abstract class CurveTimeline
    extends Timeline {
        float[] curves;

        public CurveTimeline(int n, int n2, String ... stringArray) {
            super(n, stringArray);
            this.curves = new float[n + n2 * 18];
            this.curves[n - 1] = 1.0f;
        }

        public void setStepped(int n) {
            this.curves[n] = 1.0f;
        }

        public void shrink(int n) {
            int n2 = this.getFrameCount() + n * 18;
            if (this.curves.length > n2) {
                float[] fArray = new float[n2];
                SpineUtils.arraycopy(this.curves, 0, fArray, 0, n2);
                this.curves = fArray;
            }
        }

        public void setBezier(int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = this.curves;
            int n4 = this.getFrameCount() + n * 18;
            if (n3 == 0) {
                fArray[n2] = 2 + n4;
            }
            float f9 = (f - f3 * 2.0f + f5) * 0.03f;
            float f10 = (f2 - f4 * 2.0f + f6) * 0.03f;
            float f11 = ((f3 - f5) * 3.0f - f + f7) * 0.006f;
            float f12 = ((f4 - f6) * 3.0f - f2 + f8) * 0.006f;
            float f13 = f9 * 2.0f + f11;
            float f14 = f10 * 2.0f + f12;
            float f15 = (f3 - f) * 0.3f + f9 + f11 * 0.16666667f;
            float f16 = (f4 - f2) * 0.3f + f10 + f12 * 0.16666667f;
            float f17 = f + f15;
            float f18 = f2 + f16;
            int n5 = n4 + 18;
            while (n4 < n5) {
                fArray[n4] = f17;
                fArray[n4 + 1] = f18;
                f17 += (f15 += (f13 += f11));
                f18 += (f16 += (f14 += f12));
                n4 += 2;
            }
        }

        public float getBezierValue(float f, int n, int n2, int n3) {
            float[] fArray = this.curves;
            if (fArray[n3] > f) {
                float f2 = this.frames[n];
                float f3 = this.frames[n + n2];
                return f3 + (f - f2) / (fArray[n3] - f2) * (fArray[n3 + 1] - f3);
            }
            int n4 = n3 + 18;
            n3 += 2;
            while (n3 < n4) {
                if (fArray[n3] >= f) {
                    float f4 = fArray[n3 - 2];
                    float f5 = fArray[n3 - 1];
                    return f5 + (f - f4) / (fArray[n3] - f4) * (fArray[n3 + 1] - f5);
                }
                n3 += 2;
            }
            float f6 = fArray[n4 - 2];
            float f7 = fArray[n4 - 1];
            return f7 + (f - f6) / (this.frames[n += this.getFrameEntries()] - f6) * (this.frames[n + n2] - f7);
        }
    }

    private static enum Property {
        rotate,
        x,
        y,
        scaleX,
        scaleY,
        shearX,
        shearY,
        inherit,
        rgb,
        alpha,
        rgb2,
        attachment,
        deform,
        event,
        drawOrder,
        ikConstraint,
        transformConstraint,
        pathConstraintPosition,
        pathConstraintSpacing,
        pathConstraintMix,
        physicsConstraintInertia,
        physicsConstraintStrength,
        physicsConstraintDamping,
        physicsConstraintMass,
        physicsConstraintWind,
        physicsConstraintGravity,
        physicsConstraintMix,
        physicsConstraintReset,
        sequence;

    }
}

