/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DefaultPool;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;

public class Pools {
    private static final ObjectMap<Class<?>, Pool<?>> typePools = new ObjectMap();
    private static final ObjectMap<Class<?>, Pool<?>> supplierPoolsCache = new ObjectMap();

    public static <T> Pool<T> get(DefaultPool.PoolSupplier<T> poolTypeSupplier, int max) {
        Pool<?> pool = supplierPoolsCache.get(poolTypeSupplier.getClass());
        if (pool == null) {
            T tmp = poolTypeSupplier.get();
            Class<?> type = tmp.getClass();
            pool = typePools.get(type);
            if (pool == null) {
                pool = new DefaultPool(poolTypeSupplier, 4, max);
                typePools.put(type, pool);
            }
            supplierPoolsCache.put(poolTypeSupplier.getClass(), pool);
        }
        return pool;
    }

    public static <T> Pool<T> get(DefaultPool.PoolSupplier<T> poolTypeSupplier) {
        return Pools.get(poolTypeSupplier, 100);
    }

    public static <T> T obtain(DefaultPool.PoolSupplier<T> poolTypeSupplier) {
        return Pools.get(poolTypeSupplier).obtain();
    }

    public static void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        Pool<?> pool = typePools.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }

    public static void freeAll(Array objects, boolean samePool) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        Pool<?> pool = null;
        int n = objects.size;
        for (int i = 0; i < n; ++i) {
            Object object = objects.get(i);
            if (object == null || pool == null && (pool = typePools.get(object.getClass())) == null) continue;
            pool.free(object);
            if (samePool) continue;
            pool = null;
        }
    }
}

