/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.StackWalkUtil;

public class MemoryStack
extends Pointer.Default
implements AutoCloseable {
    private static final int DEFAULT_STACK_SIZE = Configuration.STACK_SIZE.get(64) * 1024;
    private static final ThreadLocal<MemoryStack> TLS = ThreadLocal.withInitial(MemoryStack::create);
    @Nullable
    private final ByteBuffer container;
    private final int size;
    private int pointer;
    private int[] frames;
    protected int frameIndex;

    protected MemoryStack(@Nullable ByteBuffer container, long address, int size) {
        super(address);
        this.container = container;
        this.size = size;
        this.pointer = size;
        this.frames = new int[8];
    }

    public static MemoryStack create() {
        return MemoryStack.create(DEFAULT_STACK_SIZE);
    }

    public static MemoryStack create(int capacity) {
        return MemoryStack.create(BufferUtils.createByteBuffer(capacity));
    }

    public static MemoryStack create(ByteBuffer buffer) {
        long address = MemoryUtil.memAddress(buffer);
        int size = buffer.remaining();
        return Configuration.DEBUG_STACK.get(false) != false ? new DebugMemoryStack(buffer, address, size) : new MemoryStack(buffer, address, size);
    }

    public MemoryStack push() {
        if (this.frameIndex == this.frames.length) {
            this.frameOverflow();
        }
        this.frames[this.frameIndex++] = this.pointer;
        return this;
    }

    private void frameOverflow() {
        if (Checks.DEBUG) {
            APIUtil.apiLog("[WARNING] Out of frame stack space (" + this.frames.length + ") in thread: " + Thread.currentThread());
        }
        this.frames = Arrays.copyOf(this.frames, this.frames.length * 3 / 2);
    }

    public MemoryStack pop() {
        this.pointer = this.frames[--this.frameIndex];
        return this;
    }

    @Override
    public void close() {
        this.pop();
    }

    public long getPointerAddress() {
        return this.address + ((long)this.pointer & 0xFFFFFFFFL);
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        if (Checks.CHECKS) {
            this.checkPointer(pointer);
        }
        this.pointer = pointer;
    }

    private void checkPointer(int pointer) {
        if (pointer < 0 || this.size < pointer) {
            throw new IndexOutOfBoundsException("Invalid stack pointer");
        }
    }

    public long nmalloc(int alignment, int size) {
        long address = this.address + (long)this.pointer - (long)size & (Integer.toUnsignedLong(alignment - 1) ^ 0xFFFFFFFFFFFFFFFFL);
        this.pointer = (int)(address - this.address);
        if (Checks.CHECKS && this.pointer < 0) {
            throw new OutOfMemoryError("Out of stack space.");
        }
        return address;
    }

    public ByteBuffer malloc(int size) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, this.nmalloc(POINTER_SIZE, size), size).order(MemoryUtil.NATIVE_ORDER);
    }

    public IntBuffer mallocInt(int size) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_INT, this.nmalloc(4, size << 2), size);
    }

    public IntBuffer callocInt(int size) {
        int bytes = size * 4;
        long address = this.nmalloc(4, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_INT, address, size);
    }

    public IntBuffer ints(int x) {
        return this.mallocInt(1).put(0, x);
    }

    public PointerBuffer mallocPointer(int size) {
        return PointerBuffer.create(this.nmalloc(POINTER_SIZE, size << POINTER_SHIFT), size);
    }

    public ByteBuffer ASCII(CharSequence text) {
        return this.ASCII(text, true);
    }

    public ByteBuffer ASCII(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthASCII(text, nullTerminated);
        long target = this.nmalloc(POINTER_SIZE, length);
        MemoryUtil.encodeASCIIUnsafe(text, nullTerminated, target);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, target, length).order(MemoryUtil.NATIVE_ORDER);
    }

    public int nASCII(CharSequence text, boolean nullTerminated) {
        long target = this.nmalloc(POINTER_SIZE, MemoryUtil.memLengthASCII(text, nullTerminated));
        return MemoryUtil.encodeASCIIUnsafe(text, nullTerminated, target);
    }

    public ByteBuffer UTF8(CharSequence text) {
        return this.UTF8(text, true);
    }

    public ByteBuffer UTF8(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF8(text, nullTerminated);
        long target = this.nmalloc(POINTER_SIZE, length);
        MemoryUtil.encodeUTF8Unsafe(text, nullTerminated, target);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, target, length).order(MemoryUtil.NATIVE_ORDER);
    }

    public int nUTF8(CharSequence text, boolean nullTerminated) {
        long target = this.nmalloc(POINTER_SIZE, MemoryUtil.memLengthUTF8(text, nullTerminated));
        return MemoryUtil.encodeUTF8Unsafe(text, nullTerminated, target);
    }

    public ByteBuffer UTF16(CharSequence text) {
        return this.UTF16(text, true);
    }

    public ByteBuffer UTF16(CharSequence text, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF16(text, nullTerminated);
        long target = this.nmalloc(POINTER_SIZE, length);
        MemoryUtil.encodeUTF16Unsafe(text, nullTerminated, target);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, target, length).order(MemoryUtil.NATIVE_ORDER);
    }

    public static MemoryStack stackGet() {
        return TLS.get();
    }

    public static MemoryStack stackPush() {
        return MemoryStack.stackGet().push();
    }

    static {
        if (DEFAULT_STACK_SIZE < 0) {
            throw new IllegalStateException("Invalid stack size.");
        }
    }

    private static class DebugMemoryStack
    extends MemoryStack {
        private Object[] debugFrames = new Object[8];

        DebugMemoryStack(@Nullable ByteBuffer buffer, long address, int size) {
            super(buffer, address, size);
        }

        @Override
        public MemoryStack push() {
            if (this.frameIndex == this.debugFrames.length) {
                this.frameOverflow();
            }
            this.debugFrames[this.frameIndex] = StackWalkUtil.stackWalkGetMethod(MemoryStack.class);
            return super.push();
        }

        @Override
        private void frameOverflow() {
            this.debugFrames = Arrays.copyOf(this.debugFrames, this.debugFrames.length * 3 / 2);
        }

        @Override
        public MemoryStack pop() {
            Object pushed = this.debugFrames[this.frameIndex - 1];
            Object popped = StackWalkUtil.stackWalkCheckPop(MemoryStack.class, pushed);
            if (popped != null) {
                DebugMemoryStack.reportAsymmetricPop(pushed, popped);
            }
            this.debugFrames[this.frameIndex - 1] = null;
            return super.pop();
        }

        @Override
        public void close() {
            this.debugFrames[this.frameIndex - 1] = null;
            super.pop();
        }

        private static void reportAsymmetricPop(Object pushed, Object popped) {
            APIUtil.DEBUG_STREAM.format("[LWJGL] Asymmetric pop detected:\n\tPUSHED: %s\n\tPOPPED: %s\n\tTHREAD: %s\n", pushed, popped, Thread.currentThread());
        }
    }
}

