/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.CheckIntrinsics;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;

public final class Checks {
    public static final boolean CHECKS = Configuration.DISABLE_CHECKS.get(false) == false;
    public static final boolean DEBUG = Configuration.DEBUG.get(false);
    public static final boolean DEBUG_FUNCTIONS = Configuration.DEBUG_FUNCTIONS.get(false);

    public static int remainingSafe(@Nullable Buffer buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static int remainingSafe(@Nullable CustomBuffer<?> buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static boolean checkFunctions(FunctionProvider provider, PointerBuffer caps, int[] indices, String ... functions) {
        boolean available = true;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            if (index < 0 || caps.get(index) != 0L) continue;
            long address = provider.getFunctionAddress(functions[i]);
            if (address == 0L) {
                available = false;
                continue;
            }
            caps.put(index, address);
        }
        return available;
    }

    public static boolean reportMissing(String api, String extension) {
        APIUtil.apiLog("[" + api + "] " + extension + " was reported as available but an entry point is missing.");
        return false;
    }

    public static long check(long pointer) {
        if (pointer == 0L) {
            throw new NullPointerException();
        }
        return pointer;
    }

    private static void assertNT(boolean found) {
        if (!found) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT1(ByteBuffer buf) {
        Checks.checkBuffer(buf.remaining(), 1);
        Checks.assertNT(buf.get(buf.limit() - 1) == 0);
    }

    public static void checkNT2(ByteBuffer buf) {
        Checks.checkBuffer(buf.remaining(), 2);
        Checks.assertNT(buf.get(buf.limit() - 2) == 0);
    }

    public static void checkNT1Safe(@Nullable ByteBuffer buf) {
        if (buf != null) {
            Checks.checkBuffer(buf.remaining(), 1);
            Checks.assertNT(buf.get(buf.limit() - 1) == 0);
        }
    }

    public static void checkNT2Safe(@Nullable ByteBuffer buf) {
        if (buf != null) {
            Checks.checkBuffer(buf.remaining(), 2);
            Checks.assertNT(buf.get(buf.limit() - 2) == 0);
        }
    }

    private static void checkBuffer(int bufferSize, int minimumSize) {
        if (bufferSize < minimumSize) {
            Checks.throwIAE(bufferSize, minimumSize);
        }
    }

    public static void check(Buffer buf, int size) {
        Checks.checkBuffer(buf.remaining(), size);
    }

    public static void check(CustomBuffer<?> buf, int size) {
        Checks.checkBuffer(buf.remaining(), size);
    }

    public static void checkSafe(@Nullable Buffer buf, int size) {
        if (buf != null) {
            Checks.checkBuffer(buf.remaining(), size);
        }
    }

    public static long check(int index, int length) {
        if (CHECKS) {
            CheckIntrinsics.checkIndex(index, length);
        }
        return Integer.toUnsignedLong(index);
    }

    private static void throwIAE(int bufferSize, int minimumSize) {
        throw new IllegalArgumentException("Number of remaining elements is " + bufferSize + ", must be at least " + minimumSize);
    }

    static {
        if (DEBUG_FUNCTIONS && !DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] The DEBUG_FUNCTIONS option requires DEBUG to produce output.");
        }
    }
}

