/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.Sequence;

public class AtlasAttachmentLoader
implements AttachmentLoader {
    private TextureAtlas atlas;

    public AtlasAttachmentLoader(TextureAtlas textureAtlas) {
        if (textureAtlas == null) {
            throw new IllegalArgumentException("atlas cannot be null.");
        }
        this.atlas = textureAtlas;
    }

    private void loadSequence(String string, String string2, Sequence sequence) {
        TextureRegion[] textureRegionArray = sequence.getRegions();
        int n = textureRegionArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = sequence.getPath(string2, i);
            textureRegionArray[i] = this.atlas.findRegion(string3);
            if (textureRegionArray[i] != null) continue;
            throw new RuntimeException("Region not found in atlas: " + string3 + " (sequence: " + string + ")");
        }
    }

    @Override
    public RegionAttachment newRegionAttachment(Skin skin, String string, String string2, Sequence sequence) {
        RegionAttachment regionAttachment = new RegionAttachment(string);
        if (sequence != null) {
            this.loadSequence(string, string2, sequence);
        } else {
            TextureAtlas.AtlasRegion atlasRegion = this.atlas.findRegion(string2);
            if (atlasRegion == null) {
                throw new RuntimeException("Region not found in atlas: " + string2 + " (region attachment: " + string + ")");
            }
            regionAttachment.setRegion(atlasRegion);
        }
        return regionAttachment;
    }

    @Override
    public MeshAttachment newMeshAttachment(Skin skin, String string, String string2, Sequence sequence) {
        MeshAttachment meshAttachment = new MeshAttachment(string);
        if (sequence != null) {
            this.loadSequence(string, string2, sequence);
        } else {
            TextureAtlas.AtlasRegion atlasRegion = this.atlas.findRegion(string2);
            if (atlasRegion == null) {
                throw new RuntimeException("Region not found in atlas: " + string2 + " (mesh attachment: " + string + ")");
            }
            meshAttachment.setRegion(atlasRegion);
        }
        return meshAttachment;
    }

    @Override
    public BoundingBoxAttachment newBoundingBoxAttachment(Skin skin, String string) {
        return new BoundingBoxAttachment(string);
    }

    @Override
    public ClippingAttachment newClippingAttachment(Skin skin, String string) {
        return new ClippingAttachment(string);
    }

    @Override
    public PathAttachment newPathAttachment(Skin skin, String string) {
        return new PathAttachment(string);
    }

    @Override
    public PointAttachment newPointAttachment(Skin skin, String string) {
        return new PointAttachment(string);
    }
}

