/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALLwjgl3Audio;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.FloatArray;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public abstract class OpenALMusic
implements Music {
    private static final byte[] tempBytes = new byte[40960];
    private static final ByteBuffer tempBuffer = BufferUtils.createByteBuffer(40960);
    private FloatArray renderedSecondsQueue;
    private final OpenALLwjgl3Audio audio;
    private IntBuffer buffers;
    private int sourceID;
    private int format;
    private int sampleRate;
    private boolean isLooping;
    private boolean isPlaying;
    private float renderedSeconds;
    private float maxSecondsPerBuffer;
    protected final FileHandle file;
    private Music.OnCompletionListener onCompletionListener;

    protected void setup(int channels, int sampleRate) {
        this.format = channels > 1 ? 4355 : 4353;
        this.sampleRate = sampleRate;
        this.maxSecondsPerBuffer = 40960.0f / (float)(2 * channels * sampleRate);
    }

    public void stop() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        this.audio.music.removeValue(this, true);
        this.reset();
        this.audio.freeSource(this.sourceID);
        this.sourceID = -1;
        this.renderedSeconds = 0.0f;
        this.renderedSecondsQueue.clear();
        this.isPlaying = false;
    }

    public abstract int read(byte[] var1);

    public abstract void reset();

    protected void loop() {
        this.reset();
    }

    public void update() {
        int bufferID;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        boolean end = false;
        int buffers = AL10.alGetSourcei((int)this.sourceID, (int)4118);
        while (buffers-- > 0 && (bufferID = AL10.alSourceUnqueueBuffers((int)this.sourceID)) != 40963) {
            if (this.renderedSecondsQueue.size > 0) {
                this.renderedSeconds = this.renderedSecondsQueue.pop();
            }
            if (end) continue;
            if (this.fill(bufferID)) {
                AL10.alSourceQueueBuffers((int)this.sourceID, (int)bufferID);
                continue;
            }
            end = true;
        }
        if (end && AL10.alGetSourcei((int)this.sourceID, (int)4117) == 0) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion(this);
            }
        }
        if (this.isPlaying && AL10.alGetSourcei((int)this.sourceID, (int)4112) != 4114) {
            AL10.alSourcePlay((int)this.sourceID);
        }
    }

    private boolean fill(int bufferID) {
        ((Buffer)tempBuffer).clear();
        int length = this.read(tempBytes);
        if (length <= 0) {
            if (this.isLooping) {
                this.loop();
                length = this.read(tempBytes);
                if (length <= 0) {
                    return false;
                }
                if (this.renderedSecondsQueue.size > 0) {
                    this.renderedSecondsQueue.set(0, 0.0f);
                }
            } else {
                return false;
            }
        }
        float previousLoadedSeconds = this.renderedSecondsQueue.size > 0 ? this.renderedSecondsQueue.first() : 0.0f;
        float currentBufferSeconds = this.maxSecondsPerBuffer * (float)length / 40960.0f;
        this.renderedSecondsQueue.insert(0, previousLoadedSeconds + currentBufferSeconds);
        ((Buffer)tempBuffer.put(tempBytes, 0, length)).flip();
        AL10.alBufferData((int)bufferID, (int)this.format, (ByteBuffer)tempBuffer, (int)this.sampleRate);
        return true;
    }

    @Override
    public void dispose() {
        this.stop();
        if (this.audio.noDevice) {
            return;
        }
        if (this.buffers == null) {
            return;
        }
        AL10.alDeleteBuffers((IntBuffer)this.buffers);
        this.buffers = null;
        this.onCompletionListener = null;
    }
}

