/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;

public final class GL11 {
    public static void glClearColor(float red, float green, float blue, float alpha) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glClearColor;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglClearColor(red, green, blue, alpha, function_pointer);
    }

    static native void nglClearColor(float var0, float var1, float var2, float var3, long var4);

    public static void glClear(int mask) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glClear;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglClear(mask, function_pointer);
    }

    static native void nglClear(int var0, long var1);

    public static void glBlendFunc(int sfactor, int dfactor) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBlendFunc;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglBlendFunc(sfactor, dfactor, function_pointer);
    }

    static native void nglBlendFunc(int var0, int var1, long var2);

    public static void glBindTexture(int target, int texture) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glBindTexture;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglBindTexture(target, texture, function_pointer);
    }

    static native void nglBindTexture(int var0, int var1, long var2);

    static native void nglDeleteTextures(int var0, long var1, long var3);

    public static void glDeleteTextures(int texture) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDeleteTextures;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglDeleteTextures(1, APIUtil.getInt(caps, texture), function_pointer);
    }

    public static void glEnable(int cap) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glEnable;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglEnable(cap, function_pointer);
    }

    static native void nglEnable(int var0, long var1);

    public static void glDisable(int cap) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDisable;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglDisable(cap, function_pointer);
    }

    static native void nglDisable(int var0, long var1);

    public static void glDrawElements(int mode, ByteBuffer indices) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDrawElements;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureElementVBOdisabled(caps);
        BufferChecks.checkDirect(indices);
        GL11.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.getAddress(indices), function_pointer);
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDrawElements;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureElementVBOdisabled(caps);
        BufferChecks.checkDirect(indices);
        GL11.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.getAddress(indices), function_pointer);
    }

    static native void nglDrawElements(int var0, int var1, int var2, long var3, long var5);

    public static void glDrawElements(int mode, int indices_count, int type, long indices_buffer_offset) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDrawElements;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureElementVBOenabled(caps);
        GL11.nglDrawElementsBO(mode, indices_count, type, indices_buffer_offset, function_pointer);
    }

    static native void nglDrawElementsBO(int var0, int var1, int var2, long var3, long var5);

    public static void glDrawArrays(int mode, int first, int count) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDrawArrays;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglDrawArrays(mode, first, count, function_pointer);
    }

    static native void nglDrawArrays(int var0, int var1, int var2, long var3);

    public static void glDepthMask(boolean flag) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glDepthMask;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglDepthMask(flag, function_pointer);
    }

    static native void nglDepthMask(boolean var0, long var1);

    public static int glGetError() {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetError;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = GL11.nglGetError(function_pointer);
        return __result;
    }

    static native int nglGetError(long var0);

    public static void glGetFloat(int pname, FloatBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetFloatv;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(params, 16);
        GL11.nglGetFloatv(pname, MemoryUtil.getAddress(params), function_pointer);
    }

    static native void nglGetFloatv(int var0, long var1, long var3);

    public static void glGetInteger(int pname, IntBuffer params) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetIntegerv;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(params, 16);
        GL11.nglGetIntegerv(pname, MemoryUtil.getAddress(params), function_pointer);
    }

    static native void nglGetIntegerv(int var0, long var1, long var3);

    public static int glGetInteger(int pname) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetIntegerv;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer params = APIUtil.getBufferInt(caps);
        GL11.nglGetIntegerv(pname, MemoryUtil.getAddress(params), function_pointer);
        return params.get(0);
    }

    static native void nglGenTextures(int var0, long var1, long var3);

    public static int glGenTextures() {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGenTextures;
        BufferChecks.checkFunctionAddress(function_pointer);
        IntBuffer textures = APIUtil.getBufferInt(caps);
        GL11.nglGenTextures(1, MemoryUtil.getAddress(textures), function_pointer);
        return textures.get(0);
    }

    public static String glGetString(int name) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glGetString;
        BufferChecks.checkFunctionAddress(function_pointer);
        String __result = GL11.nglGetString(name, function_pointer);
        return __result;
    }

    static native String nglGetString(int var0, long var1);

    public static void glPixelStorei(int pname, int param) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glPixelStorei;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglPixelStorei(pname, param, function_pointer);
    }

    static native void nglPixelStorei(int var0, int var1, long var2);

    public static void glScissor(int x, int y, int width, int height) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glScissor;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglScissor(x, y, width, height, function_pointer);
    }

    static native void nglScissor(int var0, int var1, int var2, int var3, long var4);

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexImage2D;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureUnpackPBOdisabled(caps);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), function_pointer);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, DoubleBuffer pixels) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexImage2D;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureUnpackPBOdisabled(caps);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), function_pointer);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexImage2D;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureUnpackPBOdisabled(caps);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), function_pointer);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexImage2D;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureUnpackPBOdisabled(caps);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), function_pointer);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexImage2D;
        BufferChecks.checkFunctionAddress(function_pointer);
        GLChecks.ensureUnpackPBOdisabled(caps);
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GL11.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels), function_pointer);
    }

    static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void glTexParameterf(int target, int pname, float param) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexParameterf;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglTexParameterf(target, pname, param, function_pointer);
    }

    static native void nglTexParameterf(int var0, int var1, float var2, long var3);

    public static void glTexParameteri(int target, int pname, int param) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glTexParameteri;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglTexParameteri(target, pname, param, function_pointer);
    }

    static native void nglTexParameteri(int var0, int var1, int var2, long var3);

    public static void glViewport(int x, int y, int width, int height) {
        ContextCapabilities caps = GLContext.getCapabilities();
        long function_pointer = caps.glViewport;
        BufferChecks.checkFunctionAddress(function_pointer);
        GL11.nglViewport(x, y, width, height, function_pointer);
    }

    static native void nglViewport(int var0, int var1, int var2, int var3, long var4);
}

