/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonBounds;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;

public class SkeletonRendererDebug {
    public static final Color boneLineColor = Color.RED;
    public static final Color boneOriginColor = Color.GREEN;
    public static final Color attachmentLineColor = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    public static final Color triangleLineColor = new Color(1.0f, 0.64f, 0.0f, 0.5f);
    public static final Color aabbColor = new Color(0.0f, 1.0f, 0.0f, 0.5f);
    private final ShapeRenderer shapes;
    private boolean drawBones = true;
    private boolean drawRegionAttachments = true;
    private boolean drawBoundingBoxes = true;
    private boolean drawPoints = true;
    private boolean drawMeshHull = true;
    private boolean drawMeshTriangles = true;
    private boolean drawPaths = true;
    private boolean drawClipping = true;
    private final SkeletonBounds bounds = new SkeletonBounds();
    private final FloatArray vertices = new FloatArray(32);
    private float scale = 1.0f;
    private float boneWidth = 2.0f;
    private boolean premultipliedAlpha;
    private final Vector2 temp1 = new Vector2();
    private final Vector2 temp2 = new Vector2();

    public SkeletonRendererDebug() {
        this.shapes = new ShapeRenderer();
    }

    public void draw(Skeleton skeleton) {
        float f;
        int n;
        Object object;
        int n2;
        int n3;
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        Gdx.gl.glEnable(3042);
        int n4 = this.premultipliedAlpha ? 1 : 770;
        Gdx.gl.glBlendFunc(n4, 771);
        ShapeRenderer shapeRenderer = this.shapes;
        Array<Bone> array = skeleton.getBones();
        Array<Slot> array2 = skeleton.getSlots();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        if (this.drawBones) {
            n3 = array.size;
            for (n2 = 0; n2 < n3; ++n2) {
                object = array.get(n2);
                if (((Bone)object).parent == null || !((Bone)object).active) continue;
                float f2 = ((Bone)object).data.length;
                float f3 = this.boneWidth;
                if (f2 == 0.0f) {
                    f2 = 8.0f;
                    f3 /= 2.0f;
                    shapeRenderer.setColor(boneOriginColor);
                } else {
                    shapeRenderer.setColor(boneLineColor);
                }
                float f4 = f2 * ((Bone)object).a + ((Bone)object).worldX;
                float f5 = f2 * ((Bone)object).c + ((Bone)object).worldY;
                shapeRenderer.rectLine(((Bone)object).worldX, ((Bone)object).worldY, f4, f5, f3 * this.scale);
            }
            shapeRenderer.x(skeleton.getX(), skeleton.getY(), 4.0f * this.scale);
        }
        if (this.drawPoints) {
            shapeRenderer.setColor(boneOriginColor);
            n3 = array2.size;
            for (n2 = 0; n2 < n3; ++n2) {
                object = array2.get(n2);
                Attachment attachment = ((Slot)object).attachment;
                if (!(attachment instanceof PointAttachment)) continue;
                PointAttachment pointAttachment = (PointAttachment)attachment;
                pointAttachment.computeWorldPosition(((Slot)object).getBone(), this.temp1);
                this.temp2.set(8.0f, 0.0f).rotate(pointAttachment.computeWorldRotation(((Slot)object).getBone()));
                shapeRenderer.rectLine(this.temp1, this.temp2, this.boneWidth / 2.0f * this.scale);
            }
        }
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        if (this.drawRegionAttachments) {
            shapeRenderer.setColor(attachmentLineColor);
            n3 = array2.size;
            for (n2 = 0; n2 < n3; ++n2) {
                object = array2.get(n2);
                Attachment attachment = ((Slot)object).attachment;
                if (!(attachment instanceof RegionAttachment)) continue;
                RegionAttachment regionAttachment = (RegionAttachment)attachment;
                float[] fArray = this.vertices.items;
                regionAttachment.computeWorldVertices(((Slot)object).getBone(), fArray, 0, 2);
                shapeRenderer.line(fArray[0], fArray[1], fArray[2], fArray[3]);
                shapeRenderer.line(fArray[2], fArray[3], fArray[4], fArray[5]);
                shapeRenderer.line(fArray[4], fArray[5], fArray[6], fArray[7]);
                shapeRenderer.line(fArray[6], fArray[7], fArray[0], fArray[1]);
            }
        }
        if (this.drawMeshHull || this.drawMeshTriangles) {
            n3 = array2.size;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5;
                int n6;
                object = array2.get(n2);
                Attachment attachment = ((Slot)object).attachment;
                if (!(attachment instanceof MeshAttachment)) continue;
                MeshAttachment meshAttachment = (MeshAttachment)attachment;
                float[] fArray = this.vertices.setSize(meshAttachment.getWorldVerticesLength());
                meshAttachment.computeWorldVertices((Slot)object, 0, meshAttachment.getWorldVerticesLength(), fArray, 0, 2);
                short[] sArray = meshAttachment.getTriangles();
                n = meshAttachment.getHullLength();
                if (this.drawMeshTriangles) {
                    shapeRenderer.setColor(triangleLineColor);
                    int n7 = sArray.length;
                    for (int i = 0; i < n7; i += 3) {
                        n6 = sArray[i] * 2;
                        n5 = sArray[i + 1] * 2;
                        int n8 = sArray[i + 2] * 2;
                        shapeRenderer.triangle(fArray[n6], fArray[n6 + 1], fArray[n5], fArray[n5 + 1], fArray[n8], fArray[n8 + 1]);
                    }
                }
                if (!this.drawMeshHull || n <= 0) continue;
                shapeRenderer.setColor(attachmentLineColor);
                float f6 = fArray[n - 2];
                float f7 = fArray[n - 1];
                n5 = n;
                for (n6 = 0; n6 < n5; n6 += 2) {
                    float f8 = fArray[n6];
                    f = fArray[n6 + 1];
                    shapeRenderer.line(f8, f, f6, f7);
                    f6 = f8;
                    f7 = f;
                }
            }
        }
        if (this.drawBoundingBoxes) {
            SkeletonBounds skeletonBounds = this.bounds;
            skeletonBounds.update(skeleton, true);
            shapeRenderer.setColor(aabbColor);
            shapeRenderer.rect(skeletonBounds.getMinX(), skeletonBounds.getMinY(), skeletonBounds.getWidth(), skeletonBounds.getHeight());
            Array<FloatArray> array3 = skeletonBounds.getPolygons();
            object = skeletonBounds.getBoundingBoxes();
            int n9 = array3.size;
            for (int i = 0; i < n9; ++i) {
                FloatArray floatArray = array3.get(i);
                shapeRenderer.setColor(((BoundingBoxAttachment)((Array)object).get(i)).getColor());
                shapeRenderer.polygon(floatArray.items, 0, floatArray.size);
            }
        }
        if (this.drawClipping) {
            int n10 = array2.size;
            for (int i = 0; i < n10; ++i) {
                object = array2.get(i);
                Attachment attachment = ((Slot)object).attachment;
                if (!(attachment instanceof ClippingAttachment)) continue;
                ClippingAttachment clippingAttachment = (ClippingAttachment)attachment;
                int n11 = clippingAttachment.getWorldVerticesLength();
                float[] fArray = this.vertices.setSize(n11);
                clippingAttachment.computeWorldVertices((Slot)object, 0, n11, fArray, 0, 2);
                shapeRenderer.setColor(clippingAttachment.getColor());
                for (n = 2; n < n11; n += 2) {
                    shapeRenderer.line(fArray[n - 2], fArray[n - 1], fArray[n], fArray[n + 1]);
                }
                shapeRenderer.line(fArray[0], fArray[1], fArray[n11 - 2], fArray[n11 - 1]);
            }
        }
        if (this.drawPaths) {
            int n12 = array2.size;
            for (int i = 0; i < n12; ++i) {
                float f9;
                float f10;
                object = array2.get(i);
                Attachment attachment = ((Slot)object).attachment;
                if (!(attachment instanceof PathAttachment)) continue;
                PathAttachment pathAttachment = (PathAttachment)attachment;
                int n13 = pathAttachment.getWorldVerticesLength();
                float[] fArray = this.vertices.setSize(n13);
                pathAttachment.computeWorldVertices((Slot)object, 0, n13, fArray, 0, 2);
                Color color = pathAttachment.getColor();
                float f11 = fArray[2];
                float f12 = fArray[3];
                float f13 = 0.0f;
                float f14 = 0.0f;
                if (pathAttachment.getClosed()) {
                    shapeRenderer.setColor(color);
                    float f15 = fArray[0];
                    f = fArray[1];
                    f10 = fArray[n13 - 2];
                    f9 = fArray[n13 - 1];
                    f13 = fArray[n13 - 4];
                    f14 = fArray[n13 - 3];
                    shapeRenderer.curve(f11, f12, f15, f, f10, f9, f13, f14, 32);
                    shapeRenderer.setColor(Color.LIGHT_GRAY);
                    shapeRenderer.line(f11, f12, f15, f);
                    shapeRenderer.line(f13, f14, f10, f9);
                }
                n13 -= 4;
                for (int j = 4; j < n13; j += 6) {
                    f = fArray[j];
                    f10 = fArray[j + 1];
                    f9 = fArray[j + 2];
                    float f16 = fArray[j + 3];
                    f13 = fArray[j + 4];
                    f14 = fArray[j + 5];
                    shapeRenderer.setColor(color);
                    shapeRenderer.curve(f11, f12, f, f10, f9, f16, f13, f14, 32);
                    shapeRenderer.setColor(Color.LIGHT_GRAY);
                    shapeRenderer.line(f11, f12, f, f10);
                    shapeRenderer.line(f13, f14, f9, f16);
                    f11 = f13;
                    f12 = f14;
                }
            }
        }
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        if (this.drawBones) {
            shapeRenderer.setColor(boneOriginColor);
            int n14 = array.size;
            for (int i = 0; i < n14; ++i) {
                object = array.get(i);
                if (!((Bone)object).active) continue;
                shapeRenderer.circle(((Bone)object).worldX, ((Bone)object).worldY, 3.0f * this.scale, 8);
            }
        }
        if (this.drawPoints) {
            shapeRenderer.setColor(boneOriginColor);
            int n15 = array2.size;
            for (int i = 0; i < n15; ++i) {
                object = array2.get(i);
                Attachment attachment = ((Slot)object).attachment;
                if (!(attachment instanceof PointAttachment)) continue;
                PointAttachment pointAttachment = (PointAttachment)attachment;
                pointAttachment.computeWorldPosition(((Slot)object).getBone(), this.temp1);
                shapeRenderer.circle(this.temp1.x, this.temp1.y, 3.0f * this.scale, 8);
            }
        }
        shapeRenderer.end();
    }

    public ShapeRenderer getShapeRenderer() {
        return this.shapes;
    }

    public void setBones(boolean bl) {
        this.drawBones = bl;
    }

    public void setRegionAttachments(boolean bl) {
        this.drawRegionAttachments = bl;
    }

    public void setBoundingBoxes(boolean bl) {
        this.drawBoundingBoxes = bl;
    }

    public void setMeshHull(boolean bl) {
        this.drawMeshHull = bl;
    }

    public void setMeshTriangles(boolean bl) {
        this.drawMeshTriangles = bl;
    }

    public void setPaths(boolean bl) {
        this.drawPaths = bl;
    }

    public void setPoints(boolean bl) {
        this.drawPoints = bl;
    }

    public void setClipping(boolean bl) {
        this.drawClipping = bl;
    }
}

