/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.ConstraintData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonLoader;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class SkeletonJson
extends SkeletonLoader {
    public SkeletonJson(TextureAtlas textureAtlas) {
        super(textureAtlas);
    }

    @Override
    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SkeletonData skeletonData = this.readSkeletonData(new JsonReader().parse(fileHandle));
        skeletonData.name = fileHandle.nameWithoutExtension();
        return skeletonData;
    }

    public SkeletonData readSkeletonData(JsonValue jsonValue) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (jsonValue == null) {
            throw new IllegalArgumentException("root cannot be null.");
        }
        float f = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        JsonValue jsonValue2 = jsonValue.get("skeleton");
        if (jsonValue2 != null) {
            skeletonData.hash = jsonValue2.getString("hash", null);
            skeletonData.version = jsonValue2.getString("spine", null);
            skeletonData.x = jsonValue2.getFloat("x", 0.0f);
            skeletonData.y = jsonValue2.getFloat("y", 0.0f);
            skeletonData.width = jsonValue2.getFloat("width", 0.0f);
            skeletonData.height = jsonValue2.getFloat("height", 0.0f);
            skeletonData.fps = jsonValue2.getFloat("fps", 30.0f);
            skeletonData.imagesPath = jsonValue2.getString("images", null);
            skeletonData.audioPath = jsonValue2.getString("audio", null);
        }
        Object object6 = jsonValue.getChild("bones");
        while (object6 != null) {
            object5 = null;
            object4 = ((JsonValue)object6).getString("parent", null);
            if (object4 != null && (object5 = skeletonData.findBone((String)object4)) == null) {
                throw new SerializationException("Parent bone not found: " + (String)object4);
            }
            object3 = new BoneData(skeletonData.bones.size, ((JsonValue)object6).getString("name"), (BoneData)object5);
            ((BoneData)object3).length = ((JsonValue)object6).getFloat("length", 0.0f) * f;
            ((BoneData)object3).x = ((JsonValue)object6).getFloat("x", 0.0f) * f;
            ((BoneData)object3).y = ((JsonValue)object6).getFloat("y", 0.0f) * f;
            ((BoneData)object3).rotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
            ((BoneData)object3).scaleX = ((JsonValue)object6).getFloat("scaleX", 1.0f);
            ((BoneData)object3).scaleY = ((JsonValue)object6).getFloat("scaleY", 1.0f);
            ((BoneData)object3).shearX = ((JsonValue)object6).getFloat("shearX", 0.0f);
            ((BoneData)object3).shearY = ((JsonValue)object6).getFloat("shearY", 0.0f);
            ((BoneData)object3).transformMode = BoneData.TransformMode.valueOf(((JsonValue)object6).getString("transform", BoneData.TransformMode.normal.name()));
            ((BoneData)object3).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object2 = ((JsonValue)object6).getString("color", null);
            if (object2 != null) {
                Color.valueOf((String)object2, ((BoneData)object3).getColor());
            }
            skeletonData.bones.add((BoneData)object3);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("slots");
        while (object6 != null) {
            String string;
            object5 = ((JsonValue)object6).getString("name");
            object4 = ((JsonValue)object6).getString("bone");
            object3 = skeletonData.findBone((String)object4);
            if (object3 == null) {
                throw new SerializationException("Slot bone not found: " + (String)object4);
            }
            object2 = new SlotData(skeletonData.slots.size, (String)object5, (BoneData)object3);
            object = ((JsonValue)object6).getString("color", null);
            if (object != null) {
                Color.valueOf((String)object, ((SlotData)object2).getColor());
            }
            if ((string = ((JsonValue)object6).getString("dark", null)) != null) {
                ((SlotData)object2).setDarkColor(Color.valueOf(string));
            }
            ((SlotData)object2).attachmentName = ((JsonValue)object6).getString("attachment", null);
            ((SlotData)object2).blendMode = BlendMode.valueOf(((JsonValue)object6).getString("blend", BlendMode.normal.name()));
            skeletonData.slots.add((SlotData)object2);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("ik");
        while (object6 != null) {
            object5 = new IkConstraintData(((JsonValue)object6).getString("name"));
            ((IkConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((IkConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("IK bone not found: " + object4);
                }
                ((IkConstraintData)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("target");
            ((IkConstraintData)object5).target = skeletonData.findBone((String)object4);
            if (((IkConstraintData)object5).target == null) {
                throw new SerializationException("IK target bone not found: " + (String)object4);
            }
            ((IkConstraintData)object5).mix = ((JsonValue)object6).getFloat("mix", 1.0f);
            ((IkConstraintData)object5).softness = ((JsonValue)object6).getFloat("softness", 0.0f) * f;
            ((IkConstraintData)object5).bendDirection = ((JsonValue)object6).getBoolean("bendPositive", true) ? 1 : -1;
            ((IkConstraintData)object5).compress = ((JsonValue)object6).getBoolean("compress", false);
            ((IkConstraintData)object5).stretch = ((JsonValue)object6).getBoolean("stretch", false);
            ((IkConstraintData)object5).uniform = ((JsonValue)object6).getBoolean("uniform", false);
            skeletonData.ikConstraints.add((IkConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("transform");
        while (object6 != null) {
            object5 = new TransformConstraintData(((JsonValue)object6).getString("name"));
            ((TransformConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((TransformConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Transform constraint bone not found: " + object4);
                }
                ((TransformConstraintData)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("target");
            ((TransformConstraintData)object5).target = skeletonData.findBone((String)object4);
            if (((TransformConstraintData)object5).target == null) {
                throw new SerializationException("Transform constraint target bone not found: " + (String)object4);
            }
            ((TransformConstraintData)object5).local = ((JsonValue)object6).getBoolean("local", false);
            ((TransformConstraintData)object5).relative = ((JsonValue)object6).getBoolean("relative", false);
            ((TransformConstraintData)object5).offsetRotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
            ((TransformConstraintData)object5).offsetX = ((JsonValue)object6).getFloat("x", 0.0f) * f;
            ((TransformConstraintData)object5).offsetY = ((JsonValue)object6).getFloat("y", 0.0f) * f;
            ((TransformConstraintData)object5).offsetScaleX = ((JsonValue)object6).getFloat("scaleX", 0.0f);
            ((TransformConstraintData)object5).offsetScaleY = ((JsonValue)object6).getFloat("scaleY", 0.0f);
            ((TransformConstraintData)object5).offsetShearY = ((JsonValue)object6).getFloat("shearY", 0.0f);
            ((TransformConstraintData)object5).mixRotate = ((JsonValue)object6).getFloat("mixRotate", 1.0f);
            ((TransformConstraintData)object5).mixX = ((JsonValue)object6).getFloat("mixX", 1.0f);
            ((TransformConstraintData)object5).mixY = ((JsonValue)object6).getFloat("mixY", ((TransformConstraintData)object5).mixX);
            ((TransformConstraintData)object5).mixScaleX = ((JsonValue)object6).getFloat("mixScaleX", 1.0f);
            ((TransformConstraintData)object5).mixScaleY = ((JsonValue)object6).getFloat("mixScaleY", ((TransformConstraintData)object5).mixScaleX);
            ((TransformConstraintData)object5).mixShearY = ((JsonValue)object6).getFloat("mixShearY", 1.0f);
            skeletonData.transformConstraints.add((TransformConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("path");
        while (object6 != null) {
            object5 = new PathConstraintData(((JsonValue)object6).getString("name"));
            ((PathConstraintData)object5).order = ((JsonValue)object6).getInt("order", 0);
            ((PathConstraintData)object5).skinRequired = ((JsonValue)object6).getBoolean("skin", false);
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Path bone not found: " + object4);
                }
                ((PathConstraintData)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getString("target");
            ((PathConstraintData)object5).target = skeletonData.findSlot((String)object4);
            if (((PathConstraintData)object5).target == null) {
                throw new SerializationException("Path target slot not found: " + (String)object4);
            }
            ((PathConstraintData)object5).positionMode = PathConstraintData.PositionMode.valueOf(((JsonValue)object6).getString("positionMode", "percent"));
            ((PathConstraintData)object5).spacingMode = PathConstraintData.SpacingMode.valueOf(((JsonValue)object6).getString("spacingMode", "length"));
            ((PathConstraintData)object5).rotateMode = PathConstraintData.RotateMode.valueOf(((JsonValue)object6).getString("rotateMode", "tangent"));
            ((PathConstraintData)object5).offsetRotation = ((JsonValue)object6).getFloat("rotation", 0.0f);
            ((PathConstraintData)object5).position = ((JsonValue)object6).getFloat("position", 0.0f);
            if (((PathConstraintData)object5).positionMode == PathConstraintData.PositionMode.fixed) {
                ((PathConstraintData)object5).position *= f;
            }
            ((PathConstraintData)object5).spacing = ((JsonValue)object6).getFloat("spacing", 0.0f);
            if (((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.fixed) {
                ((PathConstraintData)object5).spacing *= f;
            }
            ((PathConstraintData)object5).mixRotate = ((JsonValue)object6).getFloat("mixRotate", 1.0f);
            ((PathConstraintData)object5).mixX = ((JsonValue)object6).getFloat("mixX", 1.0f);
            ((PathConstraintData)object5).mixY = ((JsonValue)object6).getFloat("mixY", 1.0f);
            skeletonData.pathConstraints.add((PathConstraintData)object5);
            object6 = ((JsonValue)object6).next;
        }
        object6 = jsonValue.getChild("skins");
        while (object6 != null) {
            object5 = new Skin(((JsonValue)object6).getString("name"));
            object4 = ((JsonValue)object6).getChild("bones");
            while (object4 != null) {
                object3 = skeletonData.findBone(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin bone not found: " + object4);
                }
                ((Skin)object5).bones.add((BoneData)object3);
                object4 = ((JsonValue)object4).next;
            }
            ((Skin)object5).bones.shrink();
            object4 = ((JsonValue)object6).getChild("ik");
            while (object4 != null) {
                object3 = skeletonData.findIkConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin IK constraint not found: " + object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getChild("transform");
            while (object4 != null) {
                object3 = skeletonData.findTransformConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin transform constraint not found: " + object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            object4 = ((JsonValue)object6).getChild("path");
            while (object4 != null) {
                object3 = skeletonData.findPathConstraint(((JsonValue)object4).asString());
                if (object3 == null) {
                    throw new SerializationException("Skin path constraint not found: " + object4);
                }
                ((Skin)object5).constraints.add((ConstraintData)object3);
                object4 = ((JsonValue)object4).next;
            }
            ((Skin)object5).constraints.shrink();
            object4 = ((JsonValue)object6).getChild("attachments");
            while (object4 != null) {
                object3 = skeletonData.findSlot(((JsonValue)object4).name);
                if (object3 == null) {
                    throw new SerializationException("Slot not found: " + ((JsonValue)object4).name);
                }
                object2 = ((JsonValue)object4).child;
                while (object2 != null) {
                    try {
                        object = this.readAttachment((JsonValue)object2, (Skin)object5, ((SlotData)object3).index, ((JsonValue)object2).name, skeletonData);
                        if (object != null) {
                            ((Skin)object5).setAttachment(((SlotData)object3).index, ((JsonValue)object2).name, (Attachment)object);
                        }
                    }
                    catch (Throwable throwable) {
                        throw new SerializationException("Error reading attachment: " + ((JsonValue)object2).name + ", skin: " + object5, throwable);
                    }
                    object2 = ((JsonValue)object2).next;
                }
                object4 = ((JsonValue)object4).next;
            }
            skeletonData.skins.add((Skin)object5);
            if (((Skin)object5).name.equals("default")) {
                skeletonData.defaultSkin = object5;
            }
            object6 = ((JsonValue)object6).next;
        }
        object6 = this.linkedMeshes.items;
        int n = this.linkedMeshes.size;
        for (int i = 0; i < n; ++i) {
            object3 = (LinkedMesh)object6[i];
            Object object7 = object2 = ((LinkedMesh)object3).skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(((LinkedMesh)object3).skin);
            if (object2 == null) {
                throw new SerializationException("Skin not found: " + ((LinkedMesh)object3).skin);
            }
            object = ((Skin)object2).getAttachment(((LinkedMesh)object3).slotIndex, ((LinkedMesh)object3).parent);
            if (object == null) {
                throw new SerializationException("Parent mesh not found: " + ((LinkedMesh)object3).parent);
            }
            ((LinkedMesh)object3).mesh.setDeformAttachment(((LinkedMesh)object3).inheritDeform ? (VertexAttachment)object : ((LinkedMesh)object3).mesh);
            ((LinkedMesh)object3).mesh.setParentMesh((MeshAttachment)object);
            ((LinkedMesh)object3).mesh.updateUVs();
        }
        this.linkedMeshes.clear();
        JsonValue jsonValue3 = jsonValue.getChild("events");
        while (jsonValue3 != null) {
            EventData eventData = new EventData(jsonValue3.name);
            eventData.intValue = jsonValue3.getInt("int", 0);
            eventData.floatValue = jsonValue3.getFloat("float", 0.0f);
            eventData.stringValue = jsonValue3.getString("string", "");
            eventData.audioPath = jsonValue3.getString("audio", null);
            if (eventData.audioPath != null) {
                eventData.volume = jsonValue3.getFloat("volume", 1.0f);
                eventData.balance = jsonValue3.getFloat("balance", 0.0f);
            }
            skeletonData.events.add(eventData);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("animations");
        while (jsonValue3 != null) {
            try {
                this.readAnimation(jsonValue3, jsonValue3.name, skeletonData);
            }
            catch (Throwable throwable) {
                throw new SerializationException("Error reading animation: " + jsonValue3.name, throwable);
            }
            jsonValue3 = jsonValue3.next;
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Attachment readAttachment(JsonValue jsonValue, Skin skin, int n, String string, SkeletonData skeletonData) {
        float f = this.scale;
        string = jsonValue.getString("name", string);
        switch (AttachmentType.valueOf(jsonValue.getString("type", AttachmentType.region.name()))) {
            case region: {
                String string2 = jsonValue.getString("path", string);
                RegionAttachment regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string, string2);
                if (regionAttachment == null) {
                    return null;
                }
                regionAttachment.setPath(string2);
                regionAttachment.setX(jsonValue.getFloat("x", 0.0f) * f);
                regionAttachment.setY(jsonValue.getFloat("y", 0.0f) * f);
                regionAttachment.setScaleX(jsonValue.getFloat("scaleX", 1.0f));
                regionAttachment.setScaleY(jsonValue.getFloat("scaleY", 1.0f));
                regionAttachment.setRotation(jsonValue.getFloat("rotation", 0.0f));
                regionAttachment.setWidth(jsonValue.getFloat("width") * f);
                regionAttachment.setHeight(jsonValue.getFloat("height") * f);
                String string3 = jsonValue.getString("color", null);
                if (string3 != null) {
                    Color.valueOf(string3, regionAttachment.getColor());
                }
                regionAttachment.updateOffset();
                return regionAttachment;
            }
            case boundingbox: {
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                this.readVertices(jsonValue, boundingBoxAttachment, jsonValue.getInt("vertexCount") << 1);
                String string4 = jsonValue.getString("color", null);
                if (string4 != null) {
                    Color.valueOf(string4, boundingBoxAttachment.getColor());
                }
                return boundingBoxAttachment;
            }
            case mesh: 
            case linkedmesh: {
                String string5 = jsonValue.getString("path", string);
                MeshAttachment meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string, string5);
                if (meshAttachment == null) {
                    return null;
                }
                meshAttachment.setPath(string5);
                String string6 = jsonValue.getString("color", null);
                if (string6 != null) {
                    Color.valueOf(string6, meshAttachment.getColor());
                }
                meshAttachment.setWidth(jsonValue.getFloat("width", 0.0f) * f);
                meshAttachment.setHeight(jsonValue.getFloat("height", 0.0f) * f);
                String string7 = jsonValue.getString("parent", null);
                if (string7 != null) {
                    this.linkedMeshes.add(new LinkedMesh(meshAttachment, jsonValue.getString("skin", null), n, string7, jsonValue.getBoolean("deform", true)));
                    return meshAttachment;
                }
                float[] fArray = jsonValue.require("uvs").asFloatArray();
                this.readVertices(jsonValue, meshAttachment, fArray.length);
                meshAttachment.setTriangles(jsonValue.require("triangles").asShortArray());
                meshAttachment.setRegionUVs(fArray);
                meshAttachment.updateUVs();
                if (jsonValue.has("hull")) {
                    meshAttachment.setHullLength(jsonValue.require("hull").asInt() << 1);
                }
                if (jsonValue.has("edges")) {
                    meshAttachment.setEdges(jsonValue.require("edges").asShortArray());
                }
                return meshAttachment;
            }
            case path: {
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(jsonValue.getBoolean("closed", false));
                pathAttachment.setConstantSpeed(jsonValue.getBoolean("constantSpeed", true));
                int n2 = jsonValue.getInt("vertexCount");
                this.readVertices(jsonValue, pathAttachment, n2 << 1);
                float[] fArray = new float[n2 / 3];
                int n3 = 0;
                Object object = jsonValue.require((String)"lengths").child;
                while (object != null) {
                    fArray[n3++] = ((JsonValue)object).asFloat() * f;
                    object = ((JsonValue)object).next;
                }
                pathAttachment.setLengths(fArray);
                object = jsonValue.getString("color", null);
                if (object != null) {
                    Color.valueOf((String)object, pathAttachment.getColor());
                }
                return pathAttachment;
            }
            case point: {
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(jsonValue.getFloat("x", 0.0f) * f);
                pointAttachment.setY(jsonValue.getFloat("y", 0.0f) * f);
                pointAttachment.setRotation(jsonValue.getFloat("rotation", 0.0f));
                String string8 = jsonValue.getString("color", null);
                if (string8 != null) {
                    Color.valueOf(string8, pointAttachment.getColor());
                }
                return pointAttachment;
            }
            case clipping: {
                Object object;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string);
                if (clippingAttachment == null) {
                    return null;
                }
                String string9 = jsonValue.getString("end", null);
                if (string9 != null) {
                    object = skeletonData.findSlot(string9);
                    if (object == null) {
                        throw new SerializationException("Clipping end slot not found: " + string9);
                    }
                    clippingAttachment.setEndSlot((SlotData)object);
                }
                this.readVertices(jsonValue, clippingAttachment, jsonValue.getInt("vertexCount") << 1);
                object = jsonValue.getString("color", null);
                if (object != null) {
                    Color.valueOf((String)object, clippingAttachment.getColor());
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private void readVertices(JsonValue jsonValue, VertexAttachment vertexAttachment, int n) {
        vertexAttachment.setWorldVerticesLength(n);
        float[] fArray = jsonValue.require("vertices").asFloatArray();
        if (n == fArray.length) {
            if (this.scale != 1.0f) {
                int n2 = 0;
                int n3 = fArray.length;
                while (n2 < n3) {
                    int n4 = n2++;
                    fArray[n4] = fArray[n4] * this.scale;
                }
            }
            vertexAttachment.setVertices(fArray);
            return;
        }
        FloatArray floatArray = new FloatArray(n * 3 * 3);
        IntArray intArray = new IntArray(n * 3);
        int n5 = 0;
        int n6 = fArray.length;
        while (n5 < n6) {
            int n7 = (int)fArray[n5++];
            intArray.add(n7);
            int n8 = n5 + (n7 << 2);
            while (n5 < n8) {
                intArray.add((int)fArray[n5]);
                floatArray.add(fArray[n5 + 1] * this.scale);
                floatArray.add(fArray[n5 + 2] * this.scale);
                floatArray.add(fArray[n5 + 3]);
                n5 += 4;
            }
        }
        vertexAttachment.setBones(intArray.toArray());
        vertexAttachment.setVertices(floatArray.toArray());
    }

    private void readAnimation(JsonValue jsonValue, String string, SkeletonData skeletonData) {
        JsonValue jsonValue2;
        float f;
        float f2;
        JsonValue jsonValue3;
        float f3;
        float f4;
        float f5;
        int n;
        Animation.Timeline timeline;
        String string2;
        int n2;
        Object object;
        Object object2;
        Object object3;
        float f6 = this.scale;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>();
        JsonValue jsonValue4 = jsonValue.getChild("slots");
        while (jsonValue4 != null) {
            object3 = skeletonData.findSlot(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Slot not found: " + jsonValue4.name);
            }
            object2 = jsonValue4.child;
            while (object2 != null) {
                object = ((JsonValue)object2).child;
                if (object != null) {
                    float f7;
                    float f8;
                    float f9;
                    int n3;
                    float f10;
                    String string3;
                    n2 = ((JsonValue)object2).size;
                    string2 = ((JsonValue)object2).name;
                    if (string2.equals("attachment")) {
                        timeline = new Animation.AttachmentTimeline(n2, ((SlotData)object3).index);
                        n = 0;
                        while (object != null) {
                            ((Animation.AttachmentTimeline)timeline).setFrame(n, ((JsonValue)object).getFloat("time", 0.0f), ((JsonValue)object).getString("name"));
                            object = ((JsonValue)object).next;
                            ++n;
                        }
                        array.add(timeline);
                    } else if (string2.equals("rgba")) {
                        timeline = new Animation.RGBATimeline(n2, n2 << 2, ((SlotData)object3).index);
                        float f11 = ((JsonValue)object).getFloat("time", 0.0f);
                        string3 = ((JsonValue)object).getString("color");
                        f10 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                        f3 = (float)Integer.parseInt(string3.substring(6, 8), 16) / 255.0f;
                        int n4 = 0;
                        int n5 = 0;
                        while (true) {
                            ((Animation.RGBATimeline)timeline).setFrame(n4, f11, f10, f5, f4, f3);
                            jsonValue3 = ((JsonValue)object).next;
                            if (jsonValue3 == null) break;
                            float f12 = jsonValue3.getFloat("time", 0.0f);
                            string3 = jsonValue3.getString("color");
                            float f13 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                            float f14 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                            f2 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                            f = (float)Integer.parseInt(string3.substring(6, 8), 16) / 255.0f;
                            jsonValue2 = ((JsonValue)object).get("curve");
                            if (jsonValue2 != null) {
                                n5 = this.readCurve(jsonValue2, (Animation.CurveTimeline)timeline, n5, n4, 0, f11, f12, f10, f13, 1.0f);
                                n5 = this.readCurve(jsonValue2, (Animation.CurveTimeline)timeline, n5, n4, 1, f11, f12, f5, f14, 1.0f);
                                n5 = this.readCurve(jsonValue2, (Animation.CurveTimeline)timeline, n5, n4, 2, f11, f12, f4, f2, 1.0f);
                                n5 = this.readCurve(jsonValue2, (Animation.CurveTimeline)timeline, n5, n4, 3, f11, f12, f3, f, 1.0f);
                            }
                            f11 = f12;
                            f10 = f13;
                            f5 = f14;
                            f4 = f2;
                            f3 = f;
                            object = jsonValue3;
                            ++n4;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n5);
                        array.add(timeline);
                    } else if (string2.equals("rgb")) {
                        timeline = new Animation.RGBTimeline(n2, n2 * 3, ((SlotData)object3).index);
                        float f15 = ((JsonValue)object).getFloat("time", 0.0f);
                        string3 = ((JsonValue)object).getString("color");
                        f10 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                        int n6 = 0;
                        int n7 = 0;
                        while (true) {
                            ((Animation.RGBTimeline)timeline).setFrame(n6, f15, f10, f5, f4);
                            JsonValue jsonValue5 = ((JsonValue)object).next;
                            if (jsonValue5 == null) break;
                            float f16 = jsonValue5.getFloat("time", 0.0f);
                            string3 = jsonValue5.getString("color");
                            float f17 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                            float f18 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                            float f19 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                            JsonValue jsonValue6 = ((JsonValue)object).get("curve");
                            if (jsonValue6 != null) {
                                n7 = this.readCurve(jsonValue6, (Animation.CurveTimeline)timeline, n7, n6, 0, f15, f16, f10, f17, 1.0f);
                                n7 = this.readCurve(jsonValue6, (Animation.CurveTimeline)timeline, n7, n6, 1, f15, f16, f5, f18, 1.0f);
                                n7 = this.readCurve(jsonValue6, (Animation.CurveTimeline)timeline, n7, n6, 2, f15, f16, f4, f19, 1.0f);
                            }
                            f15 = f16;
                            f10 = f17;
                            f5 = f18;
                            f4 = f19;
                            object = jsonValue5;
                            ++n6;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n7);
                        array.add(timeline);
                    } else if (string2.equals("alpha")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.AlphaTimeline(n2, n2, ((SlotData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("rgba2")) {
                        timeline = new Animation.RGBA2Timeline(n2, n2 * 7, ((SlotData)object3).index);
                        float f20 = ((JsonValue)object).getFloat("time", 0.0f);
                        string3 = ((JsonValue)object).getString("light");
                        f10 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                        f3 = (float)Integer.parseInt(string3.substring(6, 8), 16) / 255.0f;
                        string3 = ((JsonValue)object).getString("dark");
                        float f21 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                        float f22 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                        float f23 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                        n3 = 0;
                        int n8 = 0;
                        while (true) {
                            ((Animation.RGBA2Timeline)timeline).setFrame(n3, f20, f10, f5, f4, f3, f21, f22, f23);
                            JsonValue jsonValue7 = ((JsonValue)object).next;
                            if (jsonValue7 == null) break;
                            f2 = jsonValue7.getFloat("time", 0.0f);
                            string3 = jsonValue7.getString("light");
                            f = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                            float f24 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                            f9 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                            f8 = (float)Integer.parseInt(string3.substring(6, 8), 16) / 255.0f;
                            string3 = jsonValue7.getString("dark");
                            f7 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                            float f25 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                            float f26 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                            JsonValue jsonValue8 = ((JsonValue)object).get("curve");
                            if (jsonValue8 != null) {
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 0, f20, f2, f10, f, 1.0f);
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 1, f20, f2, f5, f24, 1.0f);
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 2, f20, f2, f4, f9, 1.0f);
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 3, f20, f2, f3, f8, 1.0f);
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 4, f20, f2, f21, f7, 1.0f);
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 5, f20, f2, f22, f25, 1.0f);
                                n8 = this.readCurve(jsonValue8, (Animation.CurveTimeline)timeline, n8, n3, 6, f20, f2, f23, f26, 1.0f);
                            }
                            f20 = f2;
                            f10 = f;
                            f5 = f24;
                            f4 = f9;
                            f3 = f8;
                            f21 = f7;
                            f22 = f25;
                            f23 = f26;
                            object = jsonValue7;
                            ++n3;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n8);
                        array.add(timeline);
                    } else if (string2.equals("rgb2")) {
                        timeline = new Animation.RGB2Timeline(n2, n2 * 6, ((SlotData)object3).index);
                        float f27 = ((JsonValue)object).getFloat("time", 0.0f);
                        string3 = ((JsonValue)object).getString("light");
                        f10 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                        f5 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                        f4 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                        string3 = ((JsonValue)object).getString("dark");
                        f3 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                        float f28 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                        float f29 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                        int n9 = 0;
                        n3 = 0;
                        while (true) {
                            ((Animation.RGB2Timeline)timeline).setFrame(n9, f27, f10, f5, f4, f3, f28, f29);
                            JsonValue jsonValue9 = ((JsonValue)object).next;
                            if (jsonValue9 == null) break;
                            float f30 = jsonValue9.getFloat("time", 0.0f);
                            string3 = jsonValue9.getString("light");
                            f2 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                            f = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                            float f31 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                            string3 = jsonValue9.getString("dark");
                            f9 = (float)Integer.parseInt(string3.substring(0, 2), 16) / 255.0f;
                            f8 = (float)Integer.parseInt(string3.substring(2, 4), 16) / 255.0f;
                            f7 = (float)Integer.parseInt(string3.substring(4, 6), 16) / 255.0f;
                            JsonValue jsonValue10 = ((JsonValue)object).get("curve");
                            if (jsonValue10 != null) {
                                n3 = this.readCurve(jsonValue10, (Animation.CurveTimeline)timeline, n3, n9, 0, f27, f30, f10, f2, 1.0f);
                                n3 = this.readCurve(jsonValue10, (Animation.CurveTimeline)timeline, n3, n9, 1, f27, f30, f5, f, 1.0f);
                                n3 = this.readCurve(jsonValue10, (Animation.CurveTimeline)timeline, n3, n9, 2, f27, f30, f4, f31, 1.0f);
                                n3 = this.readCurve(jsonValue10, (Animation.CurveTimeline)timeline, n3, n9, 3, f27, f30, f3, f9, 1.0f);
                                n3 = this.readCurve(jsonValue10, (Animation.CurveTimeline)timeline, n3, n9, 4, f27, f30, f28, f8, 1.0f);
                                n3 = this.readCurve(jsonValue10, (Animation.CurveTimeline)timeline, n3, n9, 5, f27, f30, f29, f7, 1.0f);
                            }
                            f27 = f30;
                            f10 = f2;
                            f5 = f;
                            f4 = f31;
                            f3 = f9;
                            f28 = f8;
                            f29 = f7;
                            object = jsonValue9;
                            ++n9;
                        }
                        ((Animation.CurveTimeline)timeline).shrink(n3);
                        array.add(timeline);
                    } else {
                        throw new RuntimeException("Invalid timeline type for a slot: " + string2 + " (" + jsonValue4.name + ")");
                    }
                }
                object2 = ((JsonValue)object2).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("bones");
        while (jsonValue4 != null) {
            object3 = skeletonData.findBone(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Bone not found: " + jsonValue4.name);
            }
            object2 = jsonValue4.child;
            while (object2 != null) {
                object = ((JsonValue)object2).child;
                if (object != null) {
                    n2 = ((JsonValue)object2).size;
                    string2 = ((JsonValue)object2).name;
                    if (string2.equals("rotate")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.RotateTimeline(n2, n2, ((BoneData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("translate")) {
                        timeline = new Animation.TranslateTimeline(n2, n2 << 1, ((BoneData)object3).index);
                        array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline2)timeline, "x", "y", 0.0f, f6));
                    } else if (string2.equals("translatex")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.TranslateXTimeline(n2, n2, ((BoneData)object3).index), 0.0f, f6));
                    } else if (string2.equals("translatey")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.TranslateYTimeline(n2, n2, ((BoneData)object3).index), 0.0f, f6));
                    } else if (string2.equals("scale")) {
                        timeline = new Animation.ScaleTimeline(n2, n2 << 1, ((BoneData)object3).index);
                        array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline2)timeline, "x", "y", 1.0f, 1.0f));
                    } else if (string2.equals("scalex")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ScaleXTimeline(n2, n2, ((BoneData)object3).index), 1.0f, 1.0f));
                    } else if (string2.equals("scaley")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ScaleYTimeline(n2, n2, ((BoneData)object3).index), 1.0f, 1.0f));
                    } else if (string2.equals("shear")) {
                        timeline = new Animation.ShearTimeline(n2, n2 << 1, ((BoneData)object3).index);
                        array.add(this.readTimeline((JsonValue)object, (Animation.CurveTimeline2)timeline, "x", "y", 0.0f, 1.0f));
                    } else if (string2.equals("shearx")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ShearXTimeline(n2, n2, ((BoneData)object3).index), 0.0f, 1.0f));
                    } else if (string2.equals("sheary")) {
                        array.add(this.readTimeline((JsonValue)object, new Animation.ShearYTimeline(n2, n2, ((BoneData)object3).index), 0.0f, 1.0f));
                    } else {
                        throw new RuntimeException("Invalid timeline type for a bone: " + string2 + " (" + jsonValue4.name + ")");
                    }
                }
                object2 = ((JsonValue)object2).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("ik");
        while (jsonValue4 != null) {
            object3 = jsonValue4.child;
            if (object3 != null) {
                object2 = skeletonData.findIkConstraint(jsonValue4.name);
                object = new Animation.IkConstraintTimeline(jsonValue4.size, jsonValue4.size << 1, skeletonData.getIkConstraints().indexOf((IkConstraintData)object2, true));
                float f32 = ((JsonValue)object3).getFloat("time", 0.0f);
                float f33 = ((JsonValue)object3).getFloat("mix", 1.0f);
                float f34 = ((JsonValue)object3).getFloat("softness", 0.0f) * f6;
                n = 0;
                int n10 = 0;
                while (true) {
                    ((Animation.IkConstraintTimeline)object).setFrame(n, f32, f33, f34, ((JsonValue)object3).getBoolean("bendPositive", true) ? 1 : -1, ((JsonValue)object3).getBoolean("compress", false), ((JsonValue)object3).getBoolean("stretch", false));
                    JsonValue jsonValue11 = ((JsonValue)object3).next;
                    if (jsonValue11 == null) break;
                    f5 = jsonValue11.getFloat("time", 0.0f);
                    f4 = jsonValue11.getFloat("mix", 1.0f);
                    f3 = jsonValue11.getFloat("softness", 0.0f) * f6;
                    JsonValue jsonValue12 = ((JsonValue)object3).get("curve");
                    if (jsonValue12 != null) {
                        n10 = this.readCurve(jsonValue12, (Animation.CurveTimeline)object, n10, n, 0, f32, f5, f33, f4, 1.0f);
                        n10 = this.readCurve(jsonValue12, (Animation.CurveTimeline)object, n10, n, 1, f32, f5, f34, f3, f6);
                    }
                    f32 = f5;
                    f33 = f4;
                    f34 = f3;
                    object3 = jsonValue11;
                    ++n;
                }
                ((Animation.CurveTimeline)object).shrink(n10);
                array.add((Animation.Timeline)object);
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("transform");
        while (jsonValue4 != null) {
            object3 = jsonValue4.child;
            if (object3 != null) {
                object2 = skeletonData.findTransformConstraint(jsonValue4.name);
                object = new Animation.TransformConstraintTimeline(jsonValue4.size, jsonValue4.size * 6, skeletonData.getTransformConstraints().indexOf((TransformConstraintData)object2, true));
                float f35 = ((JsonValue)object3).getFloat("time", 0.0f);
                float f36 = ((JsonValue)object3).getFloat("mixRotate", 1.0f);
                float f37 = ((JsonValue)object3).getFloat("mixX", 1.0f);
                float f38 = ((JsonValue)object3).getFloat("mixY", f37);
                float f39 = ((JsonValue)object3).getFloat("mixScaleX", 1.0f);
                float f40 = ((JsonValue)object3).getFloat("mixScaleY", f39);
                f5 = ((JsonValue)object3).getFloat("mixShearY", 1.0f);
                int n11 = 0;
                int n12 = 0;
                while (true) {
                    ((Animation.TransformConstraintTimeline)object).setFrame(n11, f35, f36, f37, f38, f39, f40, f5);
                    JsonValue jsonValue13 = ((JsonValue)object3).next;
                    if (jsonValue13 == null) break;
                    float f41 = jsonValue13.getFloat("time", 0.0f);
                    float f42 = jsonValue13.getFloat("mixRotate", 1.0f);
                    float f43 = jsonValue13.getFloat("mixX", 1.0f);
                    float f44 = jsonValue13.getFloat("mixY", f43);
                    float f45 = jsonValue13.getFloat("mixScaleX", 1.0f);
                    f2 = jsonValue13.getFloat("mixScaleY", f45);
                    f = jsonValue13.getFloat("mixShearY", 1.0f);
                    jsonValue2 = ((JsonValue)object3).get("curve");
                    if (jsonValue2 != null) {
                        n12 = this.readCurve(jsonValue2, (Animation.CurveTimeline)object, n12, n11, 0, f35, f41, f36, f42, 1.0f);
                        n12 = this.readCurve(jsonValue2, (Animation.CurveTimeline)object, n12, n11, 1, f35, f41, f37, f43, 1.0f);
                        n12 = this.readCurve(jsonValue2, (Animation.CurveTimeline)object, n12, n11, 2, f35, f41, f38, f44, 1.0f);
                        n12 = this.readCurve(jsonValue2, (Animation.CurveTimeline)object, n12, n11, 3, f35, f41, f39, f45, 1.0f);
                        n12 = this.readCurve(jsonValue2, (Animation.CurveTimeline)object, n12, n11, 4, f35, f41, f40, f2, 1.0f);
                        n12 = this.readCurve(jsonValue2, (Animation.CurveTimeline)object, n12, n11, 5, f35, f41, f5, f, 1.0f);
                    }
                    f35 = f41;
                    f36 = f42;
                    f37 = f43;
                    f38 = f44;
                    f39 = f45;
                    f40 = f2;
                    f39 = f45;
                    object3 = jsonValue13;
                    ++n11;
                }
                ((Animation.CurveTimeline)object).shrink(n12);
                array.add((Animation.Timeline)object);
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("path");
        while (jsonValue4 != null) {
            object3 = skeletonData.findPathConstraint(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Path constraint not found: " + jsonValue4.name);
            }
            int n13 = skeletonData.pathConstraints.indexOf((PathConstraintData)object3, true);
            object = jsonValue4.child;
            while (object != null) {
                JsonValue jsonValue14 = ((JsonValue)object).child;
                if (jsonValue14 != null) {
                    Animation.CurveTimeline curveTimeline;
                    int n14 = ((JsonValue)object).size;
                    String string4 = ((JsonValue)object).name;
                    if (string4.equals("position")) {
                        curveTimeline = new Animation.PathConstraintPositionTimeline(n14, n14, n13);
                        array.add(this.readTimeline(jsonValue14, (Animation.CurveTimeline1)curveTimeline, 0.0f, ((PathConstraintData)object3).positionMode == PathConstraintData.PositionMode.fixed ? f6 : 1.0f));
                    } else if (string4.equals("spacing")) {
                        curveTimeline = new Animation.PathConstraintSpacingTimeline(n14, n14, n13);
                        array.add(this.readTimeline(jsonValue14, (Animation.CurveTimeline1)curveTimeline, 0.0f, ((PathConstraintData)object3).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object3).spacingMode == PathConstraintData.SpacingMode.fixed ? f6 : 1.0f));
                    } else if (string4.equals("mix")) {
                        curveTimeline = new Animation.PathConstraintMixTimeline(n14, n14 * 3, n13);
                        float f46 = jsonValue14.getFloat("time", 0.0f);
                        float f47 = jsonValue14.getFloat("mixRotate", 1.0f);
                        f5 = jsonValue14.getFloat("mixX", 1.0f);
                        float f48 = jsonValue14.getFloat("mixY", f5);
                        int n15 = 0;
                        int n16 = 0;
                        while (true) {
                            ((Animation.PathConstraintMixTimeline)curveTimeline).setFrame(n15, f46, f47, f5, f48);
                            JsonValue jsonValue15 = jsonValue14.next;
                            if (jsonValue15 == null) break;
                            float f49 = jsonValue15.getFloat("time", 0.0f);
                            float f50 = jsonValue15.getFloat("mixRotate", 1.0f);
                            float f51 = jsonValue15.getFloat("mixX", 1.0f);
                            float f52 = jsonValue15.getFloat("mixY", f51);
                            JsonValue jsonValue16 = jsonValue14.get("curve");
                            if (jsonValue16 != null) {
                                n16 = this.readCurve(jsonValue16, curveTimeline, n16, n15, 0, f46, f49, f47, f50, 1.0f);
                                n16 = this.readCurve(jsonValue16, curveTimeline, n16, n15, 1, f46, f49, f5, f51, 1.0f);
                                n16 = this.readCurve(jsonValue16, curveTimeline, n16, n15, 2, f46, f49, f48, f52, 1.0f);
                            }
                            f46 = f49;
                            f47 = f50;
                            f5 = f51;
                            f48 = f52;
                            jsonValue14 = jsonValue15;
                            ++n15;
                        }
                        curveTimeline.shrink(n16);
                        array.add(curveTimeline);
                    }
                }
                object = ((JsonValue)object).next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("deform");
        while (jsonValue4 != null) {
            object3 = skeletonData.findSkin(jsonValue4.name);
            if (object3 == null) {
                throw new SerializationException("Skin not found: " + jsonValue4.name);
            }
            JsonValue jsonValue17 = jsonValue4.child;
            while (jsonValue17 != null) {
                object = skeletonData.findSlot(jsonValue17.name);
                if (object == null) {
                    throw new SerializationException("Slot not found: " + jsonValue17.name);
                }
                JsonValue jsonValue18 = jsonValue17.child;
                while (jsonValue18 != null) {
                    JsonValue jsonValue19 = jsonValue18.child;
                    if (jsonValue19 != null) {
                        VertexAttachment vertexAttachment = (VertexAttachment)((Skin)object3).getAttachment(((SlotData)object).index, jsonValue18.name);
                        if (vertexAttachment == null) {
                            throw new SerializationException("Deform attachment not found: " + jsonValue18.name);
                        }
                        boolean bl = vertexAttachment.getBones() != null;
                        float[] fArray = vertexAttachment.getVertices();
                        int n17 = bl ? fArray.length / 3 << 1 : fArray.length;
                        Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(jsonValue18.size, jsonValue18.size, ((SlotData)object).index, vertexAttachment);
                        float f53 = jsonValue19.getFloat("time", 0.0f);
                        int n18 = 0;
                        int n19 = 0;
                        while (true) {
                            float[] fArray2;
                            if ((jsonValue3 = jsonValue19.get("vertices")) == null) {
                                fArray2 = bl ? new float[n17] : fArray;
                            } else {
                                fArray2 = new float[n17];
                                int n20 = jsonValue19.getInt("offset", 0);
                                SpineUtils.arraycopy(jsonValue3.asFloatArray(), 0, fArray2, n20, jsonValue3.size);
                                if (f6 != 1.0f) {
                                    int n21 = n20;
                                    int n22 = n21 + jsonValue3.size;
                                    while (n21 < n22) {
                                        int n23 = n21++;
                                        fArray2[n23] = fArray2[n23] * f6;
                                    }
                                }
                                if (!bl) {
                                    for (int i = 0; i < n17; ++i) {
                                        int n24 = i;
                                        fArray2[n24] = fArray2[n24] + fArray[i];
                                    }
                                }
                            }
                            deformTimeline.setFrame(n18, f53, fArray2);
                            JsonValue jsonValue20 = jsonValue19.next;
                            if (jsonValue20 == null) break;
                            float f54 = jsonValue20.getFloat("time", 0.0f);
                            JsonValue jsonValue21 = jsonValue19.get("curve");
                            if (jsonValue21 != null) {
                                n19 = this.readCurve(jsonValue21, deformTimeline, n19, n18, 0, f53, f54, 0.0f, 1.0f, 1.0f);
                            }
                            f53 = f54;
                            jsonValue19 = jsonValue20;
                            ++n18;
                        }
                        deformTimeline.shrink(n19);
                        array.add(deformTimeline);
                    }
                    jsonValue18 = jsonValue18.next;
                }
                jsonValue17 = jsonValue17.next;
            }
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.get("drawOrder");
        if (jsonValue4 != null) {
            object3 = new Animation.DrawOrderTimeline(jsonValue4.size);
            int n25 = skeletonData.slots.size;
            int n26 = 0;
            JsonValue jsonValue22 = jsonValue4.child;
            while (jsonValue22 != null) {
                int[] nArray = null;
                JsonValue jsonValue23 = jsonValue22.get("offsets");
                if (jsonValue23 != null) {
                    nArray = new int[n25];
                    for (int i = n25 - 1; i >= 0; --i) {
                        nArray[i] = -1;
                    }
                    int[] nArray2 = new int[n25 - jsonValue23.size];
                    int n27 = 0;
                    int n28 = 0;
                    JsonValue jsonValue24 = jsonValue23.child;
                    while (jsonValue24 != null) {
                        SlotData slotData = skeletonData.findSlot(jsonValue24.getString("slot"));
                        if (slotData == null) {
                            throw new SerializationException("Slot not found: " + jsonValue24.getString("slot"));
                        }
                        while (n27 != slotData.index) {
                            nArray2[n28++] = n27++;
                        }
                        nArray[n27 + jsonValue24.getInt((String)"offset")] = n27++;
                        jsonValue24 = jsonValue24.next;
                    }
                    while (n27 < n25) {
                        nArray2[n28++] = n27++;
                    }
                    for (int i = n25 - 1; i >= 0; --i) {
                        if (nArray[i] != -1) continue;
                        nArray[i] = nArray2[--n28];
                    }
                }
                ((Animation.DrawOrderTimeline)object3).setFrame(n26, jsonValue22.getFloat("time", 0.0f), nArray);
                jsonValue22 = jsonValue22.next;
                ++n26;
            }
            array.add((Animation.Timeline)object3);
        }
        if ((object3 = jsonValue.get("events")) != null) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(((JsonValue)object3).size);
            int n29 = 0;
            JsonValue jsonValue25 = ((JsonValue)object3).child;
            while (jsonValue25 != null) {
                EventData eventData = skeletonData.findEvent(jsonValue25.getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + jsonValue25.getString("name"));
                }
                Event event = new Event(jsonValue25.getFloat("time", 0.0f), eventData);
                event.intValue = jsonValue25.getInt("int", eventData.intValue);
                event.floatValue = jsonValue25.getFloat("float", eventData.floatValue);
                event.stringValue = jsonValue25.getString("string", eventData.stringValue);
                if (event.getData().audioPath != null) {
                    event.volume = jsonValue25.getFloat("volume", eventData.volume);
                    event.balance = jsonValue25.getFloat("balance", eventData.balance);
                }
                eventTimeline.setFrame(n29, event);
                jsonValue25 = jsonValue25.next;
                ++n29;
            }
            array.add(eventTimeline);
        }
        array.shrink();
        float f55 = 0.0f;
        T[] TArray = array.items;
        int n30 = array.size;
        for (int i = 0; i < n30; ++i) {
            f55 = Math.max(f55, ((Animation.Timeline)TArray[i]).getDuration());
        }
        skeletonData.animations.add(new Animation(string, array, f55));
    }

    private Animation.Timeline readTimeline(JsonValue jsonValue, Animation.CurveTimeline1 curveTimeline1, float f, float f2) {
        float f3 = jsonValue.getFloat("time", 0.0f);
        float f4 = jsonValue.getFloat("value", f) * f2;
        int n = 0;
        int n2 = 0;
        while (true) {
            curveTimeline1.setFrame(n, f3, f4);
            JsonValue jsonValue2 = jsonValue.next;
            if (jsonValue2 == null) {
                curveTimeline1.shrink(n2);
                return curveTimeline1;
            }
            float f5 = jsonValue2.getFloat("time", 0.0f);
            float f6 = jsonValue2.getFloat("value", f) * f2;
            JsonValue jsonValue3 = jsonValue.get("curve");
            if (jsonValue3 != null) {
                n2 = this.readCurve(jsonValue3, curveTimeline1, n2, n, 0, f3, f5, f4, f6, f2);
            }
            f3 = f5;
            f4 = f6;
            jsonValue = jsonValue2;
            ++n;
        }
    }

    private Animation.Timeline readTimeline(JsonValue jsonValue, Animation.CurveTimeline2 curveTimeline2, String string, String string2, float f, float f2) {
        float f3 = jsonValue.getFloat("time", 0.0f);
        float f4 = jsonValue.getFloat(string, f) * f2;
        float f5 = jsonValue.getFloat(string2, f) * f2;
        int n = 0;
        int n2 = 0;
        while (true) {
            curveTimeline2.setFrame(n, f3, f4, f5);
            JsonValue jsonValue2 = jsonValue.next;
            if (jsonValue2 == null) {
                curveTimeline2.shrink(n2);
                return curveTimeline2;
            }
            float f6 = jsonValue2.getFloat("time", 0.0f);
            float f7 = jsonValue2.getFloat(string, f) * f2;
            float f8 = jsonValue2.getFloat(string2, f) * f2;
            JsonValue jsonValue3 = jsonValue.get("curve");
            if (jsonValue3 != null) {
                n2 = this.readCurve(jsonValue3, curveTimeline2, n2, n, 0, f3, f6, f4, f7, f2);
                n2 = this.readCurve(jsonValue3, curveTimeline2, n2, n, 1, f3, f6, f5, f8, f2);
            }
            f3 = f6;
            f4 = f7;
            f5 = f8;
            jsonValue = jsonValue2;
            ++n;
        }
    }

    int readCurve(JsonValue jsonValue, Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5) {
        if (jsonValue.isString()) {
            if (jsonValue.asString().equals("stepped")) {
                curveTimeline.setStepped(n2);
            }
            return n;
        }
        jsonValue = jsonValue.get(n3 << 2);
        float f6 = jsonValue.asFloat();
        jsonValue = jsonValue.next;
        float f7 = jsonValue.asFloat() * f5;
        jsonValue = jsonValue.next;
        float f8 = jsonValue.asFloat();
        jsonValue = jsonValue.next;
        float f9 = jsonValue.asFloat() * f5;
        SkeletonJson.setBezier(curveTimeline, n2, n3, n, f, f3, f6, f7, f8, f9, f2, f4);
        return n + 1;
    }

    static void setBezier(Animation.CurveTimeline curveTimeline, int n, int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        curveTimeline.setBezier(n3, n, n2, f, f2, f3, f4, f5, f6, f7, f8);
    }

    static class LinkedMesh {
        String parent;
        String skin;
        int slotIndex;
        MeshAttachment mesh;
        boolean inheritDeform;

        public LinkedMesh(MeshAttachment meshAttachment, String string, int n, String string2, boolean bl) {
            this.mesh = meshAttachment;
            this.skin = string;
            this.slotIndex = n;
            this.parent = string2;
            this.inheritDeform = bl;
        }
    }
}

