/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;

public class SkeletonBinary {
    private static final Color tempColor1 = new Color();
    private static final Color tempColor2 = new Color();
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;
    private Array<SkeletonJson.LinkedMesh> linkedMeshes = new Array();

    public SkeletonBinary(TextureAtlas textureAtlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(textureAtlas);
    }

    public void setScale(float f) {
        if (f == 0.0f) {
            throw new IllegalArgumentException("scale cannot be 0.");
        }
        this.scale = f;
    }

    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float f = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = fileHandle.nameWithoutExtension();
        SkeletonInput skeletonInput = new SkeletonInput(fileHandle);
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            String string;
            int n3;
            skeletonData.hash = skeletonInput.readString();
            if (skeletonData.hash.isEmpty()) {
                skeletonData.hash = null;
            }
            skeletonData.version = skeletonInput.readString();
            if (skeletonData.version.isEmpty()) {
                skeletonData.version = null;
            }
            if ("3.8.75".equals(skeletonData.version)) {
                throw new RuntimeException("Unsupported skeleton data, please export with a newer version of Spine.");
            }
            skeletonData.x = skeletonInput.readFloat();
            skeletonData.y = skeletonInput.readFloat();
            skeletonData.width = skeletonInput.readFloat();
            skeletonData.height = skeletonInput.readFloat();
            boolean bl = skeletonInput.readBoolean();
            if (bl) {
                skeletonData.fps = skeletonInput.readFloat();
                skeletonData.imagesPath = skeletonInput.readString();
                if (skeletonData.imagesPath.isEmpty()) {
                    skeletonData.imagesPath = null;
                }
                skeletonData.audioPath = skeletonInput.readString();
                if (skeletonData.audioPath.isEmpty()) {
                    skeletonData.audioPath = null;
                }
            }
            int n4 = skeletonInput.readInt(true);
            skeletonInput.strings = new Array(n4);
            Object[] objectArray = skeletonInput.strings.setSize(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                objectArray[n3] = skeletonInput.readString();
            }
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.bones.setSize(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                string = skeletonInput.readString();
                object2 = n3 == 0 ? null : skeletonData.bones.get(skeletonInput.readInt(true));
                object = new BoneData(n3, string, (BoneData)object2);
                ((BoneData)object).rotation = skeletonInput.readFloat();
                ((BoneData)object).x = skeletonInput.readFloat() * f;
                ((BoneData)object).y = skeletonInput.readFloat() * f;
                ((BoneData)object).scaleX = skeletonInput.readFloat();
                ((BoneData)object).scaleY = skeletonInput.readFloat();
                ((BoneData)object).shearX = skeletonInput.readFloat();
                ((BoneData)object).shearY = skeletonInput.readFloat();
                ((BoneData)object).length = skeletonInput.readFloat() * f;
                ((BoneData)object).transformMode = BoneData.TransformMode.values[skeletonInput.readInt(true)];
                ((BoneData)object).skinRequired = skeletonInput.readBoolean();
                if (bl) {
                    Color.rgba8888ToColor(((BoneData)object).color, skeletonInput.readInt());
                }
                objectArray[n3] = object;
            }
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.slots.setSize(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                string = skeletonInput.readString();
                object2 = skeletonData.bones.get(skeletonInput.readInt(true));
                object = new SlotData(n3, string, (BoneData)object2);
                Color.rgba8888ToColor(((SlotData)object).color, skeletonInput.readInt());
                n2 = skeletonInput.readInt();
                if (n2 != -1) {
                    ((SlotData)object).darkColor = new Color();
                    Color.rgb888ToColor(((SlotData)object).darkColor, n2);
                }
                ((SlotData)object).attachmentName = skeletonInput.readStringRef();
                ((SlotData)object).blendMode = BlendMode.values[skeletonInput.readInt(true)];
                objectArray[n3] = object;
            }
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.ikConstraints.setSize(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = new IkConstraintData(skeletonInput.readString());
                ((IkConstraintData)object2).order = skeletonInput.readInt(true);
                ((IkConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n5 = skeletonInput.readInt(true);
                object = ((IkConstraintData)object2).bones.setSize(n5);
                for (n2 = 0; n2 < n5; ++n2) {
                    object[n2] = skeletonData.bones.get(skeletonInput.readInt(true));
                }
                ((IkConstraintData)object2).target = skeletonData.bones.get(skeletonInput.readInt(true));
                ((IkConstraintData)object2).mix = skeletonInput.readFloat();
                ((IkConstraintData)object2).softness = skeletonInput.readFloat() * f;
                ((IkConstraintData)object2).bendDirection = skeletonInput.readByte();
                ((IkConstraintData)object2).compress = skeletonInput.readBoolean();
                ((IkConstraintData)object2).stretch = skeletonInput.readBoolean();
                ((IkConstraintData)object2).uniform = skeletonInput.readBoolean();
                objectArray[n3] = object2;
            }
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.transformConstraints.setSize(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = new TransformConstraintData(skeletonInput.readString());
                ((TransformConstraintData)object2).order = skeletonInput.readInt(true);
                ((TransformConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n6 = skeletonInput.readInt(true);
                object = ((TransformConstraintData)object2).bones.setSize(n6);
                for (n2 = 0; n2 < n6; ++n2) {
                    object[n2] = skeletonData.bones.get(skeletonInput.readInt(true));
                }
                ((TransformConstraintData)object2).target = skeletonData.bones.get(skeletonInput.readInt(true));
                ((TransformConstraintData)object2).local = skeletonInput.readBoolean();
                ((TransformConstraintData)object2).relative = skeletonInput.readBoolean();
                ((TransformConstraintData)object2).offsetRotation = skeletonInput.readFloat();
                ((TransformConstraintData)object2).offsetX = skeletonInput.readFloat() * f;
                ((TransformConstraintData)object2).offsetY = skeletonInput.readFloat() * f;
                ((TransformConstraintData)object2).offsetScaleX = skeletonInput.readFloat();
                ((TransformConstraintData)object2).offsetScaleY = skeletonInput.readFloat();
                ((TransformConstraintData)object2).offsetShearY = skeletonInput.readFloat();
                ((TransformConstraintData)object2).rotateMix = skeletonInput.readFloat();
                ((TransformConstraintData)object2).translateMix = skeletonInput.readFloat();
                ((TransformConstraintData)object2).scaleMix = skeletonInput.readFloat();
                ((TransformConstraintData)object2).shearMix = skeletonInput.readFloat();
                objectArray[n3] = object2;
            }
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.pathConstraints.setSize(n4);
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = new PathConstraintData(skeletonInput.readString());
                ((PathConstraintData)object2).order = skeletonInput.readInt(true);
                ((PathConstraintData)object2).skinRequired = skeletonInput.readBoolean();
                int n7 = skeletonInput.readInt(true);
                object = ((PathConstraintData)object2).bones.setSize(n7);
                for (n2 = 0; n2 < n7; ++n2) {
                    object[n2] = skeletonData.bones.get(skeletonInput.readInt(true));
                }
                ((PathConstraintData)object2).target = skeletonData.slots.get(skeletonInput.readInt(true));
                ((PathConstraintData)object2).positionMode = PathConstraintData.PositionMode.values[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).spacingMode = PathConstraintData.SpacingMode.values[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).rotateMode = PathConstraintData.RotateMode.values[skeletonInput.readInt(true)];
                ((PathConstraintData)object2).offsetRotation = skeletonInput.readFloat();
                ((PathConstraintData)object2).position = skeletonInput.readFloat();
                if (((PathConstraintData)object2).positionMode == PathConstraintData.PositionMode.fixed) {
                    ((PathConstraintData)object2).position *= f;
                }
                ((PathConstraintData)object2).spacing = skeletonInput.readFloat();
                if (((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                    ((PathConstraintData)object2).spacing *= f;
                }
                ((PathConstraintData)object2).rotateMix = skeletonInput.readFloat();
                ((PathConstraintData)object2).translateMix = skeletonInput.readFloat();
                objectArray[n3] = object2;
            }
            Skin skin = this.readSkin(skeletonInput, skeletonData, true, bl);
            if (skin != null) {
                skeletonData.defaultSkin = skin;
                skeletonData.skins.add(skin);
            }
            n4 = n + skeletonInput.readInt(true);
            objectArray = skeletonData.skins.setSize(n4);
            for (n = skeletonData.skins.size; n < n4; ++n) {
                objectArray[n] = this.readSkin(skeletonInput, skeletonData, false, bl);
            }
            n4 = this.linkedMeshes.size;
            for (n = 0; n < n4; ++n) {
                object2 = this.linkedMeshes.get(n);
                Object object3 = object = ((SkeletonJson.LinkedMesh)object2).skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(((SkeletonJson.LinkedMesh)object2).skin);
                if (object == null) {
                    throw new SerializationException("Skin not found: " + ((SkeletonJson.LinkedMesh)object2).skin);
                }
                Attachment attachment = ((Skin)object).getAttachment(((SkeletonJson.LinkedMesh)object2).slotIndex, ((SkeletonJson.LinkedMesh)object2).parent);
                if (attachment == null) {
                    throw new SerializationException("Parent mesh not found: " + ((SkeletonJson.LinkedMesh)object2).parent);
                }
                ((SkeletonJson.LinkedMesh)object2).mesh.setDeformAttachment(((SkeletonJson.LinkedMesh)object2).inheritDeform ? (VertexAttachment)attachment : ((SkeletonJson.LinkedMesh)object2).mesh);
                ((SkeletonJson.LinkedMesh)object2).mesh.setParentMesh((MeshAttachment)attachment);
                ((SkeletonJson.LinkedMesh)object2).mesh.updateUVs();
            }
            this.linkedMeshes.clear();
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.events.setSize(n4);
            for (n = 0; n < n4; ++n) {
                object2 = new EventData(skeletonInput.readStringRef());
                ((EventData)object2).intValue = skeletonInput.readInt(false);
                ((EventData)object2).floatValue = skeletonInput.readFloat();
                ((EventData)object2).stringValue = skeletonInput.readString();
                ((EventData)object2).audioPath = skeletonInput.readString();
                if (((EventData)object2).audioPath != null) {
                    ((EventData)object2).volume = skeletonInput.readFloat();
                    ((EventData)object2).balance = skeletonInput.readFloat();
                }
                objectArray[n] = object2;
            }
            n4 = skeletonInput.readInt(true);
            objectArray = skeletonData.animations.setSize(n4);
            for (n = 0; n < n4; ++n) {
                objectArray[n] = this.readAnimation(skeletonInput, skeletonInput.readString(), skeletonData);
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading skeleton file.", iOException);
        }
        finally {
            try {
                skeletonInput.close();
            }
            catch (IOException iOException) {}
        }
        return skeletonData;
    }

    private Skin readSkin(SkeletonInput skeletonInput, SkeletonData skeletonData, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        Skin skin;
        int n3;
        if (bl) {
            n3 = skeletonInput.readInt(true);
            if (n3 == 0) {
                return null;
            }
            skin = new Skin("default");
        } else {
            skin = new Skin(skeletonInput.readStringRef());
            BoneData[] boneDataArray = skin.bones.setSize(skeletonInput.readInt(true));
            n2 = skin.bones.size;
            for (n = 0; n < n2; ++n) {
                boneDataArray[n] = skeletonData.bones.get(skeletonInput.readInt(true));
            }
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add(skeletonData.ikConstraints.get(skeletonInput.readInt(true)));
            }
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add(skeletonData.transformConstraints.get(skeletonInput.readInt(true)));
            }
            n2 = skeletonInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                skin.constraints.add(skeletonData.pathConstraints.get(skeletonInput.readInt(true)));
            }
            skin.constraints.shrink();
            n3 = skeletonInput.readInt(true);
        }
        for (int i = 0; i < n3; ++i) {
            n = skeletonInput.readInt(true);
            int n4 = skeletonInput.readInt(true);
            for (n2 = 0; n2 < n4; ++n2) {
                String string = skeletonInput.readStringRef();
                Attachment attachment = this.readAttachment(skeletonInput, skeletonData, skin, n, string, bl2);
                if (attachment == null) continue;
                skin.setAttachment(n, string, attachment);
            }
        }
        return skin;
    }

    private Attachment readAttachment(SkeletonInput skeletonInput, SkeletonData skeletonData, Skin skin, int n, String string, boolean bl) throws IOException {
        float f = this.scale;
        String string2 = skeletonInput.readStringRef();
        if (string2 == null) {
            string2 = string;
        }
        AttachmentType attachmentType = AttachmentType.values[skeletonInput.readByte()];
        switch (attachmentType) {
            case region: {
                RegionAttachment regionAttachment;
                String string3 = skeletonInput.readStringRef();
                float f2 = skeletonInput.readFloat();
                float f3 = skeletonInput.readFloat();
                float f4 = skeletonInput.readFloat();
                float f5 = skeletonInput.readFloat();
                float f6 = skeletonInput.readFloat();
                float f7 = skeletonInput.readFloat();
                float f8 = skeletonInput.readFloat();
                int n2 = skeletonInput.readInt();
                if (string3 == null) {
                    string3 = string2;
                }
                if ((regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string2, string3)) == null) {
                    return null;
                }
                regionAttachment.setPath(string3);
                regionAttachment.setX(f3 * f);
                regionAttachment.setY(f4 * f);
                regionAttachment.setScaleX(f5);
                regionAttachment.setScaleY(f6);
                regionAttachment.setRotation(f2);
                regionAttachment.setWidth(f7 * f);
                regionAttachment.setHeight(f8 * f);
                Color.rgba8888ToColor(regionAttachment.getColor(), n2);
                regionAttachment.updateOffset();
                return regionAttachment;
            }
            case boundingbox: {
                int n3 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, n3);
                int n4 = bl ? skeletonInput.readInt() : 0;
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string2);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                boundingBoxAttachment.setWorldVerticesLength(n3 << 1);
                boundingBoxAttachment.setVertices(vertices.vertices);
                boundingBoxAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(boundingBoxAttachment.getColor(), n4);
                }
                return boundingBoxAttachment;
            }
            case mesh: {
                MeshAttachment meshAttachment;
                String string4 = skeletonInput.readStringRef();
                int n5 = skeletonInput.readInt();
                int n6 = skeletonInput.readInt(true);
                float[] fArray = this.readFloatArray(skeletonInput, n6 << 1, 1.0f);
                short[] sArray = this.readShortArray(skeletonInput);
                Vertices vertices = this.readVertices(skeletonInput, n6);
                int n7 = skeletonInput.readInt(true);
                short[] sArray2 = null;
                float f9 = 0.0f;
                float f10 = 0.0f;
                if (bl) {
                    sArray2 = this.readShortArray(skeletonInput);
                    f9 = skeletonInput.readFloat();
                    f10 = skeletonInput.readFloat();
                }
                if (string4 == null) {
                    string4 = string2;
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string4)) == null) {
                    return null;
                }
                meshAttachment.setPath(string4);
                Color.rgba8888ToColor(meshAttachment.getColor(), n5);
                meshAttachment.setBones(vertices.bones);
                meshAttachment.setVertices(vertices.vertices);
                meshAttachment.setWorldVerticesLength(n6 << 1);
                meshAttachment.setTriangles(sArray);
                meshAttachment.setRegionUVs(fArray);
                meshAttachment.updateUVs();
                meshAttachment.setHullLength(n7 << 1);
                if (bl) {
                    meshAttachment.setEdges(sArray2);
                    meshAttachment.setWidth(f9 * f);
                    meshAttachment.setHeight(f10 * f);
                }
                return meshAttachment;
            }
            case linkedmesh: {
                MeshAttachment meshAttachment;
                String string5 = skeletonInput.readStringRef();
                int n8 = skeletonInput.readInt();
                String string6 = skeletonInput.readStringRef();
                String string7 = skeletonInput.readStringRef();
                boolean bl2 = skeletonInput.readBoolean();
                float f11 = 0.0f;
                float f12 = 0.0f;
                if (bl) {
                    f11 = skeletonInput.readFloat();
                    f12 = skeletonInput.readFloat();
                }
                if (string5 == null) {
                    string5 = string2;
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string5)) == null) {
                    return null;
                }
                meshAttachment.setPath(string5);
                Color.rgba8888ToColor(meshAttachment.getColor(), n8);
                if (bl) {
                    meshAttachment.setWidth(f11 * f);
                    meshAttachment.setHeight(f12 * f);
                }
                this.linkedMeshes.add(new SkeletonJson.LinkedMesh(meshAttachment, string6, n, string7, bl2));
                return meshAttachment;
            }
            case path: {
                int n9;
                boolean bl3 = skeletonInput.readBoolean();
                boolean bl4 = skeletonInput.readBoolean();
                int n10 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, n10);
                float[] fArray = new float[n10 / 3];
                int n11 = fArray.length;
                for (n9 = 0; n9 < n11; ++n9) {
                    fArray[n9] = skeletonInput.readFloat() * f;
                }
                n9 = bl ? skeletonInput.readInt() : 0;
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string2);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(bl3);
                pathAttachment.setConstantSpeed(bl4);
                pathAttachment.setWorldVerticesLength(n10 << 1);
                pathAttachment.setVertices(vertices.vertices);
                pathAttachment.setBones(vertices.bones);
                pathAttachment.setLengths(fArray);
                if (bl) {
                    Color.rgba8888ToColor(pathAttachment.getColor(), n9);
                }
                return pathAttachment;
            }
            case point: {
                float f13 = skeletonInput.readFloat();
                float f14 = skeletonInput.readFloat();
                float f15 = skeletonInput.readFloat();
                int n12 = bl ? skeletonInput.readInt() : 0;
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string2);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(f14 * f);
                pointAttachment.setY(f15 * f);
                pointAttachment.setRotation(f13);
                if (bl) {
                    Color.rgba8888ToColor(pointAttachment.getColor(), n12);
                }
                return pointAttachment;
            }
            case clipping: {
                int n13 = skeletonInput.readInt(true);
                int n14 = skeletonInput.readInt(true);
                Vertices vertices = this.readVertices(skeletonInput, n14);
                int n15 = bl ? skeletonInput.readInt() : 0;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string2);
                if (clippingAttachment == null) {
                    return null;
                }
                clippingAttachment.setEndSlot(skeletonData.slots.get(n13));
                clippingAttachment.setWorldVerticesLength(n14 << 1);
                clippingAttachment.setVertices(vertices.vertices);
                clippingAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(clippingAttachment.getColor(), n15);
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private Vertices readVertices(SkeletonInput skeletonInput, int n) throws IOException {
        int n2 = n << 1;
        Vertices vertices = new Vertices();
        if (!skeletonInput.readBoolean()) {
            vertices.vertices = this.readFloatArray(skeletonInput, n2, this.scale);
            return vertices;
        }
        FloatArray floatArray = new FloatArray(n2 * 3 * 3);
        IntArray intArray = new IntArray(n2 * 3);
        for (int i = 0; i < n; ++i) {
            int n3 = skeletonInput.readInt(true);
            intArray.add(n3);
            for (int j = 0; j < n3; ++j) {
                intArray.add(skeletonInput.readInt(true));
                floatArray.add(skeletonInput.readFloat() * this.scale);
                floatArray.add(skeletonInput.readFloat() * this.scale);
                floatArray.add(skeletonInput.readFloat());
            }
        }
        vertices.vertices = floatArray.toArray();
        vertices.bones = intArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(SkeletonInput skeletonInput, int n, float f) throws IOException {
        float[] fArray = new float[n];
        if (f == 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = skeletonInput.readFloat() * f;
            }
        }
        return fArray;
    }

    private short[] readShortArray(SkeletonInput skeletonInput) throws IOException {
        int n = skeletonInput.readInt(true);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = skeletonInput.readShort();
        }
        return sArray;
    }

    private Animation readAnimation(SkeletonInput skeletonInput, String string, SkeletonData skeletonData) {
        Array<Animation.Timeline> array = new Array<Animation.Timeline>(32);
        float f = this.scale;
        float f2 = 0.0f;
        try {
            int n;
            int n2;
            Animation.Timeline timeline;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = skeletonInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = skeletonInput.readInt(true);
                n6 = skeletonInput.readInt(true);
                block16: for (n5 = 0; n5 < n6; ++n5) {
                    n4 = skeletonInput.readByte();
                    n3 = skeletonInput.readInt(true);
                    switch (n4) {
                        case 0: {
                            int n10;
                            timeline = new Animation.AttachmentTimeline(n3);
                            ((Animation.AttachmentTimeline)timeline).slotIndex = n7;
                            for (n10 = 0; n10 < n3; ++n10) {
                                ((Animation.AttachmentTimeline)timeline).setFrame(n10, skeletonInput.readFloat(), skeletonInput.readStringRef());
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.AttachmentTimeline)timeline).getFrames()[n3 - 1]);
                            continue block16;
                        }
                        case 1: {
                            float f3;
                            int n10;
                            timeline = new Animation.ColorTimeline(n3);
                            ((Animation.ColorTimeline)timeline).slotIndex = n7;
                            for (n10 = 0; n10 < n3; ++n10) {
                                f3 = skeletonInput.readFloat();
                                Color.rgba8888ToColor(tempColor1, skeletonInput.readInt());
                                ((Animation.ColorTimeline)timeline).setFrame(n10, f3, SkeletonBinary.tempColor1.r, SkeletonBinary.tempColor1.g, SkeletonBinary.tempColor1.b, SkeletonBinary.tempColor1.a);
                                if (n10 >= n3 - 1) continue;
                                this.readCurve(skeletonInput, n10, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.ColorTimeline)timeline).getFrames()[(n3 - 1) * 5]);
                            continue block16;
                        }
                        case 2: {
                            float f3;
                            int n10;
                            timeline = new Animation.TwoColorTimeline(n3);
                            ((Animation.TwoColorTimeline)timeline).slotIndex = n7;
                            for (n10 = 0; n10 < n3; ++n10) {
                                f3 = skeletonInput.readFloat();
                                Color.rgba8888ToColor(tempColor1, skeletonInput.readInt());
                                Color.rgb888ToColor(tempColor2, skeletonInput.readInt());
                                ((Animation.TwoColorTimeline)timeline).setFrame(n10, f3, SkeletonBinary.tempColor1.r, SkeletonBinary.tempColor1.g, SkeletonBinary.tempColor1.b, SkeletonBinary.tempColor1.a, SkeletonBinary.tempColor2.r, SkeletonBinary.tempColor2.g, SkeletonBinary.tempColor2.b);
                                if (n10 >= n3 - 1) continue;
                                this.readCurve(skeletonInput, n10, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.TwoColorTimeline)timeline).getFrames()[(n3 - 1) * 8]);
                            continue block16;
                        }
                    }
                }
            }
            n9 = skeletonInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = skeletonInput.readInt(true);
                n6 = skeletonInput.readInt(true);
                block21: for (n5 = 0; n5 < n6; ++n5) {
                    n4 = skeletonInput.readByte();
                    n3 = skeletonInput.readInt(true);
                    switch (n4) {
                        case 0: {
                            timeline = new Animation.RotateTimeline(n3);
                            ((Animation.RotateTimeline)timeline).boneIndex = n7;
                            for (int i = 0; i < n3; ++i) {
                                ((Animation.RotateTimeline)timeline).setFrame(i, skeletonInput.readFloat(), skeletonInput.readFloat());
                                if (i >= n3 - 1) continue;
                                this.readCurve(skeletonInput, i, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.RotateTimeline)timeline).getFrames()[(n3 - 1) * 2]);
                            continue block21;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            float f4 = 1.0f;
                            if (n4 == 2) {
                                timeline = new Animation.ScaleTimeline(n3);
                            } else if (n4 == 3) {
                                timeline = new Animation.ShearTimeline(n3);
                            } else {
                                timeline = new Animation.TranslateTimeline(n3);
                                f4 = f;
                            }
                            ((Animation.TranslateTimeline)timeline).boneIndex = n7;
                            for (int i = 0; i < n3; ++i) {
                                ((Animation.TranslateTimeline)timeline).setFrame(i, skeletonInput.readFloat(), skeletonInput.readFloat() * f4, skeletonInput.readFloat() * f4);
                                if (i >= n3 - 1) continue;
                                this.readCurve(skeletonInput, i, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.TranslateTimeline)timeline).getFrames()[(n3 - 1) * 3]);
                            continue block21;
                        }
                    }
                }
            }
            n9 = skeletonInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = skeletonInput.readInt(true);
                n5 = skeletonInput.readInt(true);
                Animation.IkConstraintTimeline ikConstraintTimeline = new Animation.IkConstraintTimeline(n5);
                ikConstraintTimeline.ikConstraintIndex = n7;
                for (n4 = 0; n4 < n5; ++n4) {
                    ikConstraintTimeline.setFrame(n4, skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat() * f, skeletonInput.readByte(), skeletonInput.readBoolean(), skeletonInput.readBoolean());
                    if (n4 >= n5 - 1) continue;
                    this.readCurve(skeletonInput, n4, ikConstraintTimeline);
                }
                array.add(ikConstraintTimeline);
                f2 = Math.max(f2, ikConstraintTimeline.getFrames()[(n5 - 1) * 6]);
            }
            n9 = skeletonInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = skeletonInput.readInt(true);
                n5 = skeletonInput.readInt(true);
                Animation.TransformConstraintTimeline transformConstraintTimeline = new Animation.TransformConstraintTimeline(n5);
                transformConstraintTimeline.transformConstraintIndex = n7;
                for (n4 = 0; n4 < n5; ++n4) {
                    transformConstraintTimeline.setFrame(n4, skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat());
                    if (n4 >= n5 - 1) continue;
                    this.readCurve(skeletonInput, n4, transformConstraintTimeline);
                }
                array.add(transformConstraintTimeline);
                f2 = Math.max(f2, transformConstraintTimeline.getFrames()[(n5 - 1) * 5]);
            }
            n9 = skeletonInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = skeletonInput.readInt(true);
                PathConstraintData pathConstraintData = skeletonData.pathConstraints.get(n7);
                n4 = skeletonInput.readInt(true);
                block29: for (int i = 0; i < n4; ++i) {
                    n3 = skeletonInput.readByte();
                    int n11 = skeletonInput.readInt(true);
                    switch (n3) {
                        case 0: 
                        case 1: {
                            Animation.CurveTimeline curveTimeline;
                            float f5 = 1.0f;
                            if (n3 == 1) {
                                curveTimeline = new Animation.PathConstraintSpacingTimeline(n11);
                                if (pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length || pathConstraintData.spacingMode == PathConstraintData.SpacingMode.fixed) {
                                    f5 = f;
                                }
                            } else {
                                curveTimeline = new Animation.PathConstraintPositionTimeline(n11);
                                if (pathConstraintData.positionMode == PathConstraintData.PositionMode.fixed) {
                                    f5 = f;
                                }
                            }
                            ((Animation.PathConstraintPositionTimeline)curveTimeline).pathConstraintIndex = n7;
                            for (int j = 0; j < n11; ++j) {
                                ((Animation.PathConstraintPositionTimeline)curveTimeline).setFrame(j, skeletonInput.readFloat(), skeletonInput.readFloat() * f5);
                                if (j >= n11 - 1) continue;
                                this.readCurve(skeletonInput, j, curveTimeline);
                            }
                            array.add(curveTimeline);
                            f2 = Math.max(f2, ((Animation.PathConstraintPositionTimeline)curveTimeline).getFrames()[(n11 - 1) * 2]);
                            continue block29;
                        }
                        case 2: {
                            Animation.CurveTimeline curveTimeline = new Animation.PathConstraintMixTimeline(n11);
                            ((Animation.PathConstraintMixTimeline)curveTimeline).pathConstraintIndex = n7;
                            for (int j = 0; j < n11; ++j) {
                                ((Animation.PathConstraintMixTimeline)curveTimeline).setFrame(j, skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat());
                                if (j >= n11 - 1) continue;
                                this.readCurve(skeletonInput, j, curveTimeline);
                            }
                            array.add(curveTimeline);
                            f2 = Math.max(f2, ((Animation.PathConstraintMixTimeline)curveTimeline).getFrames()[(n11 - 1) * 3]);
                            continue block29;
                        }
                    }
                }
            }
            n9 = skeletonInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                Skin skin = skeletonData.skins.get(skeletonInput.readInt(true));
                int n12 = skeletonInput.readInt(true);
                for (int i = 0; i < n12; ++i) {
                    n4 = skeletonInput.readInt(true);
                    int n13 = skeletonInput.readInt(true);
                    for (n3 = 0; n3 < n13; ++n3) {
                        VertexAttachment vertexAttachment = (VertexAttachment)skin.getAttachment(n4, skeletonInput.readStringRef());
                        boolean bl = vertexAttachment.getBones() != null;
                        float[] fArray = vertexAttachment.getVertices();
                        n2 = bl ? fArray.length / 3 * 2 : fArray.length;
                        int n14 = skeletonInput.readInt(true);
                        Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n14);
                        deformTimeline.slotIndex = n4;
                        deformTimeline.attachment = vertexAttachment;
                        for (int j = 0; j < n14; ++j) {
                            float[] fArray2;
                            float f6 = skeletonInput.readFloat();
                            int n15 = skeletonInput.readInt(true);
                            if (n15 == 0) {
                                fArray2 = bl ? new float[n2] : fArray;
                            } else {
                                int n16;
                                fArray2 = new float[n2];
                                int n17 = skeletonInput.readInt(true);
                                n15 += n17;
                                if (f == 1.0f) {
                                    for (n16 = n17; n16 < n15; ++n16) {
                                        fArray2[n16] = skeletonInput.readFloat();
                                    }
                                } else {
                                    for (n16 = n17; n16 < n15; ++n16) {
                                        fArray2[n16] = skeletonInput.readFloat() * f;
                                    }
                                }
                                if (!bl) {
                                    int n18 = fArray2.length;
                                    for (n16 = 0; n16 < n18; ++n16) {
                                        int n19 = n16;
                                        fArray2[n19] = fArray2[n19] + fArray[n16];
                                    }
                                }
                            }
                            deformTimeline.setFrame(j, f6, fArray2);
                            if (j >= n14 - 1) continue;
                            this.readCurve(skeletonInput, j, deformTimeline);
                        }
                        array.add(deformTimeline);
                        f2 = Math.max(f2, deformTimeline.getFrames()[n14 - 1]);
                    }
                }
            }
            n8 = skeletonInput.readInt(true);
            if (n8 > 0) {
                Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(n8);
                int n20 = skeletonData.slots.size;
                for (int i = 0; i < n8; ++i) {
                    int n21;
                    float f7 = skeletonInput.readFloat();
                    n4 = skeletonInput.readInt(true);
                    int[] nArray = new int[n20];
                    for (int j = n20 - 1; j >= 0; --j) {
                        nArray[j] = -1;
                    }
                    int[] nArray2 = new int[n20 - n4];
                    int n22 = 0;
                    int n23 = 0;
                    for (n21 = 0; n21 < n4; ++n21) {
                        n2 = skeletonInput.readInt(true);
                        while (n22 != n2) {
                            nArray2[n23++] = n22++;
                        }
                        nArray[n22 + skeletonInput.readInt((boolean)true)] = n22++;
                    }
                    while (n22 < n20) {
                        nArray2[n23++] = n22++;
                    }
                    for (n21 = n20 - 1; n21 >= 0; --n21) {
                        if (nArray[n21] != -1) continue;
                        nArray[n21] = nArray2[--n23];
                    }
                    drawOrderTimeline.setFrame(i, f7, nArray);
                }
                array.add(drawOrderTimeline);
                f2 = Math.max(f2, drawOrderTimeline.getFrames()[n8 - 1]);
            }
            if ((n = skeletonInput.readInt(true)) > 0) {
                Animation.EventTimeline eventTimeline = new Animation.EventTimeline(n);
                for (int i = 0; i < n; ++i) {
                    float f8 = skeletonInput.readFloat();
                    EventData eventData = skeletonData.events.get(skeletonInput.readInt(true));
                    Event event = new Event(f8, eventData);
                    event.intValue = skeletonInput.readInt(false);
                    event.floatValue = skeletonInput.readFloat();
                    String string2 = event.stringValue = skeletonInput.readBoolean() ? skeletonInput.readString() : eventData.stringValue;
                    if (event.getData().audioPath != null) {
                        event.volume = skeletonInput.readFloat();
                        event.balance = skeletonInput.readFloat();
                    }
                    eventTimeline.setFrame(i, event);
                }
                array.add(eventTimeline);
                f2 = Math.max(f2, eventTimeline.getFrames()[n - 1]);
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading skeleton file.", iOException);
        }
        array.shrink();
        return new Animation(string, array, f2);
    }

    private void readCurve(SkeletonInput skeletonInput, int n, Animation.CurveTimeline curveTimeline) throws IOException {
        switch (skeletonInput.readByte()) {
            case 1: {
                curveTimeline.setStepped(n);
                break;
            }
            case 2: {
                this.setCurve(curveTimeline, n, skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat(), skeletonInput.readFloat());
            }
        }
    }

    void setCurve(Animation.CurveTimeline curveTimeline, int n, float f, float f2, float f3, float f4) {
        curveTimeline.setCurve(n, f, f2, f3, f4);
    }

    static class SkeletonInput
    extends DataInput {
        private char[] chars = new char[32];
        Array<String> strings;

        public SkeletonInput(FileHandle fileHandle) {
            super(fileHandle.read(512));
        }

        public String readStringRef() throws IOException {
            int n = this.readInt(true);
            return n == 0 ? null : this.strings.get(n - 1);
        }

        @Override
        public String readString() throws IOException {
            int n = this.readInt(true);
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "";
                }
            }
            if (this.chars.length < --n) {
                this.chars = new char[n];
            }
            char[] cArray = this.chars;
            int n2 = 0;
            int n3 = 0;
            block9: while (n3 < n) {
                int n4 = this.read();
                switch (n4 >> 4) {
                    case -1: {
                        throw new EOFException();
                    }
                    case 12: 
                    case 13: {
                        cArray[n2++] = (char)((n4 & 0x1F) << 6 | this.read() & 0x3F);
                        n3 += 2;
                        continue block9;
                    }
                    case 14: {
                        cArray[n2++] = (char)((n4 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                        n3 += 3;
                        continue block9;
                    }
                }
                cArray[n2++] = (char)n4;
                ++n3;
            }
            return new String(cArray, 0, n2);
        }
    }

    static class Vertices {
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

