/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ShortArray;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.utils.Triangulator;

public class SkeletonClipping {
    private final Triangulator triangulator = new Triangulator();
    private final FloatArray clippingPolygon = new FloatArray();
    private final FloatArray clipOutput = new FloatArray(128);
    private final FloatArray clippedVertices = new FloatArray(128);
    private final ShortArray clippedTriangles = new ShortArray(128);
    private final FloatArray scratch = new FloatArray();
    private ClippingAttachment clipAttachment;
    private Array<FloatArray> clippingPolygons;

    public int clipStart(Slot slot, ClippingAttachment clippingAttachment) {
        if (this.clipAttachment != null) {
            return 0;
        }
        int n = clippingAttachment.getWorldVerticesLength();
        if (n < 6) {
            return 0;
        }
        this.clipAttachment = clippingAttachment;
        float[] fArray = this.clippingPolygon.setSize(n);
        clippingAttachment.computeWorldVertices(slot, 0, n, fArray, 0, 2);
        SkeletonClipping.makeClockwise(this.clippingPolygon);
        ShortArray shortArray = this.triangulator.triangulate(this.clippingPolygon);
        this.clippingPolygons = this.triangulator.decompose(this.clippingPolygon, shortArray);
        for (FloatArray floatArray : this.clippingPolygons) {
            SkeletonClipping.makeClockwise(floatArray);
            floatArray.add(floatArray.items[0]);
            floatArray.add(floatArray.items[1]);
        }
        return this.clippingPolygons.size;
    }

    public void clipEnd(Slot slot) {
        if (this.clipAttachment != null && this.clipAttachment.getEndSlot() == slot.getData()) {
            this.clipEnd();
        }
    }

    public void clipEnd() {
        if (this.clipAttachment == null) {
            return;
        }
        this.clipAttachment = null;
        this.clippingPolygons = null;
        this.clippedVertices.clear();
        this.clippedTriangles.clear();
        this.clippingPolygon.clear();
    }

    public boolean isClipping() {
        return this.clipAttachment != null;
    }

    public void clipTriangles(float[] fArray, int n, short[] sArray, int n2, float[] fArray2, float f, float f2, boolean bl) {
        FloatArray floatArray = this.clipOutput;
        FloatArray floatArray2 = this.clippedVertices;
        ShortArray shortArray = this.clippedTriangles;
        T[] TArray = this.clippingPolygons.items;
        int n3 = this.clippingPolygons.size;
        int n4 = bl ? 6 : 5;
        short s = 0;
        floatArray2.clear();
        shortArray.clear();
        block0: for (int i = 0; i < n2; i += 3) {
            int n5 = sArray[i] << 1;
            float f3 = fArray[n5];
            float f4 = fArray[n5 + 1];
            float f5 = fArray2[n5];
            float f6 = fArray2[n5 + 1];
            n5 = sArray[i + 1] << 1;
            float f7 = fArray[n5];
            float f8 = fArray[n5 + 1];
            float f9 = fArray2[n5];
            float f10 = fArray2[n5 + 1];
            n5 = sArray[i + 2] << 1;
            float f11 = fArray[n5];
            float f12 = fArray[n5 + 1];
            float f13 = fArray2[n5];
            float f14 = fArray2[n5 + 1];
            for (int j = 0; j < n3; ++j) {
                int n6 = floatArray2.size;
                if (this.clip(f3, f4, f7, f8, f11, f12, (FloatArray)TArray[j], floatArray)) {
                    int n7 = floatArray.size;
                    if (n7 == 0) continue;
                    float f15 = f8 - f12;
                    float f16 = f11 - f7;
                    float f17 = f3 - f11;
                    float f18 = f12 - f4;
                    float f19 = 1.0f / (f15 * f17 + f16 * (f4 - f12));
                    int n8 = n7 >> 1;
                    float[] fArray3 = floatArray.items;
                    float[] fArray4 = floatArray2.setSize(n6 + n8 * n4);
                    for (int k = 0; k < n7; k += 2) {
                        float f20 = fArray3[k];
                        float f21 = fArray3[k + 1];
                        fArray4[n6] = f20;
                        fArray4[n6 + 1] = f21;
                        fArray4[n6 + 2] = f;
                        if (bl) {
                            fArray4[n6 + 3] = f2;
                            n6 += 4;
                        } else {
                            n6 += 3;
                        }
                        float f22 = f20 - f11;
                        float f23 = f21 - f12;
                        float f24 = (f15 * f22 + f16 * f23) * f19;
                        float f25 = (f18 * f22 + f17 * f23) * f19;
                        float f26 = 1.0f - f24 - f25;
                        fArray4[n6] = f5 * f24 + f9 * f25 + f13 * f26;
                        fArray4[n6 + 1] = f6 * f24 + f10 * f25 + f14 * f26;
                        n6 += 2;
                    }
                    n6 = shortArray.size;
                    short[] sArray2 = shortArray.setSize(n6 + 3 * (n8 - 2));
                    --n8;
                    for (int k = 1; k < n8; ++k) {
                        sArray2[n6] = s;
                        sArray2[n6 + 1] = (short)(s + k);
                        sArray2[n6 + 2] = (short)(s + k + 1);
                        n6 += 3;
                    }
                    s = (short)(s + (n8 + 1));
                    continue;
                }
                float[] fArray5 = floatArray2.setSize(n6 + 3 * n4);
                fArray5[n6] = f3;
                fArray5[n6 + 1] = f4;
                fArray5[n6 + 2] = f;
                if (!bl) {
                    fArray5[n6 + 3] = f5;
                    fArray5[n6 + 4] = f6;
                    fArray5[n6 + 5] = f7;
                    fArray5[n6 + 6] = f8;
                    fArray5[n6 + 7] = f;
                    fArray5[n6 + 8] = f9;
                    fArray5[n6 + 9] = f10;
                    fArray5[n6 + 10] = f11;
                    fArray5[n6 + 11] = f12;
                    fArray5[n6 + 12] = f;
                    fArray5[n6 + 13] = f13;
                    fArray5[n6 + 14] = f14;
                } else {
                    fArray5[n6 + 3] = f2;
                    fArray5[n6 + 4] = f5;
                    fArray5[n6 + 5] = f6;
                    fArray5[n6 + 6] = f7;
                    fArray5[n6 + 7] = f8;
                    fArray5[n6 + 8] = f;
                    fArray5[n6 + 9] = f2;
                    fArray5[n6 + 10] = f9;
                    fArray5[n6 + 11] = f10;
                    fArray5[n6 + 12] = f11;
                    fArray5[n6 + 13] = f12;
                    fArray5[n6 + 14] = f;
                    fArray5[n6 + 15] = f2;
                    fArray5[n6 + 16] = f13;
                    fArray5[n6 + 17] = f14;
                }
                n6 = shortArray.size;
                short[] sArray3 = shortArray.setSize(n6 + 3);
                sArray3[n6] = s;
                sArray3[n6 + 1] = (short)(s + 1);
                sArray3[n6 + 2] = (short)(s + 2);
                s = (short)(s + 3);
                continue block0;
            }
        }
    }

    boolean clip(float f, float f2, float f3, float f4, float f5, float f6, FloatArray floatArray, FloatArray floatArray2) {
        FloatArray floatArray3 = floatArray2;
        boolean bl = false;
        FloatArray floatArray4 = null;
        if (floatArray.size % 4 >= 2) {
            floatArray4 = floatArray2;
            floatArray2 = this.scratch;
        } else {
            floatArray4 = this.scratch;
        }
        floatArray4.clear();
        floatArray4.add(f);
        floatArray4.add(f2);
        floatArray4.add(f3);
        floatArray4.add(f4);
        floatArray4.add(f5);
        floatArray4.add(f6);
        floatArray4.add(f);
        floatArray4.add(f2);
        floatArray2.clear();
        float[] fArray = floatArray.items;
        int n = floatArray.size - 4;
        int n2 = 0;
        while (true) {
            float f7 = fArray[n2];
            float f8 = fArray[n2 + 1];
            float f9 = fArray[n2 + 2];
            float f10 = fArray[n2 + 3];
            float f11 = f7 - f9;
            float f12 = f8 - f10;
            float[] fArray2 = floatArray4.items;
            int n3 = floatArray4.size - 2;
            int n4 = floatArray2.size;
            for (int i = 0; i < n3; i += 2) {
                float f13;
                float f14;
                float f15;
                float f16;
                boolean bl2;
                float f17 = fArray2[i];
                float f18 = fArray2[i + 1];
                float f19 = fArray2[i + 3];
                float f20 = fArray2[i + 2];
                boolean bl3 = bl2 = f11 * (f19 - f10) - f12 * (f20 - f9) > 0.0f;
                if (f11 * (f18 - f10) - f12 * (f17 - f9) > 0.0f) {
                    if (bl2) {
                        floatArray2.add(f20);
                        floatArray2.add(f19);
                        continue;
                    }
                    f16 = f19 - f18;
                    f15 = f20 - f17;
                    f14 = f16 * (f9 - f7) - f15 * (f10 - f8);
                    if (Math.abs(f14) > 1.0E-6f) {
                        f13 = (f15 * (f8 - f18) - f16 * (f7 - f17)) / f14;
                        floatArray2.add(f7 + (f9 - f7) * f13);
                        floatArray2.add(f8 + (f10 - f8) * f13);
                    } else {
                        floatArray2.add(f7);
                        floatArray2.add(f8);
                    }
                } else if (bl2) {
                    f16 = f19 - f18;
                    f15 = f20 - f17;
                    f14 = f16 * (f9 - f7) - f15 * (f10 - f8);
                    if (Math.abs(f14) > 1.0E-6f) {
                        f13 = (f15 * (f8 - f18) - f16 * (f7 - f17)) / f14;
                        floatArray2.add(f7 + (f9 - f7) * f13);
                        floatArray2.add(f8 + (f10 - f8) * f13);
                    } else {
                        floatArray2.add(f7);
                        floatArray2.add(f8);
                    }
                    floatArray2.add(f20);
                    floatArray2.add(f19);
                }
                bl = true;
            }
            if (n4 == floatArray2.size) {
                floatArray3.clear();
                return true;
            }
            floatArray2.add(floatArray2.items[0]);
            floatArray2.add(floatArray2.items[1]);
            if (n2 == n) break;
            FloatArray floatArray5 = floatArray2;
            floatArray2 = floatArray4;
            floatArray2.clear();
            floatArray4 = floatArray5;
            n2 += 2;
        }
        if (floatArray3 != floatArray2) {
            floatArray3.clear();
            floatArray3.addAll(floatArray2.items, 0, floatArray2.size - 2);
        } else {
            floatArray3.setSize(floatArray3.size - 2);
        }
        return bl;
    }

    public FloatArray getClippedVertices() {
        return this.clippedVertices;
    }

    public ShortArray getClippedTriangles() {
        return this.clippedTriangles;
    }

    static void makeClockwise(FloatArray floatArray) {
        int n;
        float[] fArray = floatArray.items;
        int n2 = floatArray.size;
        float f = fArray[n2 - 2] * fArray[1] - fArray[0] * fArray[n2 - 1];
        int n3 = n2 - 3;
        for (n = 0; n < n3; n += 2) {
            float f2 = fArray[n];
            float f3 = fArray[n + 1];
            float f4 = fArray[n + 2];
            float f5 = fArray[n + 3];
            f += f2 * f5 - f4 * f3;
        }
        if (f < 0.0f) {
            return;
        }
        n3 = n2 - 2;
        int n4 = n2 >> 1;
        for (n = 0; n < n4; n += 2) {
            float f6 = fArray[n];
            float f7 = fArray[n + 1];
            int n5 = n3 - n;
            fArray[n] = fArray[n5];
            fArray[n + 1] = fArray[n5 + 1];
            fArray[n5] = f6;
            fArray[n5 + 1] = f7;
        }
    }
}

