/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.utils.SpineUtils;

public class IkConstraint
implements Constraint {
    final IkConstraintData data;
    final Array<Bone> bones;
    Bone target;
    int bendDirection;
    boolean compress;
    boolean stretch;
    float mix = 1.0f;

    public IkConstraint(IkConstraintData ikConstraintData, Skeleton skeleton) {
        if (ikConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraintData;
        this.mix = ikConstraintData.mix;
        this.bendDirection = ikConstraintData.bendDirection;
        this.compress = ikConstraintData.compress;
        this.stretch = ikConstraintData.stretch;
        this.bones = new Array(ikConstraintData.bones.size);
        for (BoneData boneData : ikConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findBone(ikConstraintData.target.name);
    }

    public IkConstraint(IkConstraint ikConstraint, Skeleton skeleton) {
        if (ikConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraint.data;
        this.bones = new Array(ikConstraint.bones.size);
        for (Bone bone : ikConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.bones.get(ikConstraint.target.data.index);
        this.mix = ikConstraint.mix;
        this.bendDirection = ikConstraint.bendDirection;
        this.compress = ikConstraint.compress;
        this.stretch = ikConstraint.stretch;
    }

    public void apply() {
        this.update();
    }

    @Override
    public void update() {
        Bone bone = this.target;
        Array<Bone> array = this.bones;
        switch (array.size) {
            case 1: {
                IkConstraint.apply(array.first(), bone.worldX, bone.worldY, this.compress, this.stretch, this.data.uniform, this.mix);
                break;
            }
            case 2: {
                IkConstraint.apply(array.first(), array.get(1), bone.worldX, bone.worldY, this.bendDirection, this.stretch, this.mix);
            }
        }
    }

    @Override
    public int getOrder() {
        return this.data.order;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getTarget() {
        return this.target;
    }

    public void setTarget(Bone bone) {
        this.target = bone;
    }

    public float getMix() {
        return this.mix;
    }

    public void setMix(float f) {
        this.mix = f;
    }

    public int getBendDirection() {
        return this.bendDirection;
    }

    public void setBendDirection(int n) {
        this.bendDirection = n;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean bl) {
        this.compress = bl;
    }

    public boolean getStretch() {
        return this.stretch;
    }

    public void setStretch(boolean bl) {
        this.stretch = bl;
    }

    public IkConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }

    public static void apply(Bone bone, float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3) {
        if (!bone.appliedValid) {
            bone.updateAppliedTransform();
        }
        Bone bone2 = bone.parent;
        float f4 = 1.0f / (bone2.a * bone2.d - bone2.b * bone2.c);
        float f5 = f - bone2.worldX;
        float f6 = f2 - bone2.worldY;
        float f7 = (f5 * bone2.d - f6 * bone2.b) * f4 - bone.ax;
        float f8 = (f6 * bone2.a - f5 * bone2.c) * f4 - bone.ay;
        float f9 = SpineUtils.atan2(f8, f7) * 57.295776f - bone.ashearX - bone.arotation;
        if (bone.ascaleX < 0.0f) {
            f9 += 180.0f;
        }
        if (f9 > 180.0f) {
            f9 -= 360.0f;
        } else if (f9 < -180.0f) {
            f9 += 360.0f;
        }
        float f10 = bone.ascaleX;
        float f11 = bone.ascaleY;
        if (bl || bl2) {
            float f12 = bone.data.length * f10;
            float f13 = (float)Math.sqrt(f7 * f7 + f8 * f8);
            if (bl && f13 < f12 || bl2 && f13 > f12 && f12 > 1.0E-4f) {
                float f14 = (f13 / f12 - 1.0f) * f3 + 1.0f;
                f10 *= f14;
                if (bl3) {
                    f11 *= f14;
                }
            }
        }
        bone.updateWorldTransform(bone.ax, bone.ay, bone.arotation + f9 * f3, f10, f11, bone.ashearX, bone.ashearY);
    }

    /*
     * Unable to fully structure code
     */
    public static void apply(Bone var0, Bone var1_1, float var2_2, float var3_3, int var4_4, boolean var5_5, float var6_6) {
        block29: {
            block28: {
                if (var6_6 == 0.0f) {
                    var1_1.updateWorldTransform();
                    return;
                }
                if (!var0.appliedValid) {
                    var0.updateAppliedTransform();
                }
                if (!var1_1.appliedValid) {
                    var1_1.updateAppliedTransform();
                }
                var7_7 = var0.ax;
                var8_8 = var0.ay;
                var10_10 = var9_9 = var0.ascaleX;
                var11_11 = var0.ascaleY;
                var12_12 = var1_1.ascaleX;
                if (var9_9 < 0.0f) {
                    var9_9 = -var9_9;
                    var13_13 = 180;
                    var15_14 = -1;
                } else {
                    var13_13 = 0;
                    var15_14 = 1;
                }
                if (var11_11 < 0.0f) {
                    var11_11 = -var11_11;
                    var15_14 = -var15_14;
                }
                if (var12_12 < 0.0f) {
                    var12_12 = -var12_12;
                    var14_15 = 180;
                } else {
                    var14_15 = 0;
                }
                var16_16 = var1_1.ax;
                var20_17 = var0.a;
                var21_18 = var0.b;
                var22_19 = var0.c;
                var23_20 = var0.d;
                v0 = var24_21 = Math.abs(var9_9 - var11_11) <= 1.0E-4f;
                if (!var24_21) {
                    var17_22 = 0.0f;
                    var18_23 = var20_17 * var16_16 + var0.worldX;
                    var19_24 = var22_19 * var16_16 + var0.worldY;
                } else {
                    var17_22 = var1_1.ay;
                    var18_23 = var20_17 * var16_16 + var21_18 * var17_22 + var0.worldX;
                    var19_24 = var22_19 * var16_16 + var23_20 * var17_22 + var0.worldY;
                }
                var25_25 = var0.parent;
                var20_17 = var25_25.a;
                var21_18 = var25_25.b;
                var22_19 = var25_25.c;
                var23_20 = var25_25.d;
                var26_26 = 1.0f / (var20_17 * var23_20 - var21_18 * var22_19);
                var27_27 = var2_2 - var25_25.worldX;
                var28_28 = var3_3 - var25_25.worldY;
                var29_29 = (var27_27 * var23_20 - var28_28 * var21_18) * var26_26 - var7_7;
                var30_30 = (var28_28 * var20_17 - var27_27 * var22_19) * var26_26 - var8_8;
                var31_31 = var29_29 * var29_29 + var30_30 * var30_30;
                var27_27 = var18_23 - var25_25.worldX;
                var28_28 = var19_24 - var25_25.worldY;
                var32_32 = (var27_27 * var23_20 - var28_28 * var21_18) * var26_26 - var7_7;
                var33_33 = (var28_28 * var20_17 - var27_27 * var22_19) * var26_26 - var8_8;
                var34_34 = (float)Math.sqrt(var32_32 * var32_32 + var33_33 * var33_33);
                var35_35 = var1_1.data.length * var12_12;
                if (!var24_21) break block28;
                if ((var38_36 = (var31_31 - var34_34 * var34_34 - (var35_35 *= var9_9) * var35_35) / (2.0f * var34_34 * var35_35)) < -1.0f) {
                    var38_36 = -1.0f;
                } else if (var38_36 > 1.0f) {
                    var38_36 = 1.0f;
                    if (var5_5 && var34_34 + var35_35 > 1.0E-4f) {
                        var10_10 *= ((float)Math.sqrt(var31_31) / (var34_34 + var35_35) - 1.0f) * var6_6 + 1.0f;
                    }
                }
                var37_37 = (float)Math.acos(var38_36) * (float)var4_4;
                var20_17 = var34_34 + var35_35 * var38_36;
                var21_18 = var35_35 * SpineUtils.sin(var37_37);
                var36_38 = SpineUtils.atan2(var30_30 * var20_17 - var29_29 * var21_18, var29_29 * var20_17 + var30_30 * var21_18);
                break block29;
            }
            var20_17 = var9_9 * var35_35;
            var21_18 = var11_11 * var35_35;
            var38_36 = var20_17 * var20_17;
            var39_39 = var21_18 * var21_18;
            var40_40 = SpineUtils.atan2(var30_30, var29_29);
            var41_41 = -2.0f * var39_39 * var34_34;
            var42_42 = var39_39 - var38_36;
            var22_19 = var39_39 * var34_34 * var34_34 + var38_36 * var31_31 - var38_36 * var39_39;
            var23_20 = var41_41 * var41_41 - 4.0f * var42_42 * var22_19;
            if (!(var23_20 >= 0.0f)) ** GOTO lbl-1000
            var43_43 = (float)Math.sqrt(var23_20);
            if (var41_41 < 0.0f) {
                var43_43 = -var43_43;
            }
            var43_43 = -(var41_41 + var43_43) / 2.0f;
            var44_44 = var43_43 / var42_42;
            var45_45 = var22_19 / var43_43;
            v1 = var46_46 = Math.abs(var44_44) < Math.abs(var45_45) ? var44_44 : var45_45;
            if (var46_46 * var46_46 <= var31_31) {
                var28_28 = (float)Math.sqrt(var31_31 - var46_46 * var46_46) * (float)var4_4;
                var36_38 = var40_40 - SpineUtils.atan2(var28_28, var46_46);
                var37_37 = SpineUtils.atan2(var28_28 / var11_11, (var46_46 - var34_34) / var9_9);
            } else lbl-1000:
            // 2 sources

            {
                var43_43 = 3.1415927f;
                var44_44 = var34_34 - var20_17;
                var45_45 = var44_44 * var44_44;
                var46_46 = 0.0f;
                var47_47 = 0.0f;
                var48_48 = var34_34 + var20_17;
                var49_49 = var48_48 * var48_48;
                var50_50 = 0.0f;
                var22_19 = -var20_17 * var34_34 / (var38_36 - var39_39);
                if (var22_19 >= -1.0f && var22_19 <= 1.0f) {
                    var27_27 = var20_17 * SpineUtils.cos(var22_19 = (float)Math.acos(var22_19)) + var34_34;
                    var23_20 = var27_27 * var27_27 + (var28_28 = var21_18 * SpineUtils.sin(var22_19)) * var28_28;
                    if (var23_20 < var45_45) {
                        var43_43 = var22_19;
                        var45_45 = var23_20;
                        var44_44 = var27_27;
                        var46_46 = var28_28;
                    }
                    if (var23_20 > var49_49) {
                        var47_47 = var22_19;
                        var49_49 = var23_20;
                        var48_48 = var27_27;
                        var50_50 = var28_28;
                    }
                }
                if (var31_31 <= (var45_45 + var49_49) / 2.0f) {
                    var36_38 = var40_40 - SpineUtils.atan2(var46_46 * (float)var4_4, var44_44);
                    var37_37 = var43_43 * (float)var4_4;
                } else {
                    var36_38 = var40_40 - SpineUtils.atan2(var50_50 * (float)var4_4, var48_48);
                    var37_37 = var47_47 * (float)var4_4;
                }
            }
        }
        var38_36 = SpineUtils.atan2(var17_22, var16_16) * (float)var15_14;
        var39_39 = var0.arotation;
        var36_38 = (var36_38 - var38_36) * 57.295776f + (float)var13_13 - var39_39;
        if (var36_38 > 180.0f) {
            var36_38 -= 360.0f;
        } else if (var36_38 < -180.0f) {
            var36_38 += 360.0f;
        }
        var0.updateWorldTransform(var7_7, var8_8, var39_39 + var36_38 * var6_6, var10_10, var0.ascaleY, 0.0f, 0.0f);
        var39_39 = var1_1.arotation;
        var37_37 = ((var37_37 + var38_36) * 57.295776f - var1_1.ashearX) * (float)var15_14 + (float)var14_15 - var39_39;
        if (var37_37 > 180.0f) {
            var37_37 -= 360.0f;
        } else if (var37_37 < -180.0f) {
            var37_37 += 360.0f;
        }
        var1_1.updateWorldTransform(var16_16, var17_22, var39_39 + var37_37 * var6_6, var1_1.ascaleX, var1_1.ascaleY, var1_1.ashearX, var1_1.ashearY);
    }
}

