/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Bone
implements Updatable {
    final BoneData data;
    final Skeleton skeleton;
    final Bone parent;
    final Array<Bone> children = new Array();
    float x;
    float y;
    float rotation;
    float scaleX;
    float scaleY;
    float shearX;
    float shearY;
    float ax;
    float ay;
    float arotation;
    float ascaleX;
    float ascaleY;
    float ashearX;
    float ashearY;
    boolean appliedValid;
    float a;
    float b;
    float worldX;
    float c;
    float d;
    float worldY;
    boolean sorted;

    public Bone(BoneData boneData, Skeleton skeleton, Bone bone) {
        if (boneData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = boneData;
        this.skeleton = skeleton;
        this.parent = bone;
        this.setToSetupPose();
    }

    public Bone(Bone bone, Skeleton skeleton, Bone bone2) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.skeleton = skeleton;
        this.parent = bone2;
        this.data = bone.data;
        this.x = bone.x;
        this.y = bone.y;
        this.rotation = bone.rotation;
        this.scaleX = bone.scaleX;
        this.scaleY = bone.scaleY;
        this.shearX = bone.shearX;
        this.shearY = bone.shearY;
    }

    @Override
    public void update() {
        this.updateWorldTransform(this.x, this.y, this.rotation, this.scaleX, this.scaleY, this.shearX, this.shearY);
    }

    public void updateWorldTransform() {
        this.updateWorldTransform(this.x, this.y, this.rotation, this.scaleX, this.scaleY, this.shearX, this.shearY);
    }

    public void updateWorldTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.ax = f;
        this.ay = f2;
        this.arotation = f3;
        this.ascaleX = f4;
        this.ascaleY = f5;
        this.ashearX = f6;
        this.ashearY = f7;
        this.appliedValid = true;
        Bone bone = this.parent;
        if (bone == null) {
            Skeleton skeleton = this.skeleton;
            float f8 = f3 + 90.0f + f7;
            float f9 = skeleton.scaleX;
            float f10 = skeleton.scaleY;
            this.a = SpineUtils.cosDeg(f3 + f6) * f4 * f9;
            this.b = SpineUtils.cosDeg(f8) * f5 * f10;
            this.c = SpineUtils.sinDeg(f3 + f6) * f4 * f9;
            this.d = SpineUtils.sinDeg(f8) * f5 * f10;
            this.worldX = f * f9 + skeleton.x;
            this.worldY = f2 * f10 + skeleton.y;
            return;
        }
        float f11 = bone.a;
        float f12 = bone.b;
        float f13 = bone.c;
        float f14 = bone.d;
        this.worldX = f11 * f + f12 * f2 + bone.worldX;
        this.worldY = f13 * f + f14 * f2 + bone.worldY;
        switch (this.data.transformMode) {
            case normal: {
                float f15 = f3 + 90.0f + f7;
                float f16 = SpineUtils.cosDeg(f3 + f6) * f4;
                float f17 = SpineUtils.cosDeg(f15) * f5;
                float f18 = SpineUtils.sinDeg(f3 + f6) * f4;
                float f19 = SpineUtils.sinDeg(f15) * f5;
                this.a = f11 * f16 + f12 * f18;
                this.b = f11 * f17 + f12 * f19;
                this.c = f13 * f16 + f14 * f18;
                this.d = f13 * f17 + f14 * f19;
                return;
            }
            case onlyTranslation: {
                float f20 = f3 + 90.0f + f7;
                this.a = SpineUtils.cosDeg(f3 + f6) * f4;
                this.b = SpineUtils.cosDeg(f20) * f5;
                this.c = SpineUtils.sinDeg(f3 + f6) * f4;
                this.d = SpineUtils.sinDeg(f20) * f5;
                break;
            }
            case noRotationOrReflection: {
                float f21;
                float f22 = f11 * f11 + f13 * f13;
                if (f22 > 1.0E-4f) {
                    f22 = Math.abs(f11 * f14 - f12 * f13) / f22;
                    f12 = f13 * f22;
                    f14 = f11 * f22;
                    f21 = SpineUtils.atan2(f13, f11) * 57.295776f;
                } else {
                    f11 = 0.0f;
                    f13 = 0.0f;
                    f21 = 90.0f - SpineUtils.atan2(f14, f12) * 57.295776f;
                }
                float f23 = f3 + f6 - f21;
                float f24 = f3 + f7 - f21 + 90.0f;
                float f25 = SpineUtils.cosDeg(f23) * f4;
                float f26 = SpineUtils.cosDeg(f24) * f5;
                float f27 = SpineUtils.sinDeg(f23) * f4;
                float f28 = SpineUtils.sinDeg(f24) * f5;
                this.a = f11 * f25 - f12 * f27;
                this.b = f11 * f26 - f12 * f28;
                this.c = f13 * f25 + f14 * f27;
                this.d = f13 * f26 + f14 * f28;
                break;
            }
            case noScale: 
            case noScaleOrReflection: {
                float f29 = SpineUtils.cosDeg(f3);
                float f30 = SpineUtils.sinDeg(f3);
                float f31 = (f11 * f29 + f12 * f30) / this.skeleton.scaleX;
                float f32 = (f13 * f29 + f14 * f30) / this.skeleton.scaleY;
                float f33 = (float)Math.sqrt(f31 * f31 + f32 * f32);
                if (f33 > 1.0E-5f) {
                    f33 = 1.0f / f33;
                }
                f31 *= f33;
                f32 *= f33;
                f33 = (float)Math.sqrt(f31 * f31 + f32 * f32);
                if (this.data.transformMode == BoneData.TransformMode.noScale && f11 * f14 - f12 * f13 < 0.0f != (this.skeleton.scaleX < 0.0f != this.skeleton.scaleY < 0.0f)) {
                    f33 = -f33;
                }
                float f34 = 1.5707964f + SpineUtils.atan2(f32, f31);
                float f35 = SpineUtils.cos(f34) * f33;
                float f36 = SpineUtils.sin(f34) * f33;
                float f37 = SpineUtils.cosDeg(f6) * f4;
                float f38 = SpineUtils.cosDeg(90.0f + f7) * f5;
                float f39 = SpineUtils.sinDeg(f6) * f4;
                float f40 = SpineUtils.sinDeg(90.0f + f7) * f5;
                this.a = f31 * f37 + f35 * f39;
                this.b = f31 * f38 + f35 * f40;
                this.c = f32 * f37 + f36 * f39;
                this.d = f32 * f38 + f36 * f40;
                break;
            }
        }
        this.a *= this.skeleton.scaleX;
        this.b *= this.skeleton.scaleX;
        this.c *= this.skeleton.scaleY;
        this.d *= this.skeleton.scaleY;
    }

    public void setToSetupPose() {
        BoneData boneData = this.data;
        this.x = boneData.x;
        this.y = boneData.y;
        this.rotation = boneData.rotation;
        this.scaleX = boneData.scaleX;
        this.scaleY = boneData.scaleY;
        this.shearX = boneData.shearX;
        this.shearY = boneData.shearY;
    }

    public BoneData getData() {
        return this.data;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Bone getParent() {
        return this.parent;
    }

    public Array<Bone> getChildren() {
        return this.children;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public void setScale(float f) {
        this.scaleX = f;
        this.scaleY = f;
    }

    public float getShearX() {
        return this.shearX;
    }

    public void setShearX(float f) {
        this.shearX = f;
    }

    public float getShearY() {
        return this.shearY;
    }

    public void setShearY(float f) {
        this.shearY = f;
    }

    public float getAX() {
        return this.ax;
    }

    public void setAX(float f) {
        this.ax = f;
    }

    public float getAY() {
        return this.ay;
    }

    public void setAY(float f) {
        this.ay = f;
    }

    public float getARotation() {
        return this.arotation;
    }

    public void setARotation(float f) {
        this.arotation = f;
    }

    public float getAScaleX() {
        return this.ascaleX;
    }

    public void setAScaleX(float f) {
        this.ascaleX = f;
    }

    public float getAScaleY() {
        return this.ascaleY;
    }

    public void setAScaleY(float f) {
        this.ascaleY = f;
    }

    public float getAShearX() {
        return this.ashearX;
    }

    public void setAShearX(float f) {
        this.ashearX = f;
    }

    public float getAShearY() {
        return this.ashearY;
    }

    public void setAShearY(float f) {
        this.ashearY = f;
    }

    public boolean isAppliedValid() {
        return this.appliedValid;
    }

    public void setAppliedValid(boolean bl) {
        this.appliedValid = bl;
    }

    public void updateAppliedTransform() {
        this.appliedValid = true;
        Bone bone = this.parent;
        if (bone == null) {
            this.ax = this.worldX;
            this.ay = this.worldY;
            this.arotation = SpineUtils.atan2(this.c, this.a) * 57.295776f;
            this.ascaleX = (float)Math.sqrt(this.a * this.a + this.c * this.c);
            this.ascaleY = (float)Math.sqrt(this.b * this.b + this.d * this.d);
            this.ashearX = 0.0f;
            this.ashearY = SpineUtils.atan2(this.a * this.b + this.c * this.d, this.a * this.d - this.b * this.c) * 57.295776f;
            return;
        }
        float f = bone.a;
        float f2 = bone.b;
        float f3 = bone.c;
        float f4 = bone.d;
        float f5 = 1.0f / (f * f4 - f2 * f3);
        float f6 = this.worldX - bone.worldX;
        float f7 = this.worldY - bone.worldY;
        this.ax = f6 * f4 * f5 - f7 * f2 * f5;
        this.ay = f7 * f * f5 - f6 * f3 * f5;
        float f8 = f5 * f4;
        float f9 = f5 * f;
        float f10 = f5 * f2;
        float f11 = f5 * f3;
        float f12 = f8 * this.a - f10 * this.c;
        float f13 = f8 * this.b - f10 * this.d;
        float f14 = f9 * this.c - f11 * this.a;
        float f15 = f9 * this.d - f11 * this.b;
        this.ashearX = 0.0f;
        this.ascaleX = (float)Math.sqrt(f12 * f12 + f14 * f14);
        if (this.ascaleX > 1.0E-4f) {
            float f16 = f12 * f15 - f13 * f14;
            this.ascaleY = f16 / this.ascaleX;
            this.ashearY = SpineUtils.atan2(f12 * f13 + f14 * f15, f16) * 57.295776f;
            this.arotation = SpineUtils.atan2(f14, f12) * 57.295776f;
        } else {
            this.ascaleX = 0.0f;
            this.ascaleY = (float)Math.sqrt(f13 * f13 + f15 * f15);
            this.ashearY = 0.0f;
            this.arotation = 90.0f - SpineUtils.atan2(f15, f13) * 57.295776f;
        }
    }

    public float getA() {
        return this.a;
    }

    public void setA(float f) {
        this.a = f;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float f) {
        this.b = f;
    }

    public float getC() {
        return this.c;
    }

    public void setC(float f) {
        this.c = f;
    }

    public float getD() {
        return this.d;
    }

    public void setD(float f) {
        this.d = f;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public void setWorldX(float f) {
        this.worldX = f;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public void setWorldY(float f) {
        this.worldY = f;
    }

    public float getWorldRotationX() {
        return SpineUtils.atan2(this.c, this.a) * 57.295776f;
    }

    public float getWorldRotationY() {
        return SpineUtils.atan2(this.d, this.b) * 57.295776f;
    }

    public float getWorldScaleX() {
        return (float)Math.sqrt(this.a * this.a + this.c * this.c);
    }

    public float getWorldScaleY() {
        return (float)Math.sqrt(this.b * this.b + this.d * this.d);
    }

    public Matrix3 getWorldTransform(Matrix3 matrix3) {
        if (matrix3 == null) {
            throw new IllegalArgumentException("worldTransform cannot be null.");
        }
        float[] fArray = matrix3.val;
        fArray[0] = this.a;
        fArray[3] = this.b;
        fArray[1] = this.c;
        fArray[4] = this.d;
        fArray[6] = this.worldX;
        fArray[7] = this.worldY;
        fArray[2] = 0.0f;
        fArray[5] = 0.0f;
        fArray[8] = 1.0f;
        return matrix3;
    }

    public Vector2 worldToLocal(Vector2 vector2) {
        float f = 1.0f / (this.a * this.d - this.b * this.c);
        float f2 = vector2.x - this.worldX;
        float f3 = vector2.y - this.worldY;
        vector2.x = f2 * this.d * f - f3 * this.b * f;
        vector2.y = f3 * this.a * f - f2 * this.c * f;
        return vector2;
    }

    public Vector2 localToWorld(Vector2 vector2) {
        float f = vector2.x;
        float f2 = vector2.y;
        vector2.x = f * this.a + f2 * this.b + this.worldX;
        vector2.y = f * this.c + f2 * this.d + this.worldY;
        return vector2;
    }

    public float worldToLocalRotation(float f) {
        float f2 = SpineUtils.sinDeg(f);
        float f3 = SpineUtils.cosDeg(f);
        return SpineUtils.atan2(this.a * f2 - this.c * f3, this.d * f3 - this.b * f2) * 57.295776f + this.rotation - this.shearX;
    }

    public float localToWorldRotation(float f) {
        float f2 = SpineUtils.sinDeg(f -= this.rotation - this.shearX);
        float f3 = SpineUtils.cosDeg(f);
        return SpineUtils.atan2(f3 * this.c + f2 * this.d, f3 * this.a + f2 * this.b) * 57.295776f;
    }

    public void rotateWorld(float f) {
        float f2 = SpineUtils.cosDeg(f);
        float f3 = SpineUtils.sinDeg(f);
        this.a = f2 * this.a - f3 * this.c;
        this.b = f2 * this.b - f3 * this.d;
        this.c = f3 * this.a + f2 * this.c;
        this.d = f3 * this.b + f2 * this.d;
        this.appliedValid = false;
    }

    public String toString() {
        return this.data.name;
    }
}

