/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.utils;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonRenderer;

public class SkeletonDrawable
extends BaseDrawable {
    private SkeletonRenderer renderer;
    private Skeleton skeleton;
    AnimationState state;

    public SkeletonDrawable() {
    }

    public SkeletonDrawable(SkeletonRenderer skeletonRenderer, Skeleton skeleton, AnimationState animationState) {
        this.renderer = skeletonRenderer;
        this.skeleton = skeleton;
        this.state = animationState;
    }

    public void update(float f) {
        this.state.update(f);
        this.state.apply(this.skeleton);
    }

    @Override
    public void draw(Batch batch, float f, float f2, float f3, float f4) {
        this.skeleton.setPosition(f, f2);
        this.skeleton.updateWorldTransform();
        this.renderer.draw(batch, this.skeleton);
    }

    public SkeletonRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(SkeletonRenderer skeletonRenderer) {
        this.renderer = skeletonRenderer;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    public AnimationState getAnimationState() {
        return this.state;
    }

    public void setAnimationState(AnimationState animationState) {
        this.state = animationState;
    }
}

