/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.PathAttachment;

public class PathConstraint
implements Constraint {
    private static final int NONE = -1;
    private static final int BEFORE = -2;
    private static final int AFTER = -3;
    private static final float epsilon = 1.0E-5f;
    final PathConstraintData data;
    final Array<Bone> bones;
    Slot target;
    float position;
    float spacing;
    float rotateMix;
    float translateMix;
    private final FloatArray spaces = new FloatArray();
    private final FloatArray positions = new FloatArray();
    private final FloatArray world = new FloatArray();
    private final FloatArray curves = new FloatArray();
    private final FloatArray lengths = new FloatArray();
    private final float[] segments = new float[10];

    public PathConstraint(PathConstraintData pathConstraintData, Skeleton skeleton) {
        if (pathConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = pathConstraintData;
        this.bones = new Array(pathConstraintData.bones.size);
        for (BoneData boneData : pathConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findSlot(pathConstraintData.target.name);
        this.position = pathConstraintData.position;
        this.spacing = pathConstraintData.spacing;
        this.rotateMix = pathConstraintData.rotateMix;
        this.translateMix = pathConstraintData.translateMix;
    }

    public PathConstraint(PathConstraint pathConstraint, Skeleton skeleton) {
        if (pathConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = pathConstraint.data;
        this.bones = new Array(pathConstraint.bones.size);
        for (Bone bone : pathConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.slots.get(pathConstraint.target.data.index);
        this.position = pathConstraint.position;
        this.spacing = pathConstraint.spacing;
        this.rotateMix = pathConstraint.rotateMix;
        this.translateMix = pathConstraint.translateMix;
    }

    public void apply() {
        this.update();
    }

    @Override
    public void update() {
        boolean bl;
        float f;
        boolean bl2;
        Attachment attachment = this.target.attachment;
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        float f2 = this.rotateMix;
        float f3 = this.translateMix;
        boolean bl3 = f3 > 0.0f;
        boolean bl4 = bl2 = f2 > 0.0f;
        if (!bl3 && !bl2) {
            return;
        }
        PathConstraintData pathConstraintData = this.data;
        PathConstraintData.SpacingMode spacingMode = pathConstraintData.spacingMode;
        boolean bl5 = spacingMode == PathConstraintData.SpacingMode.length;
        PathConstraintData.RotateMode rotateMode = pathConstraintData.rotateMode;
        boolean bl6 = rotateMode == PathConstraintData.RotateMode.tangent;
        boolean bl7 = rotateMode == PathConstraintData.RotateMode.chainScale;
        int n = this.bones.size;
        int n2 = bl6 ? n : n + 1;
        T[] TArray = this.bones.items;
        float[] fArray = this.spaces.setSize(n2);
        float[] fArray2 = null;
        float f4 = this.spacing;
        if (bl7 || bl5) {
            if (bl7) {
                fArray2 = this.lengths.setSize(n);
            }
            var18_18 = 0;
            int n3 = n2 - 1;
            while (var18_18 < n3) {
                Bone bone = (Bone)TArray[var18_18];
                f = bone.data.length;
                if (f < 1.0E-5f) {
                    if (bl7) {
                        fArray2[var18_18] = 0.0f;
                    }
                    fArray[++var18_18] = 0.0f;
                    continue;
                }
                float f5 = f * bone.a;
                float f6 = f * bone.c;
                float f7 = (float)Math.sqrt(f5 * f5 + f6 * f6);
                if (bl7) {
                    fArray2[var18_18] = f7;
                }
                fArray[++var18_18] = (bl5 ? f + f4 : f4) * f7 / f;
            }
        } else {
            for (var18_18 = 1; var18_18 < n2; ++var18_18) {
                fArray[var18_18] = f4;
            }
        }
        float[] fArray3 = this.computeWorldPositions((PathAttachment)attachment, n2, bl6, pathConstraintData.positionMode == PathConstraintData.PositionMode.percent, spacingMode == PathConstraintData.SpacingMode.percent);
        float f8 = fArray3[0];
        float f9 = fArray3[1];
        f = pathConstraintData.offsetRotation;
        if (f == 0.0f) {
            bl = rotateMode == PathConstraintData.RotateMode.chain;
        } else {
            bl = false;
            Bone bone = this.target.bone;
            f *= bone.a * bone.d - bone.b * bone.c > 0.0f ? (float)Math.PI / 180 : (float)(-Math.PI) / 180;
        }
        int n4 = 0;
        int n5 = 3;
        while (n4 < n) {
            float f10;
            float f11;
            Bone bone = (Bone)TArray[n4];
            bone.worldX += (f8 - bone.worldX) * f3;
            bone.worldY += (f9 - bone.worldY) * f3;
            float f12 = fArray3[n5];
            float f13 = fArray3[n5 + 1];
            float f14 = f12 - f8;
            float f15 = f13 - f9;
            if (bl7 && (f11 = fArray2[n4]) >= 1.0E-5f) {
                f10 = ((float)Math.sqrt(f14 * f14 + f15 * f15) / f11 - 1.0f) * f2 + 1.0f;
                bone.a *= f10;
                bone.c *= f10;
            }
            f8 = f12;
            f9 = f13;
            if (bl2) {
                float f16;
                float f17;
                f11 = bone.a;
                f10 = bone.b;
                float f18 = bone.c;
                float f19 = bone.d;
                float f20 = bl6 ? fArray3[n5 - 1] : (fArray[n4 + 1] < 1.0E-5f ? fArray3[n5 + 2] : (float)Math.atan2(f15, f14));
                f20 -= (float)Math.atan2(f18, f11);
                if (bl) {
                    f17 = (float)Math.cos(f20);
                    f16 = (float)Math.sin(f20);
                    float f21 = bone.data.length;
                    f8 += (f21 * (f17 * f11 - f16 * f18) - f14) * f2;
                    f9 += (f21 * (f16 * f11 + f17 * f18) - f15) * f2;
                } else {
                    f20 += f;
                }
                if (f20 > (float)Math.PI) {
                    f20 -= (float)Math.PI * 2;
                } else if (f20 < (float)(-Math.PI)) {
                    f20 += (float)Math.PI * 2;
                }
                f17 = (float)Math.cos(f20 *= f2);
                f16 = (float)Math.sin(f20);
                bone.a = f17 * f11 - f16 * f18;
                bone.b = f17 * f10 - f16 * f19;
                bone.c = f16 * f11 + f17 * f18;
                bone.d = f16 * f10 + f17 * f19;
            }
            bone.appliedValid = false;
            ++n4;
            n5 += 3;
        }
    }

    /*
     * Unable to fully structure code
     */
    float[] computeWorldPositions(PathAttachment var1_1, int var2_2, boolean var3_3, boolean var4_4, boolean var5_5) {
        block37: {
            var6_6 = this.target;
            var7_7 = this.position;
            var8_8 = this.spaces.items;
            var9_9 = this.positions.setSize(var2_2 * 3 + 2);
            var11_10 = var1_1.getClosed();
            var12_11 = var1_1.getWorldVerticesLength();
            var13_12 = var12_11 / 6;
            var14_13 = -1;
            if (var1_1.getConstantSpeed()) break block37;
            var15_14 = var1_1.getLengths();
            var16_16 = var15_14[var13_12 -= var11_10 != false ? 1 : 2];
            if (var4_4) {
                var7_7 *= var16_16;
            }
            if (var5_5) {
                var17_18 = 0;
                while (var17_18 < var2_2) {
                    v0 = var17_18++;
                    var8_8[v0] = var8_8[v0] * var16_16;
                }
            }
            var10_20 = this.world.setSize(8);
            var17_18 = 0;
            var18_22 = 0;
            var19_24 = 0;
            while (var17_18 < var2_2) {
                block38: {
                    var20_26 = var8_8[var17_18];
                    var21_28 = var7_7 += var20_26;
                    if (!var11_10) break block38;
                    if ((var21_28 %= var16_16) < 0.0f) {
                        var21_28 += var16_16;
                    }
                    var19_24 = 0;
                    ** GOTO lbl-1000
                }
                if (var21_28 < 0.0f) {
                    if (var14_13 != -2) {
                        var14_13 = -2;
                        var1_1.computeWorldVertices(var6_6, 2, 4, var10_20, 0, 2);
                    }
                    this.addBeforePosition(var21_28, var10_20, 0, var9_9, var18_22);
                } else if (var21_28 > var16_16) {
                    if (var14_13 != -3) {
                        var14_13 = -3;
                        var1_1.computeWorldVertices(var6_6, var12_11 - 6, 4, var10_20, 0, 2);
                    }
                    this.addAfterPosition(var21_28 - var16_16, var10_20, 0, var9_9, var18_22);
                } else lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (!(var21_28 > (var22_30 = var15_14[var19_24]))) {
                            if (var19_24 == 0) {
                                var21_28 /= var22_30;
                                break;
                            }
                            var23_32 = var15_14[var19_24 - 1];
                            var21_28 = (var21_28 - var23_32) / (var22_30 - var23_32);
                            break;
                        }
                        ++var19_24;
                    }
                    if (var19_24 != var14_13) {
                        var14_13 = var19_24;
                        if (var11_10 && var19_24 == var13_12) {
                            var1_1.computeWorldVertices(var6_6, var12_11 - 4, 4, var10_20, 0, 2);
                            var1_1.computeWorldVertices(var6_6, 0, 4, var10_20, 4, 2);
                        } else {
                            var1_1.computeWorldVertices(var6_6, var19_24 * 6 + 2, 8, var10_20, 0, 2);
                        }
                    }
                    this.addCurvePosition(var21_28, var10_20[0], var10_20[1], var10_20[2], var10_20[3], var10_20[4], var10_20[5], var10_20[6], var10_20[7], var9_9, var18_22, var3_3 != false || var17_18 > 0 && var20_26 < 1.0E-5f);
                }
                ++var17_18;
                var18_22 += 3;
            }
            return var9_9;
        }
        if (var11_10) {
            var10_21 = this.world.setSize(var12_11 += 2);
            var1_1.computeWorldVertices(var6_6, 2, var12_11 - 4, var10_21, 0, 2);
            var1_1.computeWorldVertices(var6_6, 0, 2, var10_21, var12_11 - 4, 2);
            var10_21[var12_11 - 2] = var10_21[0];
            var10_21[var12_11 - 1] = var10_21[1];
        } else {
            --var13_12;
            var10_21 = this.world.setSize(var12_11 -= 4);
            var1_1.computeWorldVertices(var6_6, 2, var12_11, var10_21, 0, 2);
        }
        var15_15 = this.curves.setSize(var13_12);
        var16_17 = 0.0f;
        var17_19 = var10_21[0];
        var18_23 = var10_21[1];
        var19_25 = 0.0f;
        var20_27 = 0.0f;
        var21_29 = 0.0f;
        var22_31 = 0.0f;
        var23_33 = 0.0f;
        var24_34 = 0.0f;
        var33_35 = 0;
        var34_37 = 2;
        while (var33_35 < var13_12) {
            var19_25 = var10_21[var34_37];
            var20_27 = var10_21[var34_37 + 1];
            var21_29 = var10_21[var34_37 + 2];
            var22_31 = var10_21[var34_37 + 3];
            var23_33 = var10_21[var34_37 + 4];
            var24_34 = var10_21[var34_37 + 5];
            var25_39 = (var17_19 - var19_25 * 2.0f + var21_29) * 0.1875f;
            var26_40 = (var18_23 - var20_27 * 2.0f + var22_31) * 0.1875f;
            var27_41 = ((var19_25 - var21_29) * 3.0f - var17_19 + var23_33) * 0.09375f;
            var28_42 = ((var20_27 - var22_31) * 3.0f - var18_23 + var24_34) * 0.09375f;
            var29_43 = var25_39 * 2.0f + var27_41;
            var30_44 = var26_40 * 2.0f + var28_42;
            var31_45 = (var19_25 - var17_19) * 0.75f + var25_39 + var27_41 * 0.16666667f;
            var32_46 = (var20_27 - var18_23) * 0.75f + var26_40 + var28_42 * 0.16666667f;
            var16_17 += (float)Math.sqrt(var31_45 * var31_45 + var32_46 * var32_46);
            var31_45 += var29_43;
            var32_46 += var30_44;
            var16_17 += (float)Math.sqrt(var31_45 * var31_45 + var32_46 * var32_46);
            var16_17 += (float)Math.sqrt((var31_45 += (var29_43 += var27_41)) * var31_45 + (var32_46 += (var30_44 += var28_42)) * var32_46);
            var15_15[var33_35] = var16_17 += (float)Math.sqrt((var31_45 += var29_43 + var27_41) * var31_45 + (var32_46 += var30_44 + var28_42) * var32_46);
            var17_19 = var23_33;
            var18_23 = var24_34;
            ++var33_35;
            var34_37 += 6;
        }
        if (var4_4) {
            var7_7 *= var16_17;
        }
        if (var5_5) {
            var33_35 = 0;
            while (var33_35 < var2_2) {
                v1 = var33_35++;
                var8_8[v1] = var8_8[v1] * var16_17;
            }
        }
        var33_36 = this.segments;
        var34_38 = 0.0f;
        var35_47 = 0;
        var36_48 = 0;
        var37_49 = 0;
        var38_50 = 0;
        while (var35_47 < var2_2) {
            block39: {
                var39_51 = var8_8[var35_47];
                var40_52 = var7_7 += var39_51;
                if (!var11_10) break block39;
                if ((var40_52 %= var16_17) < 0.0f) {
                    var40_52 += var16_17;
                }
                var37_49 = 0;
                ** GOTO lbl-1000
            }
            if (var40_52 < 0.0f) {
                this.addBeforePosition(var40_52, var10_21, 0, var9_9, var36_48);
            } else if (var40_52 > var16_17) {
                this.addAfterPosition(var40_52 - var16_17, var10_21, var12_11 - 4, var9_9, var36_48);
            } else lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (!(var40_52 > (var41_53 = var15_15[var37_49]))) {
                        if (var37_49 == 0) {
                            var40_52 /= var41_53;
                            break;
                        }
                        var42_55 = var15_15[var37_49 - 1];
                        var40_52 = (var40_52 - var42_55) / (var41_53 - var42_55);
                        break;
                    }
                    ++var37_49;
                }
                if (var37_49 != var14_13) {
                    var14_13 = var37_49;
                    var41_54 = var37_49 * 6;
                    var17_19 = var10_21[var41_54];
                    var18_23 = var10_21[var41_54 + 1];
                    var19_25 = var10_21[var41_54 + 2];
                    var20_27 = var10_21[var41_54 + 3];
                    var21_29 = var10_21[var41_54 + 4];
                    var22_31 = var10_21[var41_54 + 5];
                    var23_33 = var10_21[var41_54 + 6];
                    var24_34 = var10_21[var41_54 + 7];
                    var25_39 = (var17_19 - var19_25 * 2.0f + var21_29) * 0.03f;
                    var26_40 = (var18_23 - var20_27 * 2.0f + var22_31) * 0.03f;
                    var27_41 = ((var19_25 - var21_29) * 3.0f - var17_19 + var23_33) * 0.006f;
                    var28_42 = ((var20_27 - var22_31) * 3.0f - var18_23 + var24_34) * 0.006f;
                    var29_43 = var25_39 * 2.0f + var27_41;
                    var30_44 = var26_40 * 2.0f + var28_42;
                    var31_45 = (var19_25 - var17_19) * 0.3f + var25_39 + var27_41 * 0.16666667f;
                    var32_46 = (var20_27 - var18_23) * 0.3f + var26_40 + var28_42 * 0.16666667f;
                    var33_36[0] = var34_38 = (float)Math.sqrt(var31_45 * var31_45 + var32_46 * var32_46);
                    for (var41_54 = 1; var41_54 < 8; ++var41_54) {
                        var33_36[var41_54] = var34_38 += (float)Math.sqrt((var31_45 += (var29_43 += var27_41)) * var31_45 + (var32_46 += (var30_44 += var28_42)) * var32_46);
                    }
                    var33_36[8] = var34_38 += (float)Math.sqrt((var31_45 += var29_43) * var31_45 + (var32_46 += var30_44) * var32_46);
                    var33_36[9] = var34_38 += (float)Math.sqrt((var31_45 += var29_43 + var27_41) * var31_45 + (var32_46 += var30_44 + var28_42) * var32_46);
                    var38_50 = 0;
                }
                var40_52 *= var34_38;
                while (true) {
                    if (!(var40_52 > (var41_53 = var33_36[var38_50]))) {
                        if (var38_50 == 0) {
                            var40_52 /= var41_53;
                            break;
                        }
                        var42_55 = var33_36[var38_50 - 1];
                        var40_52 = (float)var38_50 + (var40_52 - var42_55) / (var41_53 - var42_55);
                        break;
                    }
                    ++var38_50;
                }
                this.addCurvePosition(var40_52 * 0.1f, var17_19, var18_23, var19_25, var20_27, var21_29, var22_31, var23_33, var24_34, var9_9, var36_48, var3_3 != false || var35_47 > 0 && var39_51 < 1.0E-5f);
            }
            ++var35_47;
            var36_48 += 3;
        }
        return var9_9;
    }

    private void addBeforePosition(float f, float[] fArray, int n, float[] fArray2, int n2) {
        float f2 = fArray[n];
        float f3 = fArray[n + 1];
        float f4 = fArray[n + 2] - f2;
        float f5 = fArray[n + 3] - f3;
        float f6 = (float)Math.atan2(f5, f4);
        fArray2[n2] = f2 + f * (float)Math.cos(f6);
        fArray2[n2 + 1] = f3 + f * (float)Math.sin(f6);
        fArray2[n2 + 2] = f6;
    }

    private void addAfterPosition(float f, float[] fArray, int n, float[] fArray2, int n2) {
        float f2 = fArray[n + 2];
        float f3 = fArray[n + 3];
        float f4 = f2 - fArray[n];
        float f5 = f3 - fArray[n + 1];
        float f6 = (float)Math.atan2(f5, f4);
        fArray2[n2] = f2 + f * (float)Math.cos(f6);
        fArray2[n2 + 1] = f3 + f * (float)Math.sin(f6);
        fArray2[n2 + 2] = f6;
    }

    private void addCurvePosition(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray, int n, boolean bl) {
        if (f < 1.0E-5f || Float.isNaN(f)) {
            f = 1.0E-5f;
        }
        float f10 = f * f;
        float f11 = f10 * f;
        float f12 = 1.0f - f;
        float f13 = f12 * f12;
        float f14 = f13 * f12;
        float f15 = f12 * f;
        float f16 = f15 * 3.0f;
        float f17 = f12 * f16;
        float f18 = f16 * f;
        float f19 = f2 * f14 + f4 * f17 + f6 * f18 + f8 * f11;
        float f20 = f3 * f14 + f5 * f17 + f7 * f18 + f9 * f11;
        fArray[n] = f19;
        fArray[n + 1] = f20;
        if (bl) {
            fArray[n + 2] = (float)Math.atan2(f20 - (f3 * f13 + f5 * f15 * 2.0f + f7 * f10), f19 - (f2 * f13 + f4 * f15 * 2.0f + f6 * f10));
        }
    }

    @Override
    public int getOrder() {
        return this.data.order;
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float f) {
        this.position = f;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float f) {
        this.spacing = f;
    }

    public float getRotateMix() {
        return this.rotateMix;
    }

    public void setRotateMix(float f) {
        this.rotateMix = f;
    }

    public float getTranslateMix() {
        return this.translateMix;
    }

    public void setTranslateMix(float f) {
        this.translateMix = f;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Slot getTarget() {
        return this.target;
    }

    public void setTarget(Slot slot) {
        this.target = slot;
    }

    public PathConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }
}

