/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.utils.TrigUtils;

public class IkConstraint
implements Constraint {
    final IkConstraintData data;
    final Array<Bone> bones;
    Bone target;
    float mix = 1.0f;
    int bendDirection;

    public IkConstraint(IkConstraintData ikConstraintData, Skeleton skeleton) {
        if (ikConstraintData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraintData;
        this.mix = ikConstraintData.mix;
        this.bendDirection = ikConstraintData.bendDirection;
        this.bones = new Array(ikConstraintData.bones.size);
        for (BoneData boneData : ikConstraintData.bones) {
            this.bones.add(skeleton.findBone(boneData.name));
        }
        this.target = skeleton.findBone(ikConstraintData.target.name);
    }

    public IkConstraint(IkConstraint ikConstraint, Skeleton skeleton) {
        if (ikConstraint == null) {
            throw new IllegalArgumentException("constraint cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = ikConstraint.data;
        this.bones = new Array(ikConstraint.bones.size);
        for (Bone bone : ikConstraint.bones) {
            this.bones.add(skeleton.bones.get(bone.data.index));
        }
        this.target = skeleton.bones.get(ikConstraint.target.data.index);
        this.mix = ikConstraint.mix;
        this.bendDirection = ikConstraint.bendDirection;
    }

    public void apply() {
        this.update();
    }

    @Override
    public void update() {
        Bone bone = this.target;
        Array<Bone> array = this.bones;
        switch (array.size) {
            case 1: {
                IkConstraint.apply(array.first(), bone.worldX, bone.worldY, this.mix);
                break;
            }
            case 2: {
                IkConstraint.apply(array.first(), array.get(1), bone.worldX, bone.worldY, this.bendDirection, this.mix);
            }
        }
    }

    @Override
    public int getOrder() {
        return this.data.order;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getTarget() {
        return this.target;
    }

    public void setTarget(Bone bone) {
        this.target = bone;
    }

    public float getMix() {
        return this.mix;
    }

    public void setMix(float f) {
        this.mix = f;
    }

    public int getBendDirection() {
        return this.bendDirection;
    }

    public void setBendDirection(int n) {
        this.bendDirection = n;
    }

    public IkConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }

    public static void apply(Bone bone, float f, float f2, float f3) {
        if (!bone.appliedValid) {
            bone.updateAppliedTransform();
        }
        Bone bone2 = bone.parent;
        float f4 = 1.0f / (bone2.a * bone2.d - bone2.b * bone2.c);
        float f5 = f - bone2.worldX;
        float f6 = f2 - bone2.worldY;
        float f7 = (f5 * bone2.d - f6 * bone2.b) * f4 - bone.ax;
        float f8 = (f6 * bone2.a - f5 * bone2.c) * f4 - bone.ay;
        float f9 = TrigUtils.atan2(f8, f7) * 57.295776f - bone.ashearX - bone.arotation;
        if (bone.ascaleX < 0.0f) {
            f9 += 180.0f;
        }
        if (f9 > 180.0f) {
            f9 -= 360.0f;
        } else if (f9 < -180.0f) {
            f9 += 360.0f;
        }
        bone.updateWorldTransform(bone.ax, bone.ay, bone.arotation + f9 * f3, bone.ascaleX, bone.ascaleY, bone.ashearX, bone.ashearY);
    }

    /*
     * Unable to fully structure code
     */
    public static void apply(Bone var0, Bone var1_1, float var2_2, float var3_3, int var4_4, float var5_5) {
        block29: {
            block28: {
                if (var5_5 == 0.0f) {
                    var1_1.updateWorldTransform();
                    return;
                }
                if (!var0.appliedValid) {
                    var0.updateAppliedTransform();
                }
                if (!var1_1.appliedValid) {
                    var1_1.updateAppliedTransform();
                }
                var6_6 = var0.ax;
                var7_7 = var0.ay;
                var8_8 = var0.ascaleX;
                var9_9 = var0.ascaleY;
                var10_10 = var1_1.ascaleX;
                if (var8_8 < 0.0f) {
                    var8_8 = -var8_8;
                    var11_11 = 180;
                    var13_12 = -1;
                } else {
                    var11_11 = 0;
                    var13_12 = 1;
                }
                if (var9_9 < 0.0f) {
                    var9_9 = -var9_9;
                    var13_12 = -var13_12;
                }
                if (var10_10 < 0.0f) {
                    var10_10 = -var10_10;
                    var12_13 = 180;
                } else {
                    var12_13 = 0;
                }
                var14_14 = var1_1.ax;
                var18_15 = var0.a;
                var19_16 = var0.b;
                var20_17 = var0.c;
                var21_18 = var0.d;
                v0 = var22_19 = Math.abs(var8_8 - var9_9) <= 1.0E-4f;
                if (!var22_19) {
                    var15_20 = 0.0f;
                    var16_21 = var18_15 * var14_14 + var0.worldX;
                    var17_22 = var20_17 * var14_14 + var0.worldY;
                } else {
                    var15_20 = var1_1.ay;
                    var16_21 = var18_15 * var14_14 + var19_16 * var15_20 + var0.worldX;
                    var17_22 = var20_17 * var14_14 + var21_18 * var15_20 + var0.worldY;
                }
                var23_23 = var0.parent;
                var18_15 = var23_23.a;
                var19_16 = var23_23.b;
                var20_17 = var23_23.c;
                var21_18 = var23_23.d;
                var24_24 = 1.0f / (var18_15 * var21_18 - var19_16 * var20_17);
                var25_25 = var2_2 - var23_23.worldX;
                var26_26 = var3_3 - var23_23.worldY;
                var27_27 = (var25_25 * var21_18 - var26_26 * var19_16) * var24_24 - var6_6;
                var28_28 = (var26_26 * var18_15 - var25_25 * var20_17) * var24_24 - var7_7;
                var25_25 = var16_21 - var23_23.worldX;
                var26_26 = var17_22 - var23_23.worldY;
                var29_29 = (var25_25 * var21_18 - var26_26 * var19_16) * var24_24 - var6_6;
                var30_30 = (var26_26 * var18_15 - var25_25 * var20_17) * var24_24 - var7_7;
                var31_31 = (float)Math.sqrt(var29_29 * var29_29 + var30_30 * var30_30);
                var32_32 = var1_1.data.length * var10_10;
                if (!var22_19) break block28;
                if ((var35_33 = (var27_27 * var27_27 + var28_28 * var28_28 - var31_31 * var31_31 - (var32_32 *= var8_8) * var32_32) / (2.0f * var31_31 * var32_32)) < -1.0f) {
                    var35_33 = -1.0f;
                } else if (var35_33 > 1.0f) {
                    var35_33 = 1.0f;
                }
                var34_34 = (float)Math.acos(var35_33) * (float)var4_4;
                var18_15 = var31_31 + var32_32 * var35_33;
                var19_16 = var32_32 * TrigUtils.sin(var34_34);
                var33_35 = TrigUtils.atan2(var28_28 * var18_15 - var27_27 * var19_16, var27_27 * var18_15 + var28_28 * var19_16);
                break block29;
            }
            var18_15 = var8_8 * var32_32;
            var19_16 = var9_9 * var32_32;
            var35_33 = var18_15 * var18_15;
            var36_36 = var19_16 * var19_16;
            var37_37 = var27_27 * var27_27 + var28_28 * var28_28;
            var38_38 = TrigUtils.atan2(var28_28, var27_27);
            var39_39 = -2.0f * var36_36 * var31_31;
            var40_40 = var36_36 - var35_33;
            var20_17 = var36_36 * var31_31 * var31_31 + var35_33 * var37_37 - var35_33 * var36_36;
            var21_18 = var39_39 * var39_39 - 4.0f * var40_40 * var20_17;
            if (!(var21_18 >= 0.0f)) ** GOTO lbl-1000
            var41_41 = (float)Math.sqrt(var21_18);
            if (var39_39 < 0.0f) {
                var41_41 = -var41_41;
            }
            var41_41 = -(var39_39 + var41_41) / 2.0f;
            var42_42 = var41_41 / var40_40;
            var43_43 = var20_17 / var41_41;
            v1 = var44_44 = Math.abs(var42_42) < Math.abs(var43_43) ? var42_42 : var43_43;
            if (var44_44 * var44_44 <= var37_37) {
                var26_26 = (float)Math.sqrt(var37_37 - var44_44 * var44_44) * (float)var4_4;
                var33_35 = var38_38 - TrigUtils.atan2(var26_26, var44_44);
                var34_34 = TrigUtils.atan2(var26_26 / var9_9, (var44_44 - var31_31) / var8_8);
            } else lbl-1000:
            // 2 sources

            {
                var41_41 = 0.0f;
                var42_42 = 3.4028235E38f;
                var43_43 = 0.0f;
                var44_44 = 0.0f;
                var45_45 = 0.0f;
                var46_46 = 0.0f;
                var47_47 = 0.0f;
                var48_48 = 0.0f;
                var25_25 = var31_31 + var18_15;
                var21_18 = var25_25 * var25_25;
                if (var21_18 > var46_46) {
                    var45_45 = 0.0f;
                    var46_46 = var21_18;
                    var47_47 = var25_25;
                }
                if ((var21_18 = (var25_25 = var31_31 - var18_15) * var25_25) < var42_42) {
                    var41_41 = 3.1415927f;
                    var42_42 = var21_18;
                    var43_43 = var25_25;
                }
                if ((var21_18 = (var25_25 = var18_15 * TrigUtils.cos(var49_49 = (float)Math.acos(-var18_15 * var31_31 / (var35_33 - var36_36))) + var31_31) * var25_25 + (var26_26 = var19_16 * TrigUtils.sin(var49_49)) * var26_26) < var42_42) {
                    var41_41 = var49_49;
                    var42_42 = var21_18;
                    var43_43 = var25_25;
                    var44_44 = var26_26;
                }
                if (var21_18 > var46_46) {
                    var45_45 = var49_49;
                    var46_46 = var21_18;
                    var47_47 = var25_25;
                    var48_48 = var26_26;
                }
                if (var37_37 <= (var42_42 + var46_46) / 2.0f) {
                    var33_35 = var38_38 - TrigUtils.atan2(var44_44 * (float)var4_4, var43_43);
                    var34_34 = var41_41 * (float)var4_4;
                } else {
                    var33_35 = var38_38 - TrigUtils.atan2(var48_48 * (float)var4_4, var47_47);
                    var34_34 = var45_45 * (float)var4_4;
                }
            }
        }
        var35_33 = TrigUtils.atan2(var15_20, var14_14) * (float)var13_12;
        var36_36 = var0.arotation;
        var33_35 = (var33_35 - var35_33) * 57.295776f + (float)var11_11 - var36_36;
        if (var33_35 > 180.0f) {
            var33_35 -= 360.0f;
        } else if (var33_35 < -180.0f) {
            var33_35 += 360.0f;
        }
        var0.updateWorldTransform(var6_6, var7_7, var36_36 + var33_35 * var5_5, var0.ascaleX, var0.ascaleY, 0.0f, 0.0f);
        var36_36 = var1_1.arotation;
        var34_34 = ((var34_34 + var35_33) * 57.295776f - var1_1.ashearX) * (float)var13_12 + (float)var12_13 - var36_36;
        if (var34_34 > 180.0f) {
            var34_34 -= 360.0f;
        } else if (var34_34 < -180.0f) {
            var34_34 += 360.0f;
        }
        var1_1.updateWorldTransform(var14_14, var15_20, var36_36 + var34_34 * var5_5, var1_1.ascaleX, var1_1.ascaleY, var1_1.ashearX, var1_1.ashearY);
    }
}

