/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;

public class Animation {
    final String name;
    final Array<Timeline> timelines;
    float duration;

    public Animation(String string, Array<Timeline> array, float f) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (array == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.name = string;
        this.timelines = array;
        this.duration = f;
    }

    public Array<Timeline> getTimelines() {
        return this.timelines;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float f) {
        this.duration = f;
    }

    public void apply(Skeleton skeleton, float f, float f2, boolean bl, Array<Event> array, float f3, boolean bl2, boolean bl3) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (bl && this.duration != 0.0f) {
            f2 %= this.duration;
            if (f > 0.0f) {
                f %= this.duration;
            }
        }
        Array<Timeline> array2 = this.timelines;
        int n = array2.size;
        for (int i = 0; i < n; ++i) {
            array2.get(i).apply(skeleton, f, f2, array, f3, bl2, bl3);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static int binarySearch(float[] fArray, float f, int n) {
        int n2 = 0;
        int n3 = fArray.length / n - 2;
        if (n3 == 0) {
            return n;
        }
        int n4 = n3 >>> 1;
        while (true) {
            if (fArray[(n4 + 1) * n] <= f) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            if (n2 == n3) {
                return (n2 + 1) * n;
            }
            n4 = n2 + n3 >>> 1;
        }
    }

    static int binarySearch(float[] fArray, float f) {
        int n = 0;
        int n2 = fArray.length - 2;
        if (n2 == 0) {
            return 1;
        }
        int n3 = n2 >>> 1;
        while (true) {
            if (fArray[n3 + 1] <= f) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            if (n == n2) {
                return n + 1;
            }
            n3 = n + n2 >>> 1;
        }
    }

    static int linearSearch(float[] fArray, float f, int n) {
        int n2 = fArray.length - n;
        for (int i = 0; i <= n2; i += n) {
            if (!(fArray[i] > f)) continue;
            return i;
        }
        return -1;
    }

    public static class PathConstraintMixTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 3;
        private static final int PREV_TIME = -3;
        private static final int PREV_ROTATE = -2;
        private static final int PREV_TRANSLATE = -1;
        private static final int ROTATE = 1;
        private static final int TRANSLATE = 2;
        int pathConstraintIndex;
        private final float[] frames;

        public PathConstraintMixTimeline(int n) {
            super(n);
            this.frames = new float[n * 3];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.pathConstraintMix.ordinal() << 24) + this.pathConstraintIndex;
        }

        public void setPathConstraintIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.pathConstraintIndex = n;
        }

        public int getPathConstraintIndex() {
            return this.pathConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            float f5;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    pathConstraint.rotateMix = pathConstraint.data.rotateMix;
                    pathConstraint.translateMix = pathConstraint.data.translateMix;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f5 = fArray[fArray.length + -2];
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f6 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f6) / (fArray[n + -3] - f6));
                f5 += (fArray[n + 1] - f5) * f7;
                f4 += (fArray[n + 2] - f4) * f7;
            }
            if (bl) {
                pathConstraint.rotateMix = pathConstraint.data.rotateMix + (f5 - pathConstraint.data.rotateMix) * f3;
                pathConstraint.translateMix = pathConstraint.data.translateMix + (f4 - pathConstraint.data.translateMix) * f3;
            } else {
                pathConstraint.rotateMix += (f5 - pathConstraint.rotateMix) * f3;
                pathConstraint.translateMix += (f4 - pathConstraint.translateMix) * f3;
            }
        }
    }

    public static class PathConstraintSpacingTimeline
    extends PathConstraintPositionTimeline {
        public PathConstraintSpacingTimeline(int n) {
            super(n);
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.pathConstraintSpacing.ordinal() << 24) + this.pathConstraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    pathConstraint.spacing = pathConstraint.data.spacing;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 2]) {
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 2);
                f4 = fArray[n + -1];
                float f5 = fArray[n];
                float f6 = this.getCurvePercent(n / 2 - 1, 1.0f - (f2 - f5) / (fArray[n + -2] - f5));
                f4 += (fArray[n + 1] - f4) * f6;
            }
            pathConstraint.spacing = bl ? pathConstraint.data.spacing + (f4 - pathConstraint.data.spacing) * f3 : (pathConstraint.spacing += (f4 - pathConstraint.spacing) * f3);
        }
    }

    public static class PathConstraintPositionTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 2;
        static final int PREV_TIME = -2;
        static final int PREV_VALUE = -1;
        static final int VALUE = 1;
        int pathConstraintIndex;
        final float[] frames;

        public PathConstraintPositionTimeline(int n) {
            super(n);
            this.frames = new float[n * 2];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.pathConstraintPosition.ordinal() << 24) + this.pathConstraintIndex;
        }

        public void setPathConstraintIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.pathConstraintIndex = n;
        }

        public int getPathConstraintIndex() {
            return this.pathConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2) {
            this.frames[n *= 2] = f;
            this.frames[n + 1] = f2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            PathConstraint pathConstraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    pathConstraint.position = pathConstraint.data.position;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 2]) {
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 2);
                f4 = fArray[n + -1];
                float f5 = fArray[n];
                float f6 = this.getCurvePercent(n / 2 - 1, 1.0f - (f2 - f5) / (fArray[n + -2] - f5));
                f4 += (fArray[n + 1] - f4) * f6;
            }
            pathConstraint.position = bl ? pathConstraint.data.position + (f4 - pathConstraint.data.position) * f3 : (pathConstraint.position += (f4 - pathConstraint.position) * f3);
        }
    }

    public static class TransformConstraintTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 5;
        private static final int PREV_TIME = -5;
        private static final int PREV_ROTATE = -4;
        private static final int PREV_TRANSLATE = -3;
        private static final int PREV_SCALE = -2;
        private static final int PREV_SHEAR = -1;
        private static final int ROTATE = 1;
        private static final int TRANSLATE = 2;
        private static final int SCALE = 3;
        private static final int SHEAR = 4;
        int transformConstraintIndex;
        private final float[] frames;

        public TransformConstraintTimeline(int n) {
            super(n);
            this.frames = new float[n * 5];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.transformConstraint.ordinal() << 24) + this.transformConstraintIndex;
        }

        public void setTransformConstraintIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.transformConstraintIndex = n;
        }

        public int getTransformConstraintIndex() {
            return this.transformConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5) {
            this.frames[n *= 5] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n;
            TransformConstraint transformConstraint = skeleton.transformConstraints.get(this.transformConstraintIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    TransformConstraintData transformConstraintData = transformConstraint.data;
                    transformConstraint.rotateMix = transformConstraintData.rotateMix;
                    transformConstraint.translateMix = transformConstraintData.translateMix;
                    transformConstraint.scaleMix = transformConstraintData.scaleMix;
                    transformConstraint.shearMix = transformConstraintData.shearMix;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 5]) {
                n = fArray.length;
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
            } else {
                n = Animation.binarySearch(fArray, f2, 5);
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f8 = fArray[n];
                float f9 = this.getCurvePercent(n / 5 - 1, 1.0f - (f2 - f8) / (fArray[n + -5] - f8));
                f7 += (fArray[n + 1] - f7) * f9;
                f6 += (fArray[n + 2] - f6) * f9;
                f5 += (fArray[n + 3] - f5) * f9;
                f4 += (fArray[n + 4] - f4) * f9;
            }
            if (bl) {
                TransformConstraintData transformConstraintData = transformConstraint.data;
                transformConstraint.rotateMix = transformConstraintData.rotateMix + (f7 - transformConstraintData.rotateMix) * f3;
                transformConstraint.translateMix = transformConstraintData.translateMix + (f6 - transformConstraintData.translateMix) * f3;
                transformConstraint.scaleMix = transformConstraintData.scaleMix + (f5 - transformConstraintData.scaleMix) * f3;
                transformConstraint.shearMix = transformConstraintData.shearMix + (f4 - transformConstraintData.shearMix) * f3;
            } else {
                transformConstraint.rotateMix += (f7 - transformConstraint.rotateMix) * f3;
                transformConstraint.translateMix += (f6 - transformConstraint.translateMix) * f3;
                transformConstraint.scaleMix += (f5 - transformConstraint.scaleMix) * f3;
                transformConstraint.shearMix += (f4 - transformConstraint.shearMix) * f3;
            }
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 3;
        private static final int PREV_TIME = -3;
        private static final int PREV_MIX = -2;
        private static final int PREV_BEND_DIRECTION = -1;
        private static final int MIX = 1;
        private static final int BEND_DIRECTION = 2;
        int ikConstraintIndex;
        private final float[] frames;

        public IkConstraintTimeline(int n) {
            super(n);
            this.frames = new float[n * 3];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.ikConstraint.ordinal() << 24) + this.ikConstraintIndex;
        }

        public void setIkConstraintIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.ikConstraintIndex = n;
        }

        public int getIkConstraintIndex() {
            return this.ikConstraintIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, int n2) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = n2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            IkConstraint ikConstraint = skeleton.ikConstraints.get(this.ikConstraintIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    ikConstraint.mix = ikConstraint.data.mix;
                    ikConstraint.bendDirection = ikConstraint.data.bendDirection;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                if (bl) {
                    ikConstraint.mix = ikConstraint.data.mix + (fArray[fArray.length + -2] - ikConstraint.data.mix) * f3;
                    ikConstraint.bendDirection = bl2 ? ikConstraint.data.bendDirection : (int)fArray[fArray.length + -1];
                } else {
                    ikConstraint.mix += (fArray[fArray.length + -2] - ikConstraint.mix) * f3;
                    if (!bl2) {
                        ikConstraint.bendDirection = (int)fArray[fArray.length + -1];
                    }
                }
                return;
            }
            int n = Animation.binarySearch(fArray, f2, 3);
            float f4 = fArray[n + -2];
            float f5 = fArray[n];
            float f6 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f5) / (fArray[n + -3] - f5));
            if (bl) {
                ikConstraint.mix = ikConstraint.data.mix + (f4 + (fArray[n + 1] - f4) * f6 - ikConstraint.data.mix) * f3;
                ikConstraint.bendDirection = bl2 ? ikConstraint.data.bendDirection : (int)fArray[n + -1];
            } else {
                ikConstraint.mix += (f4 + (fArray[n + 1] - f4) * f6 - ikConstraint.mix) * f3;
                if (!bl2) {
                    ikConstraint.bendDirection = (int)fArray[n + -1];
                }
            }
        }
    }

    public static class DrawOrderTimeline
    implements Timeline {
        private final float[] frames;
        private final int[][] drawOrders;

        public DrawOrderTimeline(int n) {
            this.frames = new float[n];
            this.drawOrders = new int[n][];
        }

        @Override
        public int getPropertyId() {
            return TimelineType.drawOrder.ordinal() << 24;
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public int[][] getDrawOrders() {
            return this.drawOrders;
        }

        public void setFrame(int n, float f, int[] nArray) {
            this.frames[n] = f;
            this.drawOrders[n] = nArray;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            Array<Slot> array2 = skeleton.drawOrder;
            Array<Slot> array3 = skeleton.slots;
            if (bl2 && bl) {
                System.arraycopy(array3.items, 0, array2.items, 0, array3.size);
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    System.arraycopy(array3.items, 0, array2.items, 0, array3.size);
                }
                return;
            }
            int n = f2 >= fArray[fArray.length - 1] ? fArray.length - 1 : Animation.binarySearch(fArray, f2) - 1;
            int[] nArray = this.drawOrders[n];
            if (nArray == null) {
                System.arraycopy(array3.items, 0, array2.items, 0, array3.size);
            } else {
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    array2.set(i, array3.get(nArray[i]));
                }
            }
        }
    }

    public static class EventTimeline
    implements Timeline {
        private final float[] frames;
        private final Event[] events;

        public EventTimeline(int n) {
            this.frames = new float[n];
            this.events = new Event[n];
        }

        @Override
        public int getPropertyId() {
            return TimelineType.event.ordinal() << 24;
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public Event[] getEvents() {
            return this.events;
        }

        public void setFrame(int n, Event event) {
            this.frames[n] = event.time;
            this.events[n] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            int n;
            if (array == null) {
                return;
            }
            float[] fArray = this.frames;
            int n2 = fArray.length;
            if (f > f2) {
                this.apply(skeleton, f, 2.1474836E9f, array, f3, bl, bl2);
                f = -1.0f;
            } else if (f >= fArray[n2 - 1]) {
                return;
            }
            if (f2 < fArray[0]) {
                return;
            }
            if (f < fArray[0]) {
                n = 0;
            } else {
                float f4 = fArray[n];
                for (n = Animation.binarySearch(fArray, f); n > 0 && fArray[n - 1] == f4; --n) {
                }
            }
            while (n < n2 && f2 >= fArray[n]) {
                array.add(this.events[n]);
                ++n;
            }
        }
    }

    public static class DeformTimeline
    extends CurveTimeline {
        int slotIndex;
        VertexAttachment attachment;
        private final float[] frames;
        private final float[][] frameVertices;

        public DeformTimeline(int n) {
            super(n);
            this.frames = new float[n];
            this.frameVertices = new float[n][];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.deform.ordinal() << 24) + this.slotIndex;
        }

        public void setSlotIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.slotIndex = n;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setAttachment(VertexAttachment vertexAttachment) {
            this.attachment = vertexAttachment;
        }

        public VertexAttachment getAttachment() {
            return this.attachment;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public float[][] getVertices() {
            return this.frameVertices;
        }

        public void setFrame(int n, float f, float[] fArray) {
            this.frames[n] = f;
            this.frameVertices[n] = fArray;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            Attachment attachment = slot.attachment;
            if (!(attachment instanceof VertexAttachment) || !((VertexAttachment)attachment).applyDeform(this.attachment)) {
                return;
            }
            FloatArray floatArray = slot.getAttachmentVertices();
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    floatArray.size = 0;
                }
                return;
            }
            float[][] fArray2 = this.frameVertices;
            int n = fArray2[0].length;
            if (floatArray.size != n) {
                f3 = 1.0f;
            }
            float[] fArray3 = floatArray.setSize(n);
            if (f2 >= fArray[fArray.length - 1]) {
                float[] fArray4 = fArray2[fArray.length - 1];
                if (f3 == 1.0f) {
                    System.arraycopy(fArray4, 0, fArray3, 0, n);
                } else if (bl) {
                    VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                    if (vertexAttachment.getBones() == null) {
                        float[] fArray5 = vertexAttachment.getVertices();
                        for (int i = 0; i < n; ++i) {
                            float f4 = fArray5[i];
                            fArray3[i] = f4 + (fArray4[i] - f4) * f3;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            fArray3[i] = fArray4[i] * f3;
                        }
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        int n2 = i;
                        fArray3[n2] = fArray3[n2] + (fArray4[i] - fArray3[i]) * f3;
                    }
                }
                return;
            }
            int n3 = Animation.binarySearch(fArray, f2);
            float[] fArray6 = fArray2[n3 - 1];
            float[] fArray7 = fArray2[n3];
            float f5 = fArray[n3];
            float f6 = this.getCurvePercent(n3 - 1, 1.0f - (f2 - f5) / (fArray[n3 - 1] - f5));
            if (f3 == 1.0f) {
                for (int i = 0; i < n; ++i) {
                    float f7 = fArray6[i];
                    fArray3[i] = f7 + (fArray7[i] - f7) * f6;
                }
            } else if (bl) {
                VertexAttachment vertexAttachment = (VertexAttachment)attachment;
                if (vertexAttachment.getBones() == null) {
                    float[] fArray8 = vertexAttachment.getVertices();
                    for (int i = 0; i < n; ++i) {
                        float f8 = fArray6[i];
                        float f9 = fArray8[i];
                        fArray3[i] = f9 + (f8 + (fArray7[i] - f8) * f6 - f9) * f3;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float f10 = fArray6[i];
                        fArray3[i] = (f10 + (fArray7[i] - f10) * f6) * f3;
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    float f11 = fArray6[i];
                    int n4 = i;
                    fArray3[n4] = fArray3[n4] + (f11 + (fArray7[i] - f11) * f6 - fArray3[i]) * f3;
                }
            }
        }
    }

    public static class AttachmentTimeline
    implements Timeline {
        int slotIndex;
        final float[] frames;
        final String[] attachmentNames;

        public AttachmentTimeline(int n) {
            this.frames = new float[n];
            this.attachmentNames = new String[n];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.attachment.ordinal() << 24) + this.slotIndex;
        }

        public int getFrameCount() {
            return this.frames.length;
        }

        public void setSlotIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.slotIndex = n;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public String[] getAttachmentNames() {
            return this.attachmentNames;
        }

        public void setFrame(int n, float f, String string) {
            this.frames[n] = f;
            this.attachmentNames[n] = string;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (bl2 && bl) {
                String string = slot.data.attachmentName;
                slot.setAttachment(string == null ? null : skeleton.getAttachment(this.slotIndex, string));
                return;
            }
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    String string = slot.data.attachmentName;
                    slot.setAttachment(string == null ? null : skeleton.getAttachment(this.slotIndex, string));
                }
                return;
            }
            int n = f2 >= fArray[fArray.length - 1] ? fArray.length - 1 : Animation.binarySearch(fArray, f2) - 1;
            String string = this.attachmentNames[n];
            slot.setAttachment(string == null ? null : skeleton.getAttachment(this.slotIndex, string));
        }
    }

    public static class ColorTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 5;
        private static final int PREV_TIME = -5;
        private static final int PREV_R = -4;
        private static final int PREV_G = -3;
        private static final int PREV_B = -2;
        private static final int PREV_A = -1;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        private static final int A = 4;
        int slotIndex;
        private final float[] frames;

        public ColorTimeline(int n) {
            super(n);
            this.frames = new float[n * 5];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.color.ordinal() << 24) + this.slotIndex;
        }

        public void setSlotIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.slotIndex = n;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3, float f4, float f5) {
            this.frames[n *= 5] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
            this.frames[n + 3] = f4;
            this.frames[n + 4] = f5;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n;
            Slot slot = skeleton.slots.get(this.slotIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    slot.color.set(slot.data.color);
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 5]) {
                n = fArray.length;
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
            } else {
                n = Animation.binarySearch(fArray, f2, 5);
                f7 = fArray[n + -4];
                f6 = fArray[n + -3];
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f8 = fArray[n];
                float f9 = this.getCurvePercent(n / 5 - 1, 1.0f - (f2 - f8) / (fArray[n + -5] - f8));
                f7 += (fArray[n + 1] - f7) * f9;
                f6 += (fArray[n + 2] - f6) * f9;
                f5 += (fArray[n + 3] - f5) * f9;
                f4 += (fArray[n + 4] - f4) * f9;
            }
            if (f3 == 1.0f) {
                slot.color.set(f7, f6, f5, f4);
            } else {
                Color color = slot.color;
                if (bl) {
                    color.set(slot.data.color);
                }
                color.add((f7 - color.r) * f3, (f6 - color.g) * f3, (f5 - color.b) * f3, (f4 - color.a) * f3);
            }
        }
    }

    public static class ShearTimeline
    extends TranslateTimeline {
        public ShearTimeline(int n) {
            super(n);
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.shear.ordinal() << 24) + this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            float f5;
            Bone bone = skeleton.bones.get(this.boneIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    bone.shearX = bone.data.shearX;
                    bone.shearY = bone.data.shearY;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f5 = fArray[fArray.length + -2];
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f6 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f6) / (fArray[n + -3] - f6));
                f5 += (fArray[n + 1] - f5) * f7;
                f4 += (fArray[n + 2] - f4) * f7;
            }
            if (bl) {
                bone.shearX = bone.data.shearX + f5 * f3;
                bone.shearY = bone.data.shearY + f4 * f3;
            } else {
                bone.shearX += (bone.data.shearX + f5 - bone.shearX) * f3;
                bone.shearY += (bone.data.shearY + f4 - bone.shearY) * f3;
            }
        }
    }

    public static class ScaleTimeline
    extends TranslateTimeline {
        public ScaleTimeline(int n) {
            super(n);
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.scale.ordinal() << 24) + this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            float f5;
            float f6;
            Bone bone = skeleton.bones.get(this.boneIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    bone.scaleX = bone.data.scaleX;
                    bone.scaleY = bone.data.scaleY;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f6 = fArray[fArray.length + -2] * bone.data.scaleX;
                f5 = fArray[fArray.length + -1] * bone.data.scaleY;
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f6 = fArray[n + -2];
                f5 = fArray[n + -1];
                f4 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f4) / (fArray[n + -3] - f4));
                f6 = (f6 + (fArray[n + 1] - f6) * f7) * bone.data.scaleX;
                f5 = (f5 + (fArray[n + 2] - f5) * f7) * bone.data.scaleY;
            }
            if (f3 == 1.0f) {
                bone.scaleX = f6;
                bone.scaleY = f5;
            } else {
                float f8;
                if (bl) {
                    f8 = bone.data.scaleX;
                    f4 = bone.data.scaleY;
                } else {
                    f8 = bone.scaleX;
                    f4 = bone.scaleY;
                }
                if (bl2) {
                    f6 = Math.abs(f6) * Math.signum(f8);
                    f5 = Math.abs(f5) * Math.signum(f4);
                } else {
                    f8 = Math.abs(f8) * Math.signum(f6);
                    f4 = Math.abs(f4) * Math.signum(f5);
                }
                bone.scaleX = f8 + (f6 - f8) * f3;
                bone.scaleY = f4 + (f5 - f4) * f3;
            }
        }
    }

    public static class TranslateTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 3;
        static final int PREV_TIME = -3;
        static final int PREV_X = -2;
        static final int PREV_Y = -1;
        static final int X = 1;
        static final int Y = 2;
        int boneIndex;
        final float[] frames;

        public TranslateTimeline(int n) {
            super(n);
            this.frames = new float[n * 3];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.translate.ordinal() << 24) + this.boneIndex;
        }

        public void setBoneIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.boneIndex = n;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2, float f3) {
            this.frames[n *= 3] = f;
            this.frames[n + 1] = f2;
            this.frames[n + 2] = f3;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            float f4;
            float f5;
            Bone bone = skeleton.bones.get(this.boneIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    bone.x = bone.data.x;
                    bone.y = bone.data.y;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 3]) {
                f5 = fArray[fArray.length + -2];
                f4 = fArray[fArray.length + -1];
            } else {
                int n = Animation.binarySearch(fArray, f2, 3);
                f5 = fArray[n + -2];
                f4 = fArray[n + -1];
                float f6 = fArray[n];
                float f7 = this.getCurvePercent(n / 3 - 1, 1.0f - (f2 - f6) / (fArray[n + -3] - f6));
                f5 += (fArray[n + 1] - f5) * f7;
                f4 += (fArray[n + 2] - f4) * f7;
            }
            if (bl) {
                bone.x = bone.data.x + f5 * f3;
                bone.y = bone.data.y + f4 * f3;
            } else {
                bone.x += (bone.data.x + f5 - bone.x) * f3;
                bone.y += (bone.data.y + f4 - bone.y) * f3;
            }
        }
    }

    public static class RotateTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 2;
        static final int PREV_TIME = -2;
        static final int PREV_ROTATION = -1;
        static final int ROTATION = 1;
        int boneIndex;
        final float[] frames;

        public RotateTimeline(int n) {
            super(n);
            this.frames = new float[n << 1];
        }

        @Override
        public int getPropertyId() {
            return (TimelineType.rotate.ordinal() << 24) + this.boneIndex;
        }

        public void setBoneIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("index must be >= 0.");
            }
            this.boneIndex = n;
        }

        public int getBoneIndex() {
            return this.boneIndex;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public void setFrame(int n, float f, float f2) {
            this.frames[n <<= 1] = f;
            this.frames[n + 1] = f2;
        }

        @Override
        public void apply(Skeleton skeleton, float f, float f2, Array<Event> array, float f3, boolean bl, boolean bl2) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            float[] fArray = this.frames;
            if (f2 < fArray[0]) {
                if (bl) {
                    bone.rotation = bone.data.rotation;
                }
                return;
            }
            if (f2 >= fArray[fArray.length - 2]) {
                if (bl) {
                    bone.rotation = bone.data.rotation + fArray[fArray.length + -1] * f3;
                } else {
                    float f4 = bone.data.rotation + fArray[fArray.length + -1] - bone.rotation;
                    f4 -= (float)((16384 - (int)(16384.499999999996 - (double)(f4 / 360.0f))) * 360);
                    bone.rotation += f4 * f3;
                }
                return;
            }
            int n = Animation.binarySearch(fArray, f2, 2);
            float f5 = fArray[n + -1];
            float f6 = fArray[n];
            float f7 = this.getCurvePercent((n >> 1) - 1, 1.0f - (f2 - f6) / (fArray[n + -2] - f6));
            float f8 = fArray[n + 1] - f5;
            f8 -= (float)((16384 - (int)(16384.499999999996 - (double)(f8 / 360.0f))) * 360);
            f8 = f5 + f8 * f7;
            if (bl) {
                f8 -= (float)((16384 - (int)(16384.499999999996 - (double)(f8 / 360.0f))) * 360);
                bone.rotation = bone.data.rotation + f8 * f3;
            } else {
                f8 = bone.data.rotation + f8 - bone.rotation;
                f8 -= (float)((16384 - (int)(16384.499999999996 - (double)(f8 / 360.0f))) * 360);
                bone.rotation += f8 * f3;
            }
        }
    }

    public static abstract class CurveTimeline
    implements Timeline {
        public static final float LINEAR = 0.0f;
        public static final float STEPPED = 1.0f;
        public static final float BEZIER = 2.0f;
        private static final int BEZIER_SIZE = 19;
        private final float[] curves;

        public CurveTimeline(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("frameCount must be > 0: " + n);
            }
            this.curves = new float[(n - 1) * 19];
        }

        public int getFrameCount() {
            return this.curves.length / 19 + 1;
        }

        public void setLinear(int n) {
            this.curves[n * 19] = 0.0f;
        }

        public void setStepped(int n) {
            this.curves[n * 19] = 1.0f;
        }

        public float getCurveType(int n) {
            int n2 = n * 19;
            if (n2 == this.curves.length) {
                return 0.0f;
            }
            float f = this.curves[n2];
            if (f == 0.0f) {
                return 0.0f;
            }
            if (f == 1.0f) {
                return 1.0f;
            }
            return 2.0f;
        }

        public void setCurve(int n, float f, float f2, float f3, float f4) {
            float f5 = (-f * 2.0f + f3) * 0.03f;
            float f6 = (-f2 * 2.0f + f4) * 0.03f;
            float f7 = ((f - f3) * 3.0f + 1.0f) * 0.006f;
            float f8 = ((f2 - f4) * 3.0f + 1.0f) * 0.006f;
            float f9 = f5 * 2.0f + f7;
            float f10 = f6 * 2.0f + f8;
            float f11 = f * 0.3f + f5 + f7 * 0.16666667f;
            float f12 = f2 * 0.3f + f6 + f8 * 0.16666667f;
            int n2 = n * 19;
            float[] fArray = this.curves;
            fArray[n2++] = 2.0f;
            float f13 = f11;
            float f14 = f12;
            int n3 = n2 + 19 - 1;
            while (n2 < n3) {
                fArray[n2] = f13;
                fArray[n2 + 1] = f14;
                f13 += (f11 += (f9 += f7));
                f14 += (f12 += (f10 += f8));
                n2 += 2;
            }
        }

        public float getCurvePercent(int n, float f) {
            f = MathUtils.clamp(f, 0.0f, 1.0f);
            float[] fArray = this.curves;
            int n2 = n * 19;
            float f2 = fArray[n2];
            if (f2 == 0.0f) {
                return f;
            }
            if (f2 == 1.0f) {
                return 0.0f;
            }
            float f3 = 0.0f;
            int n3 = ++n2;
            int n4 = n2 + 19 - 1;
            while (n2 < n4) {
                f3 = fArray[n2];
                if (f3 >= f) {
                    float f4;
                    float f5;
                    if (n2 == n3) {
                        f5 = 0.0f;
                        f4 = 0.0f;
                    } else {
                        f5 = fArray[n2 - 2];
                        f4 = fArray[n2 - 1];
                    }
                    return f4 + (fArray[n2 + 1] - f4) * (f - f5) / (f3 - f5);
                }
                n2 += 2;
            }
            float f6 = fArray[n2 - 1];
            return f6 + (1.0f - f6) * (f - f3) / (1.0f - f3);
        }
    }

    private static enum TimelineType {
        rotate,
        translate,
        scale,
        shear,
        attachment,
        color,
        deform,
        event,
        drawOrder,
        ikConstraint,
        transformConstraint,
        pathConstraintPosition,
        pathConstraintSpacing,
        pathConstraintMix;

    }

    public static interface Timeline {
        public void apply(Skeleton var1, float var2, float var3, Array<Event> var4, float var5, boolean var6, boolean var7);

        public int getPropertyId();
    }
}

