/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;

public class SkinnedMeshAttachment
extends Attachment {
    private TextureRegion region;
    private String path;
    private int[] bones;
    private float[] weights;
    private float[] regionUVs;
    private short[] triangles;
    private float[] worldVertices;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private int hullLength;
    private int[] edges;
    private float width;
    private float height;

    public SkinnedMeshAttachment(String name) {
        super(name);
    }

    public void setRegion(TextureRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        this.region = region;
    }

    public TextureRegion getRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Region has not been set: " + this);
        }
        return this.region;
    }

    public void updateUVs() {
        float width;
        float height;
        float u;
        float v;
        float[] regionUVs = this.regionUVs;
        int verticesLength = regionUVs.length;
        int worldVerticesLength = verticesLength / 2 * 5;
        if (this.worldVertices == null || this.worldVertices.length != worldVerticesLength) {
            this.worldVertices = new float[worldVerticesLength];
        }
        if (this.region == null) {
            v = 0.0f;
            u = 0.0f;
            height = 1.0f;
            width = 1.0f;
        } else {
            u = this.region.getU();
            v = this.region.getV();
            width = this.region.getU2() - u;
            height = this.region.getV2() - v;
        }
        if (this.region instanceof TextureAtlas.AtlasRegion && ((TextureAtlas.AtlasRegion)this.region).rotate) {
            int i = 0;
            int w = 3;
            while (i < verticesLength) {
                this.worldVertices[w] = u + regionUVs[i + 1] * width;
                this.worldVertices[w + 1] = v + height - regionUVs[i] * height;
                i += 2;
                w += 5;
            }
        } else {
            int i = 0;
            int w = 3;
            while (i < verticesLength) {
                this.worldVertices[w] = u + regionUVs[i] * width;
                this.worldVertices[w + 1] = v + regionUVs[i + 1] * height;
                i += 2;
                w += 5;
            }
        }
    }

    public void updateWorldVertices(Slot slot, boolean premultipliedAlpha) {
        Skeleton skeleton = slot.getSkeleton();
        Color skeletonColor = skeleton.getColor();
        Color meshColor = slot.getColor();
        Color regionColor = this.color;
        float a = skeletonColor.a * meshColor.a * regionColor.a * 255.0f;
        float multiplier = premultipliedAlpha ? a : 255.0f;
        float color = NumberUtils.intToFloatColor((int)a << 24 | (int)(skeletonColor.b * meshColor.b * regionColor.b * multiplier) << 16 | (int)(skeletonColor.g * meshColor.g * regionColor.g * multiplier) << 8 | (int)(skeletonColor.r * meshColor.r * regionColor.r * multiplier));
        float[] worldVertices = this.worldVertices;
        float x = skeleton.getX();
        float y = skeleton.getY();
        T[] skeletonBones = skeleton.getBones().items;
        float[] weights = this.weights;
        int[] bones = this.bones;
        FloatArray ffdArray = slot.getAttachmentVertices();
        if (ffdArray.size == 0) {
            int w = 0;
            int v = 0;
            int b = 0;
            int n = bones.length;
            while (v < n) {
                float wx = 0.0f;
                float wy = 0.0f;
                int nn = bones[v++] + v;
                while (v < nn) {
                    Bone bone = (Bone)skeletonBones[bones[v]];
                    float vx = weights[b];
                    float vy = weights[b + 1];
                    float weight = weights[b + 2];
                    wx += (vx * bone.getM00() + vy * bone.getM01() + bone.getWorldX()) * weight;
                    wy += (vx * bone.getM10() + vy * bone.getM11() + bone.getWorldY()) * weight;
                    ++v;
                    b += 3;
                }
                worldVertices[w] = wx + x;
                worldVertices[w + 1] = wy + y;
                worldVertices[w + 2] = color;
                w += 5;
            }
        } else {
            float[] ffd = ffdArray.items;
            int w = 0;
            int v = 0;
            int b = 0;
            int f = 0;
            int n = bones.length;
            while (v < n) {
                float wx = 0.0f;
                float wy = 0.0f;
                int nn = bones[v++] + v;
                while (v < nn) {
                    Bone bone = (Bone)skeletonBones[bones[v]];
                    float vx = weights[b] + ffd[f];
                    float vy = weights[b + 1] + ffd[f + 1];
                    float weight = weights[b + 2];
                    wx += (vx * bone.getM00() + vy * bone.getM01() + bone.getWorldX()) * weight;
                    wy += (vx * bone.getM10() + vy * bone.getM11() + bone.getWorldY()) * weight;
                    ++v;
                    b += 3;
                    f += 2;
                }
                worldVertices[w] = wx + x;
                worldVertices[w + 1] = wy + y;
                worldVertices[w + 2] = color;
                w += 5;
            }
        }
    }

    public float[] getWorldVertices() {
        return this.worldVertices;
    }

    public int[] getBones() {
        return this.bones;
    }

    public void setBones(int[] bones) {
        this.bones = bones;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setWeights(float[] weights) {
        this.weights = weights;
    }

    public short[] getTriangles() {
        return this.triangles;
    }

    public void setTriangles(short[] triangles) {
        this.triangles = triangles;
    }

    public float[] getRegionUVs() {
        return this.regionUVs;
    }

    public void setRegionUVs(float[] regionUVs) {
        this.regionUVs = regionUVs;
    }

    public Color getColor() {
        return this.color;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getHullLength() {
        return this.hullLength;
    }

    public void setHullLength(int hullLength) {
        this.hullLength = hullLength;
    }

    public void setEdges(int[] edges) {
        this.edges = edges;
    }

    public int[] getEdges() {
        return this.edges;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }
}

