/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.Skeleton;

public class IkConstraint {
    private static final Vector2 temp = new Vector2();
    final IkConstraintData data;
    final Array<Bone> bones;
    Bone target;
    float mix = 1.0f;
    int bendDirection;

    public IkConstraint(IkConstraintData data, Skeleton skeleton) {
        this.data = data;
        this.mix = data.mix;
        this.bendDirection = data.bendDirection;
        this.bones = new Array(data.bones.size);
        if (skeleton != null) {
            for (BoneData boneData : data.bones) {
                this.bones.add(skeleton.findBone(boneData.name));
            }
            this.target = skeleton.findBone(data.target.name);
        }
    }

    public IkConstraint(IkConstraint ikConstraint, Array<Bone> bones, Bone target) {
        this.data = ikConstraint.data;
        this.bones = bones;
        this.target = target;
        this.mix = ikConstraint.mix;
        this.bendDirection = ikConstraint.bendDirection;
    }

    public void apply() {
        Bone target = this.target;
        Array<Bone> bones = this.bones;
        switch (bones.size) {
            case 1: {
                IkConstraint.apply(bones.first(), target.worldX, target.worldY, this.mix);
                break;
            }
            case 2: {
                IkConstraint.apply(bones.first(), bones.get(1), target.worldX, target.worldY, this.bendDirection, this.mix);
            }
        }
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Bone getTarget() {
        return this.target;
    }

    public void setTarget(Bone target) {
        this.target = target;
    }

    public float getMix() {
        return this.mix;
    }

    public void setMix(float mix) {
        this.mix = mix;
    }

    public int getBendDirection() {
        return this.bendDirection;
    }

    public void setBendDirection(int bendDirection) {
        this.bendDirection = bendDirection;
    }

    public IkConstraintData getData() {
        return this.data;
    }

    public String toString() {
        return this.data.name;
    }

    public static void apply(Bone bone, float targetX, float targetY, float alpha) {
        float parentRotation = !bone.data.inheritRotation || bone.parent == null ? 0.0f : bone.parent.worldRotation;
        float rotation = bone.rotation;
        float rotationIK = (float)Math.atan2(targetY - bone.worldY, targetX - bone.worldX) * 57.295776f - parentRotation;
        bone.rotationIK = rotation + (rotationIK - rotation) * alpha;
    }

    public static void apply(Bone parent, Bone child, float targetX, float targetY, int bendDirection, float alpha) {
        float childAngle;
        float opposite;
        float childRotation = child.rotation;
        float parentRotation = parent.rotation;
        if (alpha == 0.0f) {
            child.rotationIK = childRotation;
            parent.rotationIK = parentRotation;
            return;
        }
        Vector2 position = temp;
        Bone parentParent = parent.parent;
        if (parentParent != null) {
            parentParent.worldToLocal(position.set(targetX, targetY));
            targetX = (position.x - parent.x) * parentParent.worldScaleX;
            targetY = (position.y - parent.y) * parentParent.worldScaleY;
        } else {
            targetX -= parent.x;
            targetY -= parent.y;
        }
        if (child.parent == parent) {
            position.set(child.x, child.y);
        } else {
            parent.worldToLocal(child.parent.localToWorld(position.set(child.x, child.y)));
        }
        float childX = position.x * parent.worldScaleX;
        float childY = position.y * parent.worldScaleY;
        float offset = (float)Math.atan2(childY, childX);
        float len1 = (float)Math.sqrt(childX * childX + childY * childY);
        float len2 = child.data.length * child.worldScaleX;
        float cosDenom = 2.0f * len1 * len2;
        if (cosDenom < 1.0E-4f) {
            child.rotationIK = childRotation + ((float)Math.atan2(targetY, targetX) * 57.295776f - parentRotation - childRotation) * alpha;
            return;
        }
        float cos = MathUtils.clamp((targetX * targetX + targetY * targetY - len1 * len1 - len2 * len2) / cosDenom, -1.0f, 1.0f);
        float adjacent = len1 + len2 * cos;
        float parentAngle = (float)Math.atan2(targetY * adjacent - targetX * (opposite = len2 * MathUtils.sin(childAngle = (float)Math.acos(cos) * (float)bendDirection)), targetX * adjacent + targetY * opposite);
        float rotation = (parentAngle - offset) * 57.295776f - parentRotation;
        if (rotation > 180.0f) {
            rotation -= 360.0f;
        } else if (rotation < -180.0f) {
            rotation += 360.0f;
        }
        parent.rotationIK = parentRotation + rotation * alpha;
        rotation = (childAngle + offset) * 57.295776f - childRotation;
        if (rotation > 180.0f) {
            rotation -= 360.0f;
        } else if (rotation < -180.0f) {
            rotation += 360.0f;
        }
        child.rotationIK = childRotation + (rotation + parent.worldRotation - child.parent.worldRotation) * alpha;
    }
}

