/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FlushablePool;
import org.junit.Assert;
import org.junit.Test;

public class FlushablePoolTest {
    @Test
    public void initializeFlushablePoolTest1() {
        FlushablePoolClass flushablePool = new FlushablePoolClass();
        Assert.assertEquals((long)0L, (long)flushablePool.getFree());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)flushablePool.max);
    }

    @Test
    public void initializeFlushablePoolTest2() {
        FlushablePoolClass flushablePool = new FlushablePoolClass(10);
        Assert.assertEquals((long)0L, (long)flushablePool.getFree());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)flushablePool.max);
    }

    @Test
    public void initializeFlushablePoolTest3() {
        FlushablePoolClass flushablePool = new FlushablePoolClass(10, 10);
        Assert.assertEquals((long)0L, (long)flushablePool.getFree());
        Assert.assertEquals((long)10L, (long)flushablePool.max);
    }

    @Test
    public void obtainTest() {
        FlushablePoolClass flushablePool = new FlushablePoolClass(10, 10);
        flushablePool.newObject();
        Assert.assertEquals((long)0L, (long)flushablePool.obtained.size);
        flushablePool.obtain();
        Assert.assertEquals((long)1L, (long)flushablePool.obtained.size);
        flushablePool.flush();
        Assert.assertEquals((long)0L, (long)flushablePool.obtained.size);
    }

    @Test
    public void flushTest() {
        FlushablePoolClass flushablePool = new FlushablePoolClass(10, 10);
        flushablePool.newObject();
        flushablePool.obtain();
        Assert.assertEquals((long)1L, (long)flushablePool.obtained.size);
        flushablePool.flush();
        Assert.assertEquals((long)0L, (long)flushablePool.obtained.size);
    }

    @Test
    public void freeTest() {
        FlushablePoolClass flushablePool = new FlushablePoolClass(10, 10);
        flushablePool.newObject();
        flushablePool.newObject();
        String element1 = (String)flushablePool.obtain();
        String element2 = (String)flushablePool.obtain();
        Assert.assertTrue((boolean)flushablePool.obtained.contains(element1, true));
        Assert.assertTrue((boolean)flushablePool.obtained.contains(element2, true));
        flushablePool.free(element2);
        Assert.assertTrue((boolean)flushablePool.obtained.contains(element1, true));
        Assert.assertFalse((boolean)flushablePool.obtained.contains(element2, true));
    }

    @Test
    public void freeAllTest() {
        FlushablePoolClass flushablePool = new FlushablePoolClass(5, 5);
        flushablePool.newObject();
        flushablePool.newObject();
        String element1 = (String)flushablePool.obtain();
        String element2 = (String)flushablePool.obtain();
        Array<String> elementArray = new Array<String>();
        elementArray.add(element1);
        elementArray.add(element2);
        Assert.assertTrue((boolean)flushablePool.obtained.contains(element1, true));
        Assert.assertTrue((boolean)flushablePool.obtained.contains(element2, true));
        flushablePool.freeAll(elementArray);
        Assert.assertFalse((boolean)flushablePool.obtained.contains(element1, true));
        Assert.assertFalse((boolean)flushablePool.obtained.contains(element2, true));
    }

    private class FlushablePoolClass
    extends FlushablePool<String> {
        FlushablePoolClass() {
        }

        FlushablePoolClass(int initialCapacity) {
            super(initialCapacity);
        }

        FlushablePoolClass(int initialCapacity, int max) {
            super(initialCapacity, max);
        }

        @Override
        protected String newObject() {
            return Integer.toString(this.getFree());
        }
    }
}

