/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnimationDescTest {
    private static final float epsilon = 1.0E-6f;
    private AnimationController.AnimationDesc anim;

    @Before
    public void setup() {
        this.anim = new AnimationController.AnimationDesc();
        this.anim.animation = new Animation();
        this.anim.duration = 1.0f;
        this.anim.listener = null;
        this.anim.loopCount = 1;
        this.anim.offset = 0.0f;
        this.anim.speed = 1.0f;
        this.anim.time = 0.0f;
    }

    @Test
    public void testUpdateNominal() {
        Assert.assertEquals((float)-1.0f, (float)this.anim.update(0.75f), (float)1.0E-6f);
        Assert.assertEquals((float)0.5f, (float)this.anim.update(0.75f), (float)1.0E-6f);
        Assert.assertEquals((float)0.75f, (float)this.anim.update(0.75f), (float)1.0E-6f);
    }

    @Test
    public void testUpdateJustEnd() {
        Assert.assertEquals((float)-1.0f, (float)this.anim.update(0.5f), (float)1.0E-6f);
        Assert.assertEquals((float)0.0f, (float)this.anim.update(0.5f), (float)1.0E-6f);
        Assert.assertEquals((float)0.5f, (float)this.anim.update(0.5f), (float)1.0E-6f);
    }

    @Test
    public void testUpdateBigDelta() {
        Assert.assertEquals((float)4.2f, (float)this.anim.update(5.2f), (float)1.0E-6f);
        Assert.assertEquals((float)7.3f, (float)this.anim.update(7.3f), (float)1.0E-6f);
    }

    @Test
    public void testUpdateZeroDelta() {
        Assert.assertEquals((float)-1.0f, (float)this.anim.update(0.0f), (float)1.0E-6f);
        Assert.assertEquals((float)0.0f, (float)this.anim.time, (float)1.0E-6f);
    }

    @Test
    public void testUpdateReverseNominal() {
        this.anim.speed = -1.0f;
        this.anim.time = this.anim.duration;
        Assert.assertEquals((float)-1.0f, (float)this.anim.update(0.75f), (float)1.0E-6f);
        Assert.assertEquals((float)0.5f, (float)this.anim.update(0.75f), (float)1.0E-6f);
        Assert.assertEquals((float)0.75f, (float)this.anim.update(0.75f), (float)1.0E-6f);
    }

    @Test
    public void testUpdateReverseJustEnd() {
        this.anim.speed = -1.0f;
        this.anim.time = this.anim.duration;
        Assert.assertEquals((float)-1.0f, (float)this.anim.update(0.5f), (float)1.0E-6f);
        Assert.assertEquals((float)0.0f, (float)this.anim.update(0.5f), (float)1.0E-6f);
        Assert.assertEquals((float)0.5f, (float)this.anim.update(0.5f), (float)1.0E-6f);
    }

    @Test
    public void testUpdateReverseBigDelta() {
        this.anim.speed = -1.0f;
        this.anim.time = this.anim.duration;
        Assert.assertEquals((float)4.2f, (float)this.anim.update(5.2f), (float)1.0E-6f);
        Assert.assertEquals((float)7.3f, (float)this.anim.update(7.3f), (float)1.0E-6f);
    }

    @Test
    public void testUpdateReverseZeroDelta() {
        this.anim.speed = -1.0f;
        this.anim.time = this.anim.duration;
        Assert.assertEquals((float)-1.0f, (float)this.anim.update(0.0f), (float)1.0E-6f);
        Assert.assertEquals((float)this.anim.duration, (float)this.anim.time, (float)1.0E-6f);
    }
}

